/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class S7PayloadUserDataItemCpuFunctionAlarmQuery extends S7PayloadUserDataItem
    implements Message {

  // Accessors for discriminator values.
  public Byte getCpuFunctionType() {
    return (byte) 0x04;
  }

  public Short getCpuSubfunction() {
    return (short) 0x13;
  }

  public Integer getDataLength() {
    return 0;
  }

  // Constant values.
  public static final Short FUNCTIONID = 0x00;
  public static final Short NUMBERMESSAGEOBJ = 0x01;
  public static final Short VARIABLESPEC = 0x12;
  public static final Short LENGTH = 0x08;

  // Properties.
  protected final SyntaxIdType syntaxId;
  protected final QueryType queryType;
  protected final AlarmType alarmType;
  // Reserved Fields
  private Short reservedField0;
  private Short reservedField1;

  public S7PayloadUserDataItemCpuFunctionAlarmQuery(
      DataTransportErrorCode returnCode,
      DataTransportSize transportSize,
      SyntaxIdType syntaxId,
      QueryType queryType,
      AlarmType alarmType) {
    super(returnCode, transportSize);
    this.syntaxId = syntaxId;
    this.queryType = queryType;
    this.alarmType = alarmType;
  }

  public SyntaxIdType getSyntaxId() {
    return syntaxId;
  }

  public QueryType getQueryType() {
    return queryType;
  }

  public AlarmType getAlarmType() {
    return alarmType;
  }

  public short getFunctionId() {
    return FUNCTIONID;
  }

  public short getNumberMessageObj() {
    return NUMBERMESSAGEOBJ;
  }

  public short getVariableSpec() {
    return VARIABLESPEC;
  }

  public short getLength() {
    return LENGTH;
  }

  @Override
  protected void serializeS7PayloadUserDataItemChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("S7PayloadUserDataItemCpuFunctionAlarmQuery");

    // Const Field (functionId)
    writeConstField("functionId", FUNCTIONID, writeUnsignedShort(writeBuffer, 8));

    // Const Field (numberMessageObj)
    writeConstField("numberMessageObj", NUMBERMESSAGEOBJ, writeUnsignedShort(writeBuffer, 8));

    // Const Field (variableSpec)
    writeConstField("variableSpec", VARIABLESPEC, writeUnsignedShort(writeBuffer, 8));

    // Const Field (length)
    writeConstField("length", LENGTH, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (syntaxId)
    writeSimpleEnumField(
        "syntaxId",
        "SyntaxIdType",
        syntaxId,
        new DataWriterEnumDefault<>(
            SyntaxIdType::getValue, SyntaxIdType::name, writeUnsignedShort(writeBuffer, 8)));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 8));

    // Simple Field (queryType)
    writeSimpleEnumField(
        "queryType",
        "QueryType",
        queryType,
        new DataWriterEnumDefault<>(
            QueryType::getValue, QueryType::name, writeUnsignedShort(writeBuffer, 8)));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (short) 0x34,
        writeUnsignedShort(writeBuffer, 8));

    // Simple Field (alarmType)
    writeSimpleEnumField(
        "alarmType",
        "AlarmType",
        alarmType,
        new DataWriterEnumDefault<>(
            AlarmType::getValue, AlarmType::name, writeUnsignedShort(writeBuffer, 8)));

    writeBuffer.popContext("S7PayloadUserDataItemCpuFunctionAlarmQuery");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    S7PayloadUserDataItemCpuFunctionAlarmQuery _value = this;

    // Const Field (functionId)
    lengthInBits += 8;

    // Const Field (numberMessageObj)
    lengthInBits += 8;

    // Const Field (variableSpec)
    lengthInBits += 8;

    // Const Field (length)
    lengthInBits += 8;

    // Simple field (syntaxId)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (queryType)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (alarmType)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static S7PayloadUserDataItemCpuFunctionAlarmQueryBuilder staticParseBuilder(
      ReadBuffer readBuffer, Byte cpuFunctionType, Short cpuSubfunction) throws ParseException {
    readBuffer.pullContext("S7PayloadUserDataItemCpuFunctionAlarmQuery");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short functionId =
        readConstField(
            "functionId",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQuery.FUNCTIONID);

    short numberMessageObj =
        readConstField(
            "numberMessageObj",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQuery.NUMBERMESSAGEOBJ);

    short variableSpec =
        readConstField(
            "variableSpec",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQuery.VARIABLESPEC);

    short length =
        readConstField(
            "length",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQuery.LENGTH);

    SyntaxIdType syntaxId =
        readEnumField(
            "syntaxId",
            "SyntaxIdType",
            new DataReaderEnumDefault<>(
                SyntaxIdType::enumForValue, readUnsignedShort(readBuffer, 8)));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    QueryType queryType =
        readEnumField(
            "queryType",
            "QueryType",
            new DataReaderEnumDefault<>(QueryType::enumForValue, readUnsignedShort(readBuffer, 8)));

    Short reservedField1 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x34);

    AlarmType alarmType =
        readEnumField(
            "alarmType",
            "AlarmType",
            new DataReaderEnumDefault<>(AlarmType::enumForValue, readUnsignedShort(readBuffer, 8)));

    readBuffer.closeContext("S7PayloadUserDataItemCpuFunctionAlarmQuery");
    // Create the instance
    return new S7PayloadUserDataItemCpuFunctionAlarmQueryBuilder(
        syntaxId, queryType, alarmType, reservedField0, reservedField1);
  }

  public static class S7PayloadUserDataItemCpuFunctionAlarmQueryBuilder
      implements S7PayloadUserDataItem.S7PayloadUserDataItemBuilder {
    private final SyntaxIdType syntaxId;
    private final QueryType queryType;
    private final AlarmType alarmType;
    private final Short reservedField0;
    private final Short reservedField1;

    public S7PayloadUserDataItemCpuFunctionAlarmQueryBuilder(
        SyntaxIdType syntaxId,
        QueryType queryType,
        AlarmType alarmType,
        Short reservedField0,
        Short reservedField1) {
      this.syntaxId = syntaxId;
      this.queryType = queryType;
      this.alarmType = alarmType;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
    }

    public S7PayloadUserDataItemCpuFunctionAlarmQuery build(
        DataTransportErrorCode returnCode, DataTransportSize transportSize) {
      S7PayloadUserDataItemCpuFunctionAlarmQuery s7PayloadUserDataItemCpuFunctionAlarmQuery =
          new S7PayloadUserDataItemCpuFunctionAlarmQuery(
              returnCode, transportSize, syntaxId, queryType, alarmType);
      s7PayloadUserDataItemCpuFunctionAlarmQuery.reservedField0 = reservedField0;
      s7PayloadUserDataItemCpuFunctionAlarmQuery.reservedField1 = reservedField1;
      return s7PayloadUserDataItemCpuFunctionAlarmQuery;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7PayloadUserDataItemCpuFunctionAlarmQuery)) {
      return false;
    }
    S7PayloadUserDataItemCpuFunctionAlarmQuery that =
        (S7PayloadUserDataItemCpuFunctionAlarmQuery) o;
    return (getSyntaxId() == that.getSyntaxId())
        && (getQueryType() == that.getQueryType())
        && (getAlarmType() == that.getAlarmType())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getSyntaxId(), getQueryType(), getAlarmType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
