/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class S7PayloadUserDataItemCpuFunctionAlarmQueryResponse extends S7PayloadUserDataItem
    implements Message {

  // Accessors for discriminator values.
  public Byte getCpuFunctionType() {
    return (byte) 0x08;
  }

  public Short getCpuSubfunction() {
    return (short) 0x13;
  }

  public Integer getDataLength() {
    return 0;
  }

  // Constant values.
  public static final Short FUNCTIONID = 0x00;
  public static final Short NUMBERMESSAGEOBJ = 0x01;

  // Properties.
  protected final DataTransportErrorCode pudicfReturnCode;
  protected final DataTransportSize pudicftransportSize;
  // Reserved Fields
  private Short reservedField0;

  public S7PayloadUserDataItemCpuFunctionAlarmQueryResponse(
      DataTransportErrorCode returnCode,
      DataTransportSize transportSize,
      DataTransportErrorCode pudicfReturnCode,
      DataTransportSize pudicftransportSize) {
    super(returnCode, transportSize);
    this.pudicfReturnCode = pudicfReturnCode;
    this.pudicftransportSize = pudicftransportSize;
  }

  public DataTransportErrorCode getPudicfReturnCode() {
    return pudicfReturnCode;
  }

  public DataTransportSize getPudicftransportSize() {
    return pudicftransportSize;
  }

  public short getFunctionId() {
    return FUNCTIONID;
  }

  public short getNumberMessageObj() {
    return NUMBERMESSAGEOBJ;
  }

  @Override
  protected void serializeS7PayloadUserDataItemChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("S7PayloadUserDataItemCpuFunctionAlarmQueryResponse");

    // Const Field (functionId)
    writeConstField("functionId", FUNCTIONID, writeUnsignedShort(writeBuffer, 8));

    // Const Field (numberMessageObj)
    writeConstField("numberMessageObj", NUMBERMESSAGEOBJ, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (pudicfReturnCode)
    writeSimpleEnumField(
        "pudicfReturnCode",
        "DataTransportErrorCode",
        pudicfReturnCode,
        new DataWriterEnumDefault<>(
            DataTransportErrorCode::getValue,
            DataTransportErrorCode::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (pudicftransportSize)
    writeSimpleEnumField(
        "pudicftransportSize",
        "DataTransportSize",
        pudicftransportSize,
        new DataWriterEnumDefault<>(
            DataTransportSize::getValue,
            DataTransportSize::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("S7PayloadUserDataItemCpuFunctionAlarmQueryResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    S7PayloadUserDataItemCpuFunctionAlarmQueryResponse _value = this;

    // Const Field (functionId)
    lengthInBits += 8;

    // Const Field (numberMessageObj)
    lengthInBits += 8;

    // Simple field (pudicfReturnCode)
    lengthInBits += 8;

    // Simple field (pudicftransportSize)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Byte cpuFunctionType, Short cpuSubfunction) throws ParseException {
    readBuffer.pullContext("S7PayloadUserDataItemCpuFunctionAlarmQueryResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short functionId =
        readConstField(
            "functionId",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQueryResponse.FUNCTIONID);

    short numberMessageObj =
        readConstField(
            "numberMessageObj",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQueryResponse.NUMBERMESSAGEOBJ);

    DataTransportErrorCode pudicfReturnCode =
        readEnumField(
            "pudicfReturnCode",
            "DataTransportErrorCode",
            new DataReaderEnumDefault<>(
                DataTransportErrorCode::enumForValue, readUnsignedShort(readBuffer, 8)));

    DataTransportSize pudicftransportSize =
        readEnumField(
            "pudicftransportSize",
            "DataTransportSize",
            new DataReaderEnumDefault<>(
                DataTransportSize::enumForValue, readUnsignedShort(readBuffer, 8)));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    readBuffer.closeContext("S7PayloadUserDataItemCpuFunctionAlarmQueryResponse");
    // Create the instance
    return new S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder(
        pudicfReturnCode, pudicftransportSize, reservedField0);
  }

  public static class S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder
      implements S7PayloadUserDataItem.S7PayloadUserDataItemBuilder {
    private final DataTransportErrorCode pudicfReturnCode;
    private final DataTransportSize pudicftransportSize;
    private final Short reservedField0;

    public S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder(
        DataTransportErrorCode pudicfReturnCode,
        DataTransportSize pudicftransportSize,
        Short reservedField0) {
      this.pudicfReturnCode = pudicfReturnCode;
      this.pudicftransportSize = pudicftransportSize;
      this.reservedField0 = reservedField0;
    }

    public S7PayloadUserDataItemCpuFunctionAlarmQueryResponse build(
        DataTransportErrorCode returnCode, DataTransportSize transportSize) {
      S7PayloadUserDataItemCpuFunctionAlarmQueryResponse
          s7PayloadUserDataItemCpuFunctionAlarmQueryResponse =
              new S7PayloadUserDataItemCpuFunctionAlarmQueryResponse(
                  returnCode, transportSize, pudicfReturnCode, pudicftransportSize);
      s7PayloadUserDataItemCpuFunctionAlarmQueryResponse.reservedField0 = reservedField0;
      return s7PayloadUserDataItemCpuFunctionAlarmQueryResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)) {
      return false;
    }
    S7PayloadUserDataItemCpuFunctionAlarmQueryResponse that =
        (S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) o;
    return (getPudicfReturnCode() == that.getPudicfReturnCode())
        && (getPudicftransportSize() == that.getPudicftransportSize())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPudicfReturnCode(), getPudicftransportSize());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
