/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class S7PayloadUserDataItemCpuFunctionReadSzlResponse extends S7PayloadUserDataItem
    implements Message {

  // Accessors for discriminator values.
  public Byte getCpuFunctionType() {
    return (byte) 0x08;
  }

  public Short getCpuSubfunction() {
    return (short) 0x01;
  }

  public Integer getDataLength() {
    return 0;
  }

  // Constant values.
  public static final Integer SZLITEMLENGTH = 28;

  // Properties.
  protected final SzlId szlId;
  protected final int szlIndex;
  protected final List<SzlDataTreeItem> items;

  public S7PayloadUserDataItemCpuFunctionReadSzlResponse(
      DataTransportErrorCode returnCode,
      DataTransportSize transportSize,
      SzlId szlId,
      int szlIndex,
      List<SzlDataTreeItem> items) {
    super(returnCode, transportSize);
    this.szlId = szlId;
    this.szlIndex = szlIndex;
    this.items = items;
  }

  public SzlId getSzlId() {
    return szlId;
  }

  public int getSzlIndex() {
    return szlIndex;
  }

  public List<SzlDataTreeItem> getItems() {
    return items;
  }

  public int getSzlItemLength() {
    return SZLITEMLENGTH;
  }

  @Override
  protected void serializeS7PayloadUserDataItemChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("S7PayloadUserDataItemCpuFunctionReadSzlResponse");

    // Simple Field (szlId)
    writeSimpleField("szlId", szlId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (szlIndex)
    writeSimpleField("szlIndex", szlIndex, writeUnsignedInt(writeBuffer, 16));

    // Const Field (szlItemLength)
    writeConstField("szlItemLength", SZLITEMLENGTH, writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (szlItemCount) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int szlItemCount = (int) (COUNT(getItems()));
    writeImplicitField("szlItemCount", szlItemCount, writeUnsignedInt(writeBuffer, 16));

    // Array Field (items)
    writeComplexTypeArrayField("items", items, writeBuffer);

    writeBuffer.popContext("S7PayloadUserDataItemCpuFunctionReadSzlResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    S7PayloadUserDataItemCpuFunctionReadSzlResponse _value = this;

    // Simple field (szlId)
    lengthInBits += szlId.getLengthInBits();

    // Simple field (szlIndex)
    lengthInBits += 16;

    // Const Field (szlItemLength)
    lengthInBits += 16;

    // Implicit Field (szlItemCount)
    lengthInBits += 16;

    // Array field
    if (items != null) {
      int i = 0;
      for (SzlDataTreeItem element : items) {
        boolean last = ++i >= items.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static S7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Byte cpuFunctionType, Short cpuSubfunction) throws ParseException {
    readBuffer.pullContext("S7PayloadUserDataItemCpuFunctionReadSzlResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    SzlId szlId =
        readSimpleField(
            "szlId",
            new DataReaderComplexDefault<>(() -> SzlId.staticParse(readBuffer), readBuffer));

    int szlIndex = readSimpleField("szlIndex", readUnsignedInt(readBuffer, 16));

    int szlItemLength =
        readConstField(
            "szlItemLength",
            readUnsignedInt(readBuffer, 16),
            S7PayloadUserDataItemCpuFunctionReadSzlResponse.SZLITEMLENGTH);

    int szlItemCount = readImplicitField("szlItemCount", readUnsignedInt(readBuffer, 16));

    List<SzlDataTreeItem> items =
        readCountArrayField(
            "items",
            new DataReaderComplexDefault<>(
                () -> SzlDataTreeItem.staticParse(readBuffer), readBuffer),
            szlItemCount);

    readBuffer.closeContext("S7PayloadUserDataItemCpuFunctionReadSzlResponse");
    // Create the instance
    return new S7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder(szlId, szlIndex, items);
  }

  public static class S7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder
      implements S7PayloadUserDataItem.S7PayloadUserDataItemBuilder {
    private final SzlId szlId;
    private final int szlIndex;
    private final List<SzlDataTreeItem> items;

    public S7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder(
        SzlId szlId, int szlIndex, List<SzlDataTreeItem> items) {

      this.szlId = szlId;
      this.szlIndex = szlIndex;
      this.items = items;
    }

    public S7PayloadUserDataItemCpuFunctionReadSzlResponse build(
        DataTransportErrorCode returnCode, DataTransportSize transportSize) {
      S7PayloadUserDataItemCpuFunctionReadSzlResponse
          s7PayloadUserDataItemCpuFunctionReadSzlResponse =
              new S7PayloadUserDataItemCpuFunctionReadSzlResponse(
                  returnCode, transportSize, szlId, szlIndex, items);
      return s7PayloadUserDataItemCpuFunctionReadSzlResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7PayloadUserDataItemCpuFunctionReadSzlResponse)) {
      return false;
    }
    S7PayloadUserDataItemCpuFunctionReadSzlResponse that =
        (S7PayloadUserDataItemCpuFunctionReadSzlResponse) o;
    return (getSzlId() == that.getSzlId())
        && (getSzlIndex() == that.getSzlIndex())
        && (getItems() == that.getItems())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getSzlId(), getSzlIndex(), getItems());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
