/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.configuration.S7Configuration;
import org.apache.plc4x.java.s7.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7.readwrite.field.S7Field;
import org.apache.plc4x.java.s7.readwrite.field.S7PlcFieldHandler;
import org.apache.plc4x.java.s7.readwrite.optimizer.S7Optimizer;
import org.apache.plc4x.java.s7.readwrite.protocol.S7ProtocolLogic;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;

public class S7Driver
extends GeneratedDriverBase<TPKTPacket> {
    public static final int ISO_ON_TCP_PORT = 102;

    public String getProtocolCode() {
        return "s7";
    }

    public String getProtocolName() {
        return "Siemens S7 (Basic)";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return S7Configuration.class;
    }

    protected String getDefaultTransport() {
        return "tcp";
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new S7Optimizer();
    }

    protected S7PlcFieldHandler getFieldHandler() {
        return new S7PlcFieldHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new IEC61131ValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected ProtocolStackConfigurer<TPKTPacket> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(TPKTPacket.class, TPKTPacket::staticParse).withProtocol(S7ProtocolLogic.class).withDriverContext(S7DriverContext.class).withPacketSizeEstimator(ByteLengthEstimator.class).withCorruptPacketRemover(CorruptPackageCleaner.class).build();
    }

    public S7Field prepareField(String query) {
        return S7Field.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 2);
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != TPKTPacket.PROTOCOLID.shortValue()) {
                byteBuf.readByte();
            }
        }
    }
}

