/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.AlarmStateType;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketData;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCalledTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCallingTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterTpduSize;
import org.apache.plc4x.java.s7.readwrite.COTPProtocolClass;
import org.apache.plc4x.java.s7.readwrite.COTPTpduSize;
import org.apache.plc4x.java.s7.readwrite.DataItem;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.DataTransportSize;
import org.apache.plc4x.java.s7.readwrite.EventType;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponse;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7MessageUserData;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7ParameterModeTransition;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterSetupCommunication;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItemCPUFunctions;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadDiagnosticMessage;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserData;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscription;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadDataItem;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadStatusItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItemAddress;
import org.apache.plc4x.java.s7.readwrite.SzlDataTreeItem;
import org.apache.plc4x.java.s7.readwrite.SzlId;
import org.apache.plc4x.java.s7.readwrite.SzlModuleTypeClass;
import org.apache.plc4x.java.s7.readwrite.SzlSublist;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7.readwrite.field.S7Field;
import org.apache.plc4x.java.s7.readwrite.field.S7StringField;
import org.apache.plc4x.java.s7.readwrite.field.S7SubscriptionField;
import org.apache.plc4x.java.s7.readwrite.protocol.S7ProtocolEventLogic;
import org.apache.plc4x.java.s7.readwrite.types.S7ControllerType;
import org.apache.plc4x.java.s7.readwrite.utils.S7PlcSubscriptionHandle;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7ProtocolLogic
extends Plc4xProtocolBase<TPKTPacket> {
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private final Logger logger = LoggerFactory.getLogger(S7ProtocolLogic.class);
    private final AtomicInteger tpduGenerator = new AtomicInteger(10);
    private final BlockingQueue<Message> eventQueue = new ArrayBlockingQueue<Message>(1024);
    private final S7ProtocolEventLogic EventLogic = new S7ProtocolEventLogic(this.eventQueue);
    private final S7PlcSubscriptionHandle modeHandle = new S7PlcSubscriptionHandle(EventType.MODE, this.EventLogic);
    private final S7PlcSubscriptionHandle sysHandle = new S7PlcSubscriptionHandle(EventType.SYS, this.EventLogic);
    private final S7PlcSubscriptionHandle usrHandle = new S7PlcSubscriptionHandle(EventType.USR, this.EventLogic);
    private final S7PlcSubscriptionHandle almHandle = new S7PlcSubscriptionHandle(EventType.ALM, this.EventLogic);
    private S7DriverContext s7DriverContext;
    private RequestTransactionManager tm;

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        this.s7DriverContext = (S7DriverContext)driverContext;
        this.tm = new RequestTransactionManager(1);
        this.EventLogic.start();
    }

    public void onConnect(ConversationContext<TPKTPacket> context) {
        if (context.isPassive()) {
            this.logger.info("S7 Driver running in PASSIVE mode.");
            this.s7DriverContext.setPassiveMode(true);
            context.fireConnected();
            return;
        }
        this.logger.info("S7 Driver running in ACTIVE mode.");
        this.logger.debug("Sending COTP Connection Request");
        TPKTPacket packet = new TPKTPacket(this.createCOTPConnectionRequest(this.s7DriverContext.getCalledTsapId(), this.s7DriverContext.getCallingTsapId(), this.s7DriverContext.getCotpTpduSize()));
        context.sendRequest((Object)packet).onTimeout(e -> {
            this.logger.warn("Timeout during Connection establishing, closing channel...");
            context.getChannel().close();
        }).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketConnectionResponse).unwrap(p -> (COTPPacketConnectionResponse)p.getPayload()).handle(cotpPacketConnectionResponse -> {
            this.logger.debug("Got COTP Connection Response");
            this.logger.debug("Sending S7 Connection Request");
            context.sendRequest((Object)this.createS7ConnectionRequest((COTPPacketConnectionResponse)cotpPacketConnectionResponse)).onTimeout(e -> {
                this.logger.warn("Timeout during Connection establishing, closing channel...");
                context.getChannel().close();
            }).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).only(S7MessageResponseData.class).unwrap(S7Message::getParameter).only(S7ParameterSetupCommunication.class).handle(setupCommunication -> {
                this.logger.debug("Got S7 Connection Response");
                this.s7DriverContext.setMaxAmqCaller(setupCommunication.getMaxAmqCaller());
                this.s7DriverContext.setMaxAmqCallee(setupCommunication.getMaxAmqCallee());
                this.s7DriverContext.setPduSize(setupCommunication.getPduLength());
                this.tm.setNumberOfConcurrentRequests(this.s7DriverContext.getMaxAmqCallee());
                if (this.s7DriverContext.getControllerType() != S7ControllerType.ANY) {
                    context.fireConnected();
                    return;
                }
                this.logger.debug("Sending S7 Identification Request");
                TPKTPacket tpktPacket = this.createIdentifyRemoteMessage();
                context.sendRequest((Object)tpktPacket).onTimeout(e -> {
                    this.logger.warn("Timeout during Connection establishing, closing channel...");
                    context.getChannel().close();
                }).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).check(p -> p.getPayload() instanceof S7MessageUserData).unwrap(p -> (S7MessageUserData)p.getPayload()).check(p -> p.getPayload() instanceof S7PayloadUserData).handle(messageUserData -> {
                    this.logger.debug("Got S7 Identification Response");
                    S7PayloadUserData payloadUserData = (S7PayloadUserData)messageUserData.getPayload();
                    this.extractControllerTypeAndFireConnected(context, payloadUserData);
                });
            });
        });
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        ArrayList<S7VarRequestParameterItem> requestItems = new ArrayList<S7VarRequestParameterItem>(request.getNumberOfFields());
        for (PlcField field : request.getFields()) {
            requestItems.add(new S7VarRequestParameterItemAddress(this.encodeS7Address(field)));
        }
        S7MessageRequest s7MessageRequest = new S7MessageRequest(-1, new S7ParameterReadVarRequest(requestItems), null);
        return this.toPlcReadResponse(readRequest, this.readInternal(s7MessageRequest));
    }

    private CompletableFuture<PlcReadResponse> toPlcReadResponse(PlcReadRequest readRequest, CompletableFuture<S7Message> response) {
        return response.thenApply(p -> {
            try {
                return (PlcReadResponse)this.decodeReadResponse((S7Message)p, readRequest);
            }
            catch (PlcProtocolException e) {
                throw new PlcRuntimeException("Unable to decode Response", (Throwable)e);
            }
        });
    }

    private CompletableFuture<S7Message> readInternal(S7MessageRequest request) {
        CompletableFuture<S7Message> future = new CompletableFuture<S7Message>();
        int tpduId = this.tpduGenerator.getAndIncrement();
        if (this.tpduGenerator.get() == 65535) {
            this.tpduGenerator.set(1);
        }
        S7MessageRequest s7MessageRequest = new S7MessageRequest(tpduId, request.getParameter(), request.getPayload());
        TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, s7MessageRequest, true, (short)tpduId, Integer.MAX_VALUE));
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.context.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).check(p -> p.getPayload() != null).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
            future.complete((S7Message)p);
            transaction.endRequest();
        }));
        return future;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        ArrayList<S7VarRequestParameterItem> parameterItems = new ArrayList<S7VarRequestParameterItem>(request.getNumberOfFields());
        ArrayList<S7VarPayloadDataItem> payloadItems = new ArrayList<S7VarPayloadDataItem>(request.getNumberOfFields());
        for (String fieldName : request.getFieldNames()) {
            S7Field field = (S7Field)request.getField(fieldName);
            PlcValue plcValue = request.getPlcValue(fieldName);
            parameterItems.add(new S7VarRequestParameterItemAddress(this.encodeS7Address(field)));
            payloadItems.add(this.serializePlcValue(field, plcValue));
        }
        int tpduId = this.tpduGenerator.getAndIncrement();
        if (this.tpduGenerator.get() == 65535) {
            this.tpduGenerator.set(1);
        }
        TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, new S7MessageRequest(tpduId, new S7ParameterWriteVarRequest(parameterItems), new S7PayloadWriteVarRequest(payloadItems, null)), true, (short)tpduId, Integer.MAX_VALUE));
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.context.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
            try {
                future.complete((PlcWriteResponse)this.decodeWriteResponse((S7Message)p, writeRequest));
            }
            catch (PlcProtocolException e) {
                this.logger.warn("Error sending 'write' message: '{}'", (Object)e.getMessage(), (Object)e);
            }
            transaction.endRequest();
        }));
        return future;
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
        DefaultPlcSubscriptionRequest request = (DefaultPlcSubscriptionRequest)subscriptionRequest;
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfFields());
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfFields());
        for (String fieldName : request.getFieldNames()) {
            DefaultPlcSubscriptionField sf = (DefaultPlcSubscriptionField)request.getField(fieldName);
            S7SubscriptionField field = (S7SubscriptionField)sf.getPlcField();
            switch (field.getFieldType()) {
                case EVENT_SUBSCRIPTION: {
                    this.encodeEventSubscriptionRequest(request, parameterItems, payloadItems);
                    break;
                }
                case EVENT_UNSUBSCRIPTION: {
                    break;
                }
                case ALARM_ACK: {
                    break;
                }
                case ALARM_QUERY: {
                    break;
                }
                case CYCLIC_SUBSCRIPTION: {
                    break;
                }
                case CYCLIC_UNSUBSCRIPTION: {
                    break;
                }
            }
        }
        int tpduId = this.tpduGenerator.getAndIncrement();
        if (this.tpduGenerator.get() == 65535) {
            this.tpduGenerator.set(1);
        }
        TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, new S7MessageUserData(tpduId, new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems, null)), true, (short)tpduId, null));
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.context.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
            try {
                future.complete(this.decodeEventSubscriptionRequest((S7Message)p, subscriptionRequest));
            }
            catch (PlcProtocolException e) {
                this.logger.warn("Error sending 'write' message: '{}'", (Object)e.getMessage(), (Object)e);
            }
            transaction.endRequest();
        }));
        return future;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        CompletableFuture<PlcUnsubscriptionResponse> future = new CompletableFuture<PlcUnsubscriptionResponse>();
        DefaultPlcUnsubscriptionRequest request = (DefaultPlcUnsubscriptionRequest)unsubscriptionRequest;
        return future;
    }

    private void encodeEventSubscriptionRequest(DefaultPlcSubscriptionRequest request, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItems) {
        S7PayloadUserDataItemCpuFunctionMsgSubscription payload;
        int subsevent = 0;
        for (String fieldName : request.getFieldNames()) {
            PlcField event;
            if (!(request.getField(fieldName) instanceof DefaultPlcSubscriptionField) || !((event = ((DefaultPlcSubscriptionField)request.getField(fieldName)).getPlcField()) instanceof S7SubscriptionField)) continue;
            subsevent = (byte)(subsevent | ((S7SubscriptionField)event).getEventType().getValue());
        }
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 2, 0, null, null, null);
        parameterItems.clear();
        parameterItems.add(parameter);
        if (subsevent > 0) {
            payload = new S7PayloadUserDataItemCpuFunctionMsgSubscription(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, (short)subsevent, "HmiRtm  ", null, null);
        } else {
            AlarmStateType alarmtype = this.s7DriverContext.getControllerType() == S7ControllerType.S7_400 ? AlarmStateType.ALARM_INITIATE : AlarmStateType.ALARM_S_INITIATE;
            payload = new S7PayloadUserDataItemCpuFunctionMsgSubscription(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, (short)subsevent, "HmiRtm  ", alarmtype, (short)0);
        }
        payloadItems.clear();
        payloadItems.add(payload);
    }

    private PlcSubscriptionResponse decodeEventSubscriptionRequest(S7Message responseMessage, PlcSubscriptionRequest plcSubscriptionRequest) throws PlcProtocolException {
        S7PayloadUserDataItem item;
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        short errorClass = 0;
        short errorCode = 0;
        if (responseMessage instanceof S7MessageUserData) {
            S7MessageUserData messageUserData = (S7MessageUserData)responseMessage;
            S7PayloadUserData s7PayloadUserData = (S7PayloadUserData)messageUserData.getPayload();
        } else if (responseMessage instanceof S7MessageResponse) {
            Iterator messageResponse = (S7MessageResponse)responseMessage;
            errorClass = ((S7MessageResponse)((Object)messageResponse)).getErrorClass();
            errorCode = ((S7MessageResponse)((Object)messageResponse)).getErrorCode();
        } else {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                this.logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String fieldName : plcSubscriptionRequest.getFieldNames()) {
                    values.put(fieldName, null);
                }
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            this.logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String fieldName : plcSubscriptionRequest.getFieldNames()) {
                values.put(fieldName, null);
            }
            return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
        }
        S7PayloadUserData payload = (S7PayloadUserData)responseMessage.getPayload();
        List<S7PayloadUserDataItem> payloadItems = payload.getItems();
        if (payloadItems.size() == 0) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        boolean responseOk = false;
        if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse) {
            item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse)payloadItems.get(0);
            if (item.getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
                responseOk = true;
            }
        } else if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse) {
            item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse)payloadItems.get(0);
            if (item.getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
                responseOk = true;
            }
        } else if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse && (item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse)payloadItems.get(0)).getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
            responseOk = true;
        }
        if (responseOk) {
            for (String fieldName : plcSubscriptionRequest.getFieldNames()) {
                DefaultPlcSubscriptionField dfield = (DefaultPlcSubscriptionField)plcSubscriptionRequest.getField(fieldName);
                S7SubscriptionField field = (S7SubscriptionField)dfield.getPlcField();
                switch (field.getEventType()) {
                    case MODE: {
                        values.put(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)this.modeHandle));
                        break;
                    }
                    case SYS: {
                        values.put(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)this.sysHandle));
                        break;
                    }
                    case USR: {
                        values.put(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)this.usrHandle));
                        break;
                    }
                    case ALM: {
                        values.put(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)this.almHandle));
                    }
                }
            }
            return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
        }
        return null;
    }

    private void encodeEventUnSubscriptionRequest(DefaultPlcSubscriptionRequest request, List<S7VarRequestParameterItem> parameterItems, List<S7VarPayloadDataItem> payloadItems) {
    }

    private void encodeAlarmAckRequest(DefaultPlcSubscriptionRequest request, List<S7VarRequestParameterItem> parameterItems, List<S7VarPayloadDataItem> payloadItems) {
    }

    private void encodeAlarmQueryRequest(DefaultPlcSubscriptionRequest request, List<S7VarRequestParameterItem> parameterItems, List<S7VarPayloadDataItem> payloadItems) {
    }

    private void encodeCycledSubscriptionRequest(DefaultPlcSubscriptionRequest request, List<S7VarRequestParameterItem> parameterItems, List<S7VarPayloadDataItem> payloadItems) {
    }

    private void encodeCycledUnSubscriptionRequest(DefaultPlcSubscriptionRequest request, List<S7VarRequestParameterItem> parameterItems, List<S7VarPayloadDataItem> payloadItems) {
    }

    protected void decode(ConversationContext<TPKTPacket> context, TPKTPacket msg) throws Exception {
        S7Message s7msg = msg.getPayload().getPayload();
        S7Parameter parameter = s7msg.getParameter();
        if (parameter instanceof S7ParameterModeTransition) {
            this.eventQueue.add(parameter);
        } else if (parameter instanceof S7ParameterUserData) {
            S7ParameterUserData parameterud = (S7ParameterUserData)parameter;
            List<S7ParameterUserDataItem> parameterudis = parameterud.getItems();
            for (S7ParameterUserDataItem parameterudi : parameterudis) {
                List<S7PayloadUserDataItem> items;
                S7PayloadUserData payload;
                if (!(parameterudi instanceof S7ParameterUserDataItemCPUFunctions)) continue;
                S7ParameterUserDataItemCPUFunctions myparameter = (S7ParameterUserDataItemCPUFunctions)parameterudi;
                if (myparameter.getCpuFunctionType() == 0 && myparameter.getCpuSubfunction() == 3) {
                    payload = (S7PayloadUserData)s7msg.getPayload();
                    items = payload.getItems();
                    for (S7PayloadUserDataItem item : items) {
                        if (!(item instanceof S7PayloadDiagnosticMessage)) continue;
                        this.eventQueue.add(item);
                    }
                    continue;
                }
                if (myparameter.getCpuFunctionType() == 0 && (myparameter.getCpuSubfunction() == 5 || myparameter.getCpuSubfunction() == 6 || myparameter.getCpuSubfunction() == 12 || myparameter.getCpuSubfunction() == 17 || myparameter.getCpuSubfunction() == 18 || myparameter.getCpuSubfunction() == 19 || myparameter.getCpuSubfunction() == 22)) {
                    payload = (S7PayloadUserData)s7msg.getPayload();
                    items = payload.getItems();
                    this.eventQueue.addAll(items);
                    continue;
                }
                if (myparameter.getCpuFunctionType() == 0 && myparameter.getCpuSubfunction() != 19) continue;
            }
        }
    }

    public void close(ConversationContext<TPKTPacket> context) {
        this.EventLogic.stop();
    }

    private void extractControllerTypeAndFireConnected(ConversationContext<TPKTPacket> context, S7PayloadUserData payloadUserData) {
        for (S7PayloadUserDataItem item : payloadUserData.getItems()) {
            if (!(item instanceof S7PayloadUserDataItemCpuFunctionReadSzlResponse)) continue;
            S7PayloadUserDataItemCpuFunctionReadSzlResponse readSzlResponseItem = (S7PayloadUserDataItemCpuFunctionReadSzlResponse)item;
            for (SzlDataTreeItem readSzlResponseItemItem : readSzlResponseItem.getItems()) {
                if (readSzlResponseItemItem.getItemIndex() != 1) continue;
                String articleNumber = new String(readSzlResponseItemItem.getMlfb());
                this.s7DriverContext.setControllerType(this.decodeControllerType(articleNumber));
                context.fireConnected();
            }
        }
    }

    private TPKTPacket createIdentifyRemoteMessage() {
        S7MessageUserData identifyRemoteMessage = new S7MessageUserData(1, new S7ParameterUserData(Collections.singletonList(new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 1, 0, null, null, null))), new S7PayloadUserData(Collections.singletonList(new S7PayloadUserDataItemCpuFunctionReadSzlRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, new SzlId(SzlModuleTypeClass.CPU, 0, SzlSublist.MODULE_IDENTIFICATION), 0)), null));
        COTPPacketData cotpPacketData = new COTPPacketData(null, identifyRemoteMessage, true, 2, Integer.MAX_VALUE);
        return new TPKTPacket(cotpPacketData);
    }

    private TPKTPacket createS7ConnectionRequest(COTPPacketConnectionResponse cotpPacketConnectionResponse) {
        for (COTPParameter parameter : cotpPacketConnectionResponse.getParameters()) {
            if (parameter instanceof COTPParameterCalledTsap) {
                COTPParameterCalledTsap cotpParameterCalledTsap = (COTPParameterCalledTsap)parameter;
                this.s7DriverContext.setCalledTsapId(cotpParameterCalledTsap.getTsapId());
                continue;
            }
            if (parameter instanceof COTPParameterCallingTsap) {
                COTPParameterCallingTsap cotpParameterCallingTsap = (COTPParameterCallingTsap)parameter;
                if (cotpParameterCallingTsap.getTsapId() == this.s7DriverContext.getCallingTsapId()) continue;
                this.s7DriverContext.setCallingTsapId(cotpParameterCallingTsap.getTsapId());
                this.logger.warn("Switching calling TSAP id to '{}'", (Object)this.s7DriverContext.getCallingTsapId());
                continue;
            }
            if (parameter instanceof COTPParameterTpduSize) {
                COTPParameterTpduSize cotpParameterTpduSize = (COTPParameterTpduSize)parameter;
                this.s7DriverContext.setCotpTpduSize(cotpParameterTpduSize.getTpduSize());
                continue;
            }
            this.logger.warn("Got unknown parameter type '{}'", (Object)parameter.getClass().getName());
        }
        S7ParameterSetupCommunication s7ParameterSetupCommunication = new S7ParameterSetupCommunication(this.s7DriverContext.getMaxAmqCaller(), this.s7DriverContext.getMaxAmqCallee(), this.s7DriverContext.getPduSize());
        S7MessageRequest s7Message = new S7MessageRequest(0, s7ParameterSetupCommunication, null);
        COTPPacketData cotpPacketData = new COTPPacketData(null, s7Message, true, 1, Integer.MAX_VALUE);
        return new TPKTPacket(cotpPacketData);
    }

    private COTPPacketConnectionRequest createCOTPConnectionRequest(int calledTsapId, int callingTsapId, COTPTpduSize cotpTpduSize) {
        return new COTPPacketConnectionRequest(Arrays.asList(new COTPParameterCallingTsap(callingTsapId, null), new COTPParameterCalledTsap(calledTsapId, null), new COTPParameterTpduSize(cotpTpduSize, null)), null, 0, 15, COTPProtocolClass.CLASS_0, Integer.MAX_VALUE);
    }

    private PlcResponse decodeReadResponse(S7Message responseMessage, PlcReadRequest plcReadRequest) throws PlcProtocolException {
        short errorCode;
        short errorClass;
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        if (responseMessage instanceof S7MessageResponseData) {
            S7MessageResponseData messageResponseData = (S7MessageResponseData)responseMessage;
            errorClass = messageResponseData.getErrorClass();
            errorCode = messageResponseData.getErrorCode();
        } else if (responseMessage instanceof S7MessageResponse) {
            Iterator messageResponse = (S7MessageResponse)responseMessage;
            errorClass = ((S7MessageResponse)((Object)messageResponse)).getErrorClass();
            errorCode = ((S7MessageResponse)((Object)messageResponse)).getErrorCode();
        } else {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                this.logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String fieldName : plcReadRequest.getFieldNames()) {
                    ResponseItem result = new ResponseItem(PlcResponseCode.ACCESS_DENIED, (Object)new PlcNull());
                    values.put(fieldName, result);
                }
                return new DefaultPlcReadResponse(plcReadRequest, values);
            }
            this.logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String fieldName : plcReadRequest.getFieldNames()) {
                ResponseItem result = new ResponseItem(PlcResponseCode.INTERNAL_ERROR, (Object)new PlcNull());
                values.put(fieldName, result);
            }
            return new DefaultPlcReadResponse(plcReadRequest, values);
        }
        S7PayloadReadVarResponse payload = (S7PayloadReadVarResponse)responseMessage.getPayload();
        if (plcReadRequest.getNumberOfFields() != payload.getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        List<S7VarPayloadDataItem> payloadItems = payload.getItems();
        int index = 0;
        for (String fieldName : plcReadRequest.getFieldNames()) {
            S7Field field = (S7Field)plcReadRequest.getField(fieldName);
            S7VarPayloadDataItem payloadItem = payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            PlcValue plcValue = null;
            ByteBuf data = Unpooled.wrappedBuffer((byte[])payloadItem.getData());
            if (responseCode == PlcResponseCode.OK) {
                try {
                    plcValue = this.parsePlcValue(field, data);
                }
                catch (Exception e) {
                    throw new PlcProtocolException("Error decoding PlcValue", (Throwable)e);
                }
            }
            ResponseItem result = new ResponseItem(responseCode, plcValue);
            values.put(fieldName, result);
            ++index;
        }
        return new DefaultPlcReadResponse(plcReadRequest, values);
    }

    private PlcResponse decodeWriteResponse(S7Message responseMessage, PlcWriteRequest plcWriteRequest) throws PlcProtocolException {
        short errorCode;
        short errorClass;
        HashMap<String, PlcResponseCode> responses = new HashMap<String, PlcResponseCode>();
        if (responseMessage instanceof S7MessageResponseData) {
            S7MessageResponseData messageResponseData = (S7MessageResponseData)responseMessage;
            errorClass = messageResponseData.getErrorClass();
            errorCode = messageResponseData.getErrorCode();
        } else if (responseMessage instanceof S7MessageResponse) {
            Iterator messageResponse = (S7MessageResponse)responseMessage;
            errorClass = ((S7MessageResponse)((Object)messageResponse)).getErrorClass();
            errorCode = ((S7MessageResponse)((Object)messageResponse)).getErrorCode();
        } else {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                this.logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String fieldName : plcWriteRequest.getFieldNames()) {
                    responses.put(fieldName, PlcResponseCode.ACCESS_DENIED);
                }
                return new DefaultPlcWriteResponse(plcWriteRequest, responses);
            }
            this.logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String fieldName : plcWriteRequest.getFieldNames()) {
                responses.put(fieldName, PlcResponseCode.INTERNAL_ERROR);
            }
            return new DefaultPlcWriteResponse(plcWriteRequest, responses);
        }
        S7PayloadWriteVarResponse payload = (S7PayloadWriteVarResponse)responseMessage.getPayload();
        if (plcWriteRequest.getNumberOfFields() != payload.getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        List<S7VarPayloadStatusItem> payloadItems = payload.getItems();
        int index = 0;
        for (String fieldName : plcWriteRequest.getFieldNames()) {
            S7VarPayloadStatusItem payloadItem = payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            responses.put(fieldName, responseCode);
            ++index;
        }
        return new DefaultPlcWriteResponse(plcWriteRequest, responses);
    }

    private S7VarPayloadDataItem serializePlcValue(S7Field field, PlcValue plcValue) {
        try {
            DataTransportSize transportSize = field.getDataType().getDataTransportSize();
            int stringLength = field instanceof S7StringField ? ((S7StringField)field).getStringLength() : 254;
            ByteBuffer byteBuffer = null;
            for (int i = 0; i < field.getNumberOfElements(); ++i) {
                int lengthInBits = DataItem.getLengthInBits(plcValue.getIndex(i), field.getDataType().getDataProtocolId(), stringLength);
                WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil((float)lengthInBits / 8.0f));
                DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue.getIndex(i), field.getDataType().getDataProtocolId(), stringLength);
                if (byteBuffer == null) {
                    byteBuffer = ByteBuffer.allocate(writeBuffer.getBytes().length * field.getNumberOfElements());
                }
                byteBuffer.put(writeBuffer.getBytes());
            }
            if (byteBuffer != null) {
                byte[] data = byteBuffer.array();
                return new S7VarPayloadDataItem(DataTransportErrorCode.OK, transportSize, data);
            }
        }
        catch (SerializationException e) {
            this.logger.warn("Error serializing field item of type: '{}'", (Object)field.getDataType().name(), (Object)e);
        }
        return null;
    }

    private PlcValue parsePlcValue(S7Field field, ByteBuf data) {
        ReadBufferByteBased readBuffer = new ReadBufferByteBased(data.array());
        try {
            int stringLength;
            int n = stringLength = field instanceof S7StringField ? ((S7StringField)field).getStringLength() : 254;
            if (field.getNumberOfElements() == 1) {
                return DataItem.staticParse((ReadBuffer)readBuffer, field.getDataType().getDataProtocolId(), stringLength);
            }
            Object[] resultItems = (PlcValue[])IntStream.range(0, field.getNumberOfElements()).mapToObj(arg_0 -> this.lambda$parsePlcValue$30((ReadBuffer)readBuffer, field, stringLength, arg_0)).toArray(PlcValue[]::new);
            return IEC61131ValueHandler.of((Object[])resultItems);
        }
        catch (ParseException e) {
            this.logger.warn("Error parsing field item of type: '{}'", (Object)field.getDataType().name(), (Object)e);
            return null;
        }
    }

    private PlcResponseCode decodeResponseCode(DataTransportErrorCode dataTransportErrorCode) {
        if (dataTransportErrorCode == null) {
            return PlcResponseCode.INTERNAL_ERROR;
        }
        switch (dataTransportErrorCode) {
            case OK: {
                return PlcResponseCode.OK;
            }
            case NOT_FOUND: {
                return PlcResponseCode.NOT_FOUND;
            }
            case INVALID_ADDRESS: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case DATA_TYPE_NOT_SUPPORTED: {
                return PlcResponseCode.INVALID_DATATYPE;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private S7ControllerType decodeControllerType(String articleNumber) {
        String model;
        if (!articleNumber.startsWith("6ES7 ")) {
            return S7ControllerType.ANY;
        }
        switch (model = articleNumber.substring(articleNumber.indexOf(32) + 1, articleNumber.indexOf(32) + 2)) {
            case "2": {
                return S7ControllerType.S7_1200;
            }
            case "5": {
                return S7ControllerType.S7_1500;
            }
            case "3": {
                return S7ControllerType.S7_300;
            }
            case "4": {
                return S7ControllerType.S7_400;
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Looking up unknown article number {}", (Object)articleNumber);
        }
        return S7ControllerType.ANY;
    }

    protected S7Address encodeS7Address(PlcField field) {
        if (!(field instanceof S7Field)) {
            throw new PlcRuntimeException("Unsupported address type " + field.getClass().getName());
        }
        S7Field s7Field = (S7Field)field;
        TransportSize transportSize = s7Field.getDataType();
        int numElements = s7Field.getNumberOfElements();
        if (transportSize == TransportSize.TIME || transportSize == TransportSize.LTIME || transportSize == TransportSize.DATE || transportSize == TransportSize.TIME_OF_DAY || transportSize == TransportSize.DATE_AND_TIME) {
            numElements *= transportSize.getSizeInBytes();
            transportSize = TransportSize.BYTE;
        }
        if (transportSize == TransportSize.STRING) {
            transportSize = TransportSize.CHAR;
            int stringLength = s7Field instanceof S7StringField ? ((S7StringField)s7Field).getStringLength() : 254;
            numElements *= stringLength + 2;
        } else if (transportSize == TransportSize.WSTRING) {
            transportSize = TransportSize.CHAR;
            int stringLength = s7Field instanceof S7StringField ? ((S7StringField)s7Field).getStringLength() : 254;
            numElements = numElements * (stringLength + 2) * 2;
        }
        return new S7AddressAny(transportSize, numElements, s7Field.getBlockNumber(), s7Field.getMemoryArea(), s7Field.getByteOffset(), s7Field.getBitOffset());
    }

    private /* synthetic */ PlcValue lambda$parsePlcValue$30(ReadBuffer readBuffer, S7Field field, int stringLength, int i) {
        try {
            return DataItem.staticParse(readBuffer, field.getDataType().getDataProtocolId(), stringLength);
        }
        catch (ParseException e) {
            this.logger.warn("Error parsing field item of type: '{}' (at position {}})", new Object[]{field.getDataType().name(), i, e});
            return null;
        }
    }

    static class TransactionErrorCallback<T, E extends Throwable>
    implements Consumer<TimeoutException>,
    BiConsumer<TPKTPacket, E> {
        private final CompletableFuture<T> future;
        private final RequestTransactionManager.RequestTransaction transaction;

        TransactionErrorCallback(CompletableFuture<T> future, RequestTransactionManager.RequestTransaction transaction) {
            this.future = future;
            this.transaction = transaction;
        }

        @Override
        public void accept(TimeoutException e) {
            this.transaction.endRequest();
            this.future.completeExceptionally(e);
        }

        @Override
        public void accept(TPKTPacket tpktPacket, E e) {
            this.transaction.endRequest();
            this.future.completeExceptionally((Throwable)e);
        }
    }
}

