/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.events.S7AlarmEvent;
import org.apache.plc4x.java.s7.events.S7ModeEvent;
import org.apache.plc4x.java.s7.events.S7SysEvent;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.ModeTransitionType;
import org.apache.plc4x.java.s7.utils.S7DiagnosticEventId;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class StaticHelper {
    public static Duration S5TimeToDuration(Short data) {
        long tb;
        short t = data;
        long tv = (short)((t & 0xF) + ((t & 0xF0) >> 4) * 10 + ((t & 0xF00) >> 8) * 100);
        long totalms = tv * (tb = (long)((short)(10.0 * Math.pow(10.0, (t & 0xF000) >> 12))));
        Duration res = totalms <= 9990000L ? Duration.ofMillis(totalms) : Duration.ofMillis(9990000L);
        return res;
    }

    public static Short DurationToS5Time(Duration duration) {
        short tv = 0;
        int tb = 0;
        short s5time = 0;
        long totalms = duration.toMillis();
        if (totalms >= 0L && totalms <= 9990000L) {
            if (totalms <= 9990L) {
                tb = 0;
                tv = (short)(totalms / 10L);
            } else if (totalms <= 99900L) {
                tb = 1;
                tv = (short)(totalms / 100L);
            } else if (totalms <= 999000L) {
                tb = 2;
                tv = (short)(totalms / 1000L);
            } else if (totalms > 999000L) {
                tb = 3;
                tv = (short)(totalms / 10000L);
            }
            short uni = (short)(tv % 10);
            short dec = (short)(tv / 10 % 10);
            short cen = (short)(tv / 100 % 10);
            return (short)(tb << 12 | cen << 8 | dec << 4 | uni);
        }
        return s5time;
    }

    public static Duration S7TimeToDuration(Integer data) {
        Duration res = Duration.ZERO;
        if (data >= 0) {
            res = res.plusMillis(data.intValue());
        } else {
            long ms = Integer.MIN_VALUE - (data & Integer.MIN_VALUE);
            res = res.minusMillis(data.intValue());
        }
        return res;
    }

    public static Integer DurationToS7Time(Duration data) {
        Integer res = 0;
        res = data.isNegative() ? Integer.valueOf((int)data.toMillis() + Integer.MIN_VALUE) : Integer.valueOf((int)data.toMillis());
        return res;
    }

    public static LocalTime S7TodToLocalTime(Integer data) {
        if (data > 86399999) {
            data = 86399999;
        }
        if (data < 0) {
            data = 0;
        }
        return LocalTime.MIDNIGHT.plusNanos((long)data.intValue() * 1000000L);
    }

    public static Integer LocalTimeToS7Tod(LocalTime data) {
        return (int)(data.toNanoOfDay() / 1000000L);
    }

    public static LocalDate S7DateToLocalDate(Short data) {
        LocalDate res = LocalDate.of(1990, 1, 1);
        res = res.plusDays(data.shortValue());
        return res;
    }

    public static Short LocalDateToS7Date(LocalDate data) {
        LocalDate ini = LocalDate.of(1990, 1, 1);
        long resl = ChronoUnit.DAYS.between(ini, data);
        return (short)resl;
    }

    public static LocalDateTime S7DateTimeToLocalDateTime(ByteBuf data) {
        int year = StaticHelper.BcdToInt(data.readByte());
        int month = StaticHelper.BcdToInt(data.readByte());
        int day = StaticHelper.BcdToInt(data.readByte());
        int hour = StaticHelper.BcdToInt(data.readByte());
        int minute = StaticHelper.BcdToInt(data.readByte());
        int second = StaticHelper.BcdToInt(data.readByte());
        int millih = StaticHelper.BcdToInt(data.readByte()) * 10;
        int milll = data.readByte() >> 4;
        int milliseconds = millih + milll;
        int nanoseconds = milliseconds * 1000000;
        year = year >= 90 ? (year += 1900) : (year += 2000);
        return LocalDateTime.of(year, month, day, hour, minute, second, nanoseconds);
    }

    public static LocalDateTime S7DateAndTimeToLocalDateTime(int year, int month, int day, int hour, int min, int sec, int msec) {
        int nanoseconds = msec * 1000000;
        year = year >= 90 ? (year += 1900) : (year += 2000);
        return LocalDateTime.of(year, month, day, hour, min, sec, nanoseconds);
    }

    public static byte[] LocalDateTimeToS7DateTime(LocalDateTime data) {
        byte[] res = new byte[8];
        res[0] = StaticHelper.ByteToBcd(data.getYear() % 100);
        res[1] = StaticHelper.ByteToBcd(data.getMonthValue());
        res[2] = StaticHelper.ByteToBcd(data.getDayOfMonth());
        res[3] = StaticHelper.ByteToBcd(data.getHour());
        res[4] = StaticHelper.ByteToBcd(data.getMinute());
        res[5] = StaticHelper.ByteToBcd(data.getSecond());
        long ms = data.getNano() / 1000000;
        res[6] = (byte)(ms / 100L << 4 | ms / 10L % 10L);
        byte dayofweek = (byte)(data.getDayOfWeek().getValue() < 7 ? data.getDayOfWeek().getValue() + 1 : 1);
        res[7] = (byte)(ms % 10L << 4 | (long)dayofweek);
        return res;
    }

    private static byte ByteToBcd(int incomingByte) {
        byte dec = (byte)(incomingByte / 10 % 10);
        return (byte)(dec << 4 | incomingByte % 10);
    }

    private static int BcdToInt(byte bcd) {
        return (bcd >> 4) * 10 + (bcd & 0xF);
    }

    public static void ByteToBcd(WriteBuffer buffer, short _value) throws SerializationException {
        short incomingByte = _value;
        byte outputByte = 0;
        byte dec = (byte)(incomingByte / 10 % 10);
        outputByte = (byte)(dec << 4 | incomingByte % 10);
        buffer.writeByte(outputByte);
    }

    public static int BcdToInt(ReadBuffer buffer) throws ParseException {
        byte bcd = buffer.readByte();
        return (bcd >> 4) * 10 + (bcd & 0xF);
    }

    public static int S7msecToInt(ReadBuffer buffer) throws ParseException {
        int centenas = StaticHelper.BcdToInt(buffer.readUnsignedByte(4));
        int decenas = StaticHelper.BcdToInt(buffer.readUnsignedByte(4));
        int unidad = StaticHelper.BcdToInt(buffer.readUnsignedByte(4));
        return centenas * 100 + decenas * 10 + unidad;
    }

    public static void IntToS7msec(WriteBuffer buffer, int _value) throws SerializationException {
        int local = 0;
        local = _value > 999 ? 999 : _value;
        int centenas = local / 100;
        int residual = local - centenas * 100;
        int decenas = residual / 10;
        int unidad = residual - decenas * 10;
        buffer.writeUnsignedByte(4, (byte)centenas);
        buffer.writeUnsignedByte(4, (byte)decenas);
        buffer.writeUnsignedByte(4, (byte)unidad);
    }

    public static void LeftShift3(WriteBuffer buffer, int _value) throws SerializationException {
        int valor = _value << 3;
        buffer.writeUnsignedInt(16, valor);
    }

    public static int RightShift3(ReadBuffer buffer) throws ParseException {
        return buffer.readUnsignedInt(16) >> 3;
    }

    public static int EventItemLength(ReadBuffer buffer, int valueLength) {
        return valueLength % 2 == 0 || !buffer.hasMore((valueLength + 1) * 8) ? valueLength : valueLength + 1;
    }

    public static PlcResponseCode decodeResponseCode(DataTransportErrorCode dataTransportErrorCode) {
        if (dataTransportErrorCode == null) {
            return PlcResponseCode.INTERNAL_ERROR;
        }
        switch (dataTransportErrorCode) {
            case OK: {
                return PlcResponseCode.OK;
            }
            case NOT_FOUND: {
                return PlcResponseCode.NOT_FOUND;
            }
            case INVALID_ADDRESS: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case DATA_TYPE_NOT_SUPPORTED: {
                return PlcResponseCode.INVALID_DATATYPE;
            }
            case ACCESS_DENIED: {
                return PlcResponseCode.ACCESS_DENIED;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private static byte[] wordToBytes(long data) {
        return new byte[]{(byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    private static byte[] dwordToBytes(long data) {
        return new byte[]{(byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static String ModeEventProcessing(S7ModeEvent mode) {
        StringBuilder sb = new StringBuilder("CPU is in : ");
        if (ModeTransitionType.isDefined((Short)mode.getMap().get("CURRENT_MODE")).booleanValue()) {
            short currentmode = (Short)mode.getMap().get("CURRENT_MODE");
            sb.append(ModeTransitionType.enumForValue(currentmode).name());
        } else {
            sb.append("UNDEFINED");
        }
        return sb.toString();
    }

    public static String SysEventProcessing(S7SysEvent event, String eventtext, HashMap<String, HashMap<String, String>> textlists) {
        Pattern EVENT_SIG = Pattern.compile("(@[\\d]{0,3}[bycwixdrBYCWIXDR](%([\\d]{0,2}[duxbs]){1}|(\\d\\.\\df){1}|(t#[a-zA-Z0-9]+){1})@)");
        Pattern FIELDS = Pattern.compile("@(?<sig>[\\d]{0,3})(?<type>[bycwixdrBYCWIXDR])(?<format>%([\\d]{0,2}[duxbs]){1}|(\\d\\.\\df){1}|(t#[a-zA-Z0-9]+){1})@");
        Pattern FIELD_FORMAT = Pattern.compile("%([\\d]{0,2})([duxbsDUXBS]{1})");
        Map<String, Object> map = event.getMap();
        Matcher matcher = EVENT_SIG.matcher(eventtext);
        Matcher fields = null;
        Matcher fieldformat = null;
        Object strSig = null;
        ByteBuf bytebuf = null;
        int length = 0;
        int sig = 0;
        long value = 0L;
        String strOut = eventtext;
        String strField = null;
        while (matcher.find() && (fields = FIELDS.matcher(matcher.group(0))).find()) {
            int n = sig = fields.group(1) == "" ? 1 : Integer.parseInt(fields.group(1));
            if (sig == 0 || sig > 2) break;
            String infofield = sig == 1 ? "INFO1" : "INFO2";
            long infovalue = (Long)event.getMap().get(infofield);
            String format = fields.group(3).toUpperCase();
            bytebuf = sig == 1 ? Unpooled.wrappedBuffer((byte[])StaticHelper.wordToBytes(infovalue)) : Unpooled.wrappedBuffer((byte[])StaticHelper.dwordToBytes(infovalue));
            switch (fields.group(2).toUpperCase()) {
                case "B": {
                    if (bytebuf.capacity() < 1) break;
                    strField = String.valueOf(bytebuf.getBoolean(0));
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "Y": {
                    String strReplace;
                    if (bytebuf.capacity() < 1) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedByte(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getByte(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedByte(0);
                        strField = Integer.toBinaryString((byte)value);
                    } else {
                        value = bytebuf.getByte(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "C": {
                    if (!format.contains("%T#")) {
                        if (bytebuf.capacity() < 1) break;
                        fieldformat = FIELD_FORMAT.matcher(format);
                        if (fieldformat.find()) {
                            length = Integer.parseInt(fieldformat.group(1));
                            length = length > bytebuf.capacity() ? bytebuf.capacity() : length;
                            strField = bytebuf.readCharSequence(length, Charset.forName("utf-8")).toString();
                        }
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "W": {
                    String strReplace;
                    if (bytebuf.capacity() < 2) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedShort(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getShort(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedShort(0);
                        strField = Integer.toBinaryString((short)value);
                    } else {
                        value = bytebuf.getShort(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "I": {
                    String strReplace;
                    if (bytebuf.capacity() < 4) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getInt(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getInt(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "X": {
                    String strReplace;
                    if (bytebuf.capacity() < 8) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "D": {
                    String strReplace;
                    if (bytebuf.capacity() < 8) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "R": {
                    if (bytebuf.capacity() < 4 || !format.contains("F")) break;
                    strField = String.format(format, value);
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                }
            }
        }
        return strOut;
    }

    public static String AlarmProcessing(S7AlarmEvent alarm, String alarmText, HashMap<String, HashMap<String, String>> textlists) {
        Pattern ALARM_SIG = Pattern.compile("(@[\\d]{0,3}[bycwixdrBYCWIXDR](%([\\d]{0,2}[duxbs]){1}|(\\d\\.\\df){1}|(t#[a-zA-Z0-9]+){1})@)");
        Pattern FIELDS = Pattern.compile("@(?<sig>[\\d]{0,3})(?<type>[bycwixdrBYCWIXDR])(?<format>%([\\d]{0,2}[duxbs]){1}|(\\d\\.\\df){1}|(t#[a-zA-Z0-9]+){1})@");
        Pattern FIELD_FORMAT = Pattern.compile("%([\\d]{0,2})([duxbsDUXBS]{1})");
        Map<String, Object> map = alarm.getMap();
        Matcher matcher = ALARM_SIG.matcher(alarmText);
        Matcher fields = null;
        Matcher fieldformat = null;
        String strSig = null;
        ByteBuf bytebuf = null;
        int length = 0;
        int sig = 0;
        long value = 0L;
        String strOut = new String(alarmText);
        String strField = null;
        while (matcher.find() && (fields = FIELDS.matcher(matcher.group(0))).find()) {
            sig = fields.group(1) == "" ? 1 : Integer.parseInt(fields.group(1));
            strSig = "SIG_" + sig + "_DATA";
            if ((Short)map.get("ASSOCIATED_VALUES") == 0 || sig > (Short)map.get("ASSOCIATED_VALUES")) break;
            bytebuf = Unpooled.wrappedBuffer((byte[])((byte[])map.get(strSig)));
            String format = fields.group(3).toUpperCase();
            switch (fields.group(2).toUpperCase()) {
                case "B": {
                    if (bytebuf.capacity() < 1) break;
                    strField = String.valueOf(bytebuf.getBoolean(0));
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "Y": {
                    String strReplace;
                    if (bytebuf.capacity() < 1) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedByte(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getByte(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedByte(0);
                        strField = Integer.toBinaryString((byte)value);
                    } else {
                        value = bytebuf.getByte(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "C": {
                    if (!format.contains("%T#")) {
                        if (bytebuf.capacity() < 1) break;
                        fieldformat = FIELD_FORMAT.matcher(format);
                        if (fieldformat.find()) {
                            length = Integer.parseInt(fieldformat.group(1));
                            length = length > bytebuf.capacity() ? bytebuf.capacity() : length;
                            strField = bytebuf.readCharSequence(length, Charset.forName("utf-8")).toString();
                        }
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "W": {
                    String strReplace;
                    if (bytebuf.capacity() < 2) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedShort(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getShort(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedShort(0);
                        strField = Integer.toBinaryString((short)value);
                    } else {
                        value = bytebuf.getShort(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "I": {
                    String strReplace;
                    if (bytebuf.capacity() < 4) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getInt(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getInt(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "X": {
                    String strReplace;
                    if (bytebuf.capacity() < 8) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "D": {
                    String strReplace;
                    if (bytebuf.capacity() < 8) break;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "R": {
                    if (bytebuf.capacity() < 4 || !format.contains("F")) break;
                    strField = String.format(format, value);
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                }
            }
        }
        return strOut;
    }

    public static LocalTime parseTiaTime(ReadBuffer io) {
        try {
            int millisSinceMidnight = io.readInt(32);
            return LocalTime.now().withHour(0).withMinute(0).withSecond(0).withNano(0).plus(millisSinceMidnight, ChronoUnit.MILLIS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void serializeTiaTime(WriteBuffer io, PlcValue value) {
        throw new NotImplementedException("Serializing TIME not implemented");
    }

    public static LocalTime parseS5Time(ReadBuffer io) {
        try {
            int stuff = io.readInt(16);
            throw new NotImplementedException("S5TIME not implemented");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void serializeS5Time(WriteBuffer io, PlcValue value) {
        throw new NotImplementedException("Serializing S5TIME not implemented");
    }

    public static LocalTime parseTiaLTime(ReadBuffer io) {
        throw new NotImplementedException("LTIME not implemented");
    }

    public static void serializeTiaLTime(WriteBuffer io, PlcValue value) {
        throw new NotImplementedException("Serializing LTIME not implemented");
    }

    public static LocalTime parseTiaTimeOfDay(ReadBuffer io) {
        try {
            long millisSinceMidnight = io.readUnsignedLong(32);
            return LocalTime.now().withHour(0).withMinute(0).withSecond(0).withNano(0).plus(millisSinceMidnight, ChronoUnit.MILLIS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void serializeTiaTimeOfDay(WriteBuffer io, PlcValue value) {
        throw new NotImplementedException("Serializing TIME_OF_DAY not implemented");
    }

    public static LocalDate parseTiaDate(ReadBuffer io) {
        try {
            int daysSince1990 = io.readUnsignedInt(16);
            return LocalDate.now().withYear(1990).withDayOfMonth(1).withMonth(1).plus(daysSince1990, ChronoUnit.DAYS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void serializeTiaDate(WriteBuffer io, PlcValue value) {
        throw new NotImplementedException("Serializing DATE not implemented");
    }

    public static LocalDateTime parseTiaDateTime(ReadBuffer io) {
        try {
            int year = io.readUnsignedInt(16);
            int month = io.readUnsignedInt(8);
            int day = io.readUnsignedInt(8);
            io.readByte();
            byte hour = io.readByte();
            byte minute = io.readByte();
            byte second = io.readByte();
            int nanosecond = io.readUnsignedInt(24);
            io.readByte();
            return LocalDateTime.of(year, month, day, (int)hour, (int)minute, (int)second, nanosecond);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void serializeTiaDateTime(WriteBuffer io, PlcValue value) {
        throw new NotImplementedException("Serializing DATE_AND_TIME not implemented");
    }

    public static String parseS7Char(ReadBuffer io, String encoding) throws ParseException {
        if ("UTF-8".equalsIgnoreCase(encoding)) {
            return io.readString(8, encoding);
        }
        if ("UTF-16".equalsIgnoreCase(encoding)) {
            return io.readString(16, encoding);
        }
        throw new PlcRuntimeException("Unsupported encoding");
    }

    public static String parseS7String(ReadBuffer io, int stringLength, String encoding) {
        try {
            if ("UTF-8".equalsIgnoreCase(encoding)) {
                short maxLength = io.readUnsignedShort(8);
                short totalStringLength = io.readUnsignedShort(8);
                byte[] byteArray = new byte[totalStringLength];
                for (int i = 0; i < stringLength && io.hasMore(8); ++i) {
                    byte curByte = io.readByte();
                    if (i < totalStringLength) {
                        byteArray[i] = curByte;
                        continue;
                    }
                    ++i;
                    while (i < stringLength && io.hasMore(8)) {
                        io.readByte();
                        ++i;
                    }
                    break;
                }
                return new String(byteArray, StandardCharsets.UTF_8);
            }
            if ("UTF-16".equalsIgnoreCase(encoding)) {
                int maxLength = io.readUnsignedInt(16);
                int totalStringLength = io.readUnsignedInt(16);
                byte[] byteArray = new byte[totalStringLength * 2];
                for (int i = 0; i < stringLength && io.hasMore(16); ++i) {
                    short curShort = io.readShort(16);
                    if (i < totalStringLength) {
                        byteArray[i * 2] = (byte)(curShort >>> 8);
                        byteArray[i * 2 + 1] = (byte)(curShort & 0xFF);
                        continue;
                    }
                    ++i;
                    while (i < stringLength && io.hasMore(16)) {
                        io.readShort(16);
                        ++i;
                    }
                    break;
                }
                return new String(byteArray, StandardCharsets.UTF_16);
            }
            throw new PlcRuntimeException("Unsupported string encoding " + encoding);
        }
        catch (ParseException e) {
            throw new PlcRuntimeException("Error parsing string", (Throwable)e);
        }
    }

    public static void serializeS7Char(WriteBuffer io, PlcValue value, String encoding) {
        if (!"UTF-8".equalsIgnoreCase(encoding) && !"UTF-16".equalsIgnoreCase(encoding)) {
            throw new PlcRuntimeException("Unsupported encoding");
        }
    }

    public static void serializeS7String(WriteBuffer io, PlcValue value, int stringLength, String encoding) {
        int k = 0xFF & (stringLength > 250 ? 250 : stringLength);
        int m = 0xFF & value.getString().length();
        m = m > k ? k : m;
        byte[] chars = new byte[m];
        for (int i = 0; i < m; ++i) {
            char c = value.getString().charAt(i);
            chars[i] = (byte)c;
        }
        try {
            io.writeByte((byte)(k & 0xFF));
            io.writeByte((byte)(m & 0xFF));
            io.writeByteArray(chars, new WithWriterArgs[0]);
        }
        catch (SerializationException ex) {
            Logger.getLogger(StaticHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static enum SSL {
        ID_0x0011(17, "Module identification."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY11(data);
            }
        }
        ,
        ID_0x0012(18, "CPU characteristics ."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY12(data);
            }
        }
        ,
        ID_0x0013(19, "User memory areas."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY13(data);
            }
        }
        ,
        ID_0x0014(20, "System areas."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY14(data);
            }
        }
        ,
        ID_0x0015(21, "Block types."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY15(data);
            }
        }
        ,
        ID_0x001C(28, "Component identification."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY1C(data);
            }
        }
        ,
        ID_0x0022(34, "Interrupt status."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY22(data);
            }
        }
        ,
        ID_0x0025(37, "Assignment between process image partitions and OBs."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY25(data);
            }
        }
        ,
        ID_0x0032(50, "Communication status data."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY32(data);
            }
        }
        ,
        ID_0x0071(113, "H CPU group information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY71(data);
            }
        }
        ,
        ID_0x0074(116, "Status of the module LEDs."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY74(data);
            }
        }
        ,
        ID_0x0075(117, "Switched DP slaves in the H-system."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY75(data);
            }
        }
        ,
        ID_0x0090(144, "DP Master System Information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY90(data);
            }
        }
        ,
        ID_0x0091(145, "Module status information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY91(data);
            }
        }
        ,
        ID_0x0092(146, "Rack / station status information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY92(data);
            }
        }
        ,
        ID_0x0094(148, "Rack / station status information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY94(data);
            }
        }
        ,
        ID_0x0095(149, "Extended DP master system / PROFINET IO system information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY95(data);
            }
        }
        ,
        ID_0x0096(150, "Module status information, PROFINET IO and PROFIBUS DP."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY96(data);
            }
        }
        ,
        ID_0x009C(156, "Tool changer information (PROFINET IO)."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXY9C(data);
            }
        }
        ,
        ID_0x00A0(160, "Diagnostic buffer of the CPU."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXYA0(data);
            }
        }
        ,
        ID_0x00B1(177, "Module diagnostic information (data record 0) ."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXYB1(data);
            }
        }
        ,
        ID_0x00B2(178, "Module diagnostic information (data record 1),geographical address."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXYB2(data);
            }
        }
        ,
        ID_0x00B3(179, "Module diagnostic information (data record 1),logical address."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXYB3(data);
            }
        }
        ,
        ID_0x00B4(180, "Diagnostic data of a DP slave."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SSL.ID_0xXYB4(data);
            }
        };

        private final int code;
        private final String description;
        private static final Map<Integer, SSL> map;

        private SSL(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static SSL valueOf(int code) {
            return map.get(code);
        }

        public abstract StringBuilder execute(ByteBuf var1);

        private static StringBuilder ID_0xXY11(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            int ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                for (int i = 1; i <= ssl_count; ++i) {
                    sb.append("Data Record: ").append(i).append("\r\n");
                    sb.append("Index: ").append(data.readShort()).append("\r\n");
                    byte[] bytestr = new byte[20];
                    data.readBytes(bytestr, 0, 20);
                    sb.append("Mlfb (Order number): ").append(new String(bytestr)).append("\r\n");
                    sb.append("BGTyp (Moduler type ID): ").append(data.readShort()).append("\r\n");
                    sb.append("Ausbg (Version of the module/hardware version): ").append(data.readShort()).append("\r\n");
                    sb.append("Ausbe (Firmware version): ").append(data.readShort()).append("\r\n");
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXY12(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            int ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                for (int i = 1; i <= ssl_count; ++i) {
                    sb.append("Data Record: ").append(i).append("\r\n");
                    short code = data.readShort();
                    sb.append((Object)CPU_CHARACTERISTICS.valueOf(code)).append(": ").append(CPU_CHARACTERISTICS.valueOf(code).getDescription()).append("\r\n");
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXY13(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            int ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                for (int i = 1; i <= ssl_count; ++i) {
                    sb.append("Data Record: ").append(i).append("\r\n");
                    sb.append("Index: ").append(data.readShort()).append("\r\n");
                    short code = data.readShort();
                    int size = data.readInt();
                    short mode = data.readShort();
                    short granu = data.readShort();
                    int ber1 = data.readInt();
                    int be1egt1 = data.readInt();
                    int block1 = data.readInt();
                    int ber2 = data.readInt();
                    int be1egt2 = data.readInt();
                    int block2 = data.readInt();
                    switch (code) {
                        case 1: {
                            sb.append("Code (Memory Type): ").append("Volatile memory (RAM)\r\n");
                            break;
                        }
                        case 2: {
                            sb.append("Code (Memory Type): ").append("Non-volatile memory (FEPROM)\r\n");
                            break;
                        }
                        case 3: {
                            sb.append("Code (Memory Type): ").append("mixed memory (RAM + FEPROM)\r\n");
                        }
                    }
                    sb.append("Size (Total size of the selected memory (total of area 1 and area 2)): ").append(size).append("\r\n");
                    sb.append("Mode (Volatile memory area): ").append((mode & 1) != 0).append("\r\n");
                    sb.append("Mode (Non-volatile memory area): ").append((mode & 2) != 0).append("\r\n");
                    sb.append("Mode (Mixed memory area): ").append((mode & 4) != 0).append("\r\n");
                    sb.append("Mode (Code and data separate): ").append((mode & 8) != 0).append("\r\n");
                    sb.append("Mode (Code and data together): ").append((mode & 0x10) != 0).append("\r\n");
                    sb.append("Granu (Always zero): ").append(granu).append("\r\n");
                    sb.append("Ber1 (Size of the volatile memory area in bytes): ").append(ber1).append("\r\n");
                    sb.append("Belegt1 (Size of the volatile memory area being used): ").append(be1egt1).append("\r\n");
                    sb.append("Block1 (Largest free block in the volatile memory area): ").append(block1).append("\r\n");
                    sb.append("Ber2 (Size of the non-volatile memory area in bytes): ").append(ber2).append("\r\n");
                    sb.append("Belegt2 (Size of the non-volatile memory area being used): ").append(be1egt2).append("\r\n");
                    sb.append("Block2 (Largest free block in the non-volatile memory area): ").append(block2).append("\r\n");
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXY14(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            int ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                for (int i = 1; i <= ssl_count; ++i) {
                    short index = data.readShort();
                    short code = data.readShort();
                    short quantity = data.readShort();
                    short reman = data.readShort();
                    sb.append("Data Record: ").append(i).append("\r\n");
                    sb.append("Index: ").append(index).append(" System area: ");
                    switch (index) {
                        case 1: {
                            sb.append("PII (number in bytes)").append("\r\n");
                            break;
                        }
                        case 2: {
                            sb.append("PIQ (number in bytes))").append("\r\n");
                            break;
                        }
                        case 3: {
                            sb.append("memory (number in bits)").append("\r\n");
                            break;
                        }
                        case 4: {
                            sb.append("timers (number)").append("\r\n");
                            break;
                        }
                        case 5: {
                            sb.append("counter (number)").append("\r\n");
                            break;
                        }
                        case 6: {
                            sb.append("number of bytes in the logical address area)").append("\r\n");
                            break;
                        }
                        case 7: {
                            sb.append("local data (entire local data area of the CPU in bytes)").append("\r\n");
                            break;
                        }
                        case 8: {
                            sb.append("memory (number in bytes)").append("\r\n");
                            break;
                        }
                        case 9: {
                            sb.append("local data (entire local data area of the CPU in Kbytes)").append("\r\n");
                        }
                    }
                    sb.append("Code: ").append(code).append(" Memory type: ");
                    switch (code) {
                        case 1: {
                            sb.append("volatile memory (RAM)").append("\r\n");
                            break;
                        }
                        case 2: {
                            sb.append("non-volatile memory (FEPROM)").append("\r\n");
                            break;
                        }
                        case 3: {
                            sb.append("mixed memory (RAM and FEPROM)").append("\r\n");
                        }
                    }
                    sb.append("Quantity: ").append(quantity).append("\r\n");
                    sb.append("Reman: ").append(reman).append("\r\n");
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXY15(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            int ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                for (int i = 1; i <= ssl_count; ++i) {
                    sb.append("Data Record: ").append(i).append("\r\n");
                    short type = data.readShort();
                    switch (type) {
                        case 2048: {
                            sb.append("Block type: OB\r\n");
                            break;
                        }
                        case 2560: {
                            sb.append("Block type: DB\r\n");
                            break;
                        }
                        case 2816: {
                            sb.append("Block type: SDB\r\n");
                            break;
                        }
                        case 3072: {
                            sb.append("Block type: FC\r\n");
                            break;
                        }
                        case 3584: {
                            sb.append("Block type: FB\r\n");
                            break;
                        }
                    }
                    sb.append("Maximum number of blocks of the type: ").append(data.readShort()).append("\r\n");
                    sb.append("Maximum total size of the object to be loaded in Kbytes: ").append(data.readShort()).append("\r\n");
                    sb.append("Maximum length of the work memory part of a block in bytes: ").append(data.readInt()).append("\r\n");
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXY1C(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            int ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                block17: for (int i = 1; i <= ssl_count; ++i) {
                    sb.append("Data Record: ").append(i).append("\r\n");
                    short index = data.getShort(data.readerIndex());
                    byte index_b0 = data.readByte();
                    byte index_b1 = data.readByte();
                    sb.append("Index: ").append(index).append("\r\n");
                    sb.append("Index b1: ").append(index_b1).append("\r\n");
                    switch (index_b1) {
                        case 1: 
                        case 2: {
                            byte[] strbyte = new byte[24];
                            data.readBytes(strbyte, 0, 24);
                            sb.append("Name: ").append(new String(strbyte)).append("\r\n");
                            ByteBuf data2 = data.readSlice(8);
                            sb.append("Reserved: ").append(ByteBufUtil.hexDump((ByteBuf)data2)).append("\r\n");
                            continue block17;
                        }
                        case 3: {
                            byte[] strbyte = new byte[32];
                            data.readBytes(strbyte, 0, 32);
                            sb.append("Tag: ").append(new String(strbyte)).append("\r\n");
                            continue block17;
                        }
                        case 4: {
                            byte[] strbyte = new byte[26];
                            data.readBytes(strbyte, 0, 26);
                            sb.append("Copyright: ").append(new String(strbyte)).append("\r\n");
                            ByteBuf data2 = data.readSlice(6);
                            sb.append("Reserved: ").append(ByteBufUtil.hexDump((ByteBuf)data2)).append("\r\n");
                            continue block17;
                        }
                        case 5: {
                            byte[] strbyte = new byte[24];
                            data.readBytes(strbyte, 0, 24);
                            sb.append("Serial: ").append(new String(strbyte)).append("\r\n");
                            ByteBuf data2 = data.readSlice(8);
                            sb.append("Reserved: ").append(ByteBufUtil.hexDump((ByteBuf)data2)).append("\r\n");
                            continue block17;
                        }
                        case 6: {
                            continue block17;
                        }
                        case 7: {
                            byte[] strbyte = new byte[32];
                            data.readBytes(strbyte, 0, 32);
                            sb.append("Cpu type: ").append(new String(strbyte)).append("\r\n");
                            continue block17;
                        }
                        case 8: {
                            byte[] strbyte = new byte[32];
                            data.readBytes(strbyte, 0, 32);
                            sb.append("Serial mc/mmc: ").append(new String(strbyte)).append("\r\n");
                            continue block17;
                        }
                        case 9: {
                            sb.append("Manufacturer ID: ").append(data.readShort()).append("\r\n");
                            sb.append("Profile ID: ").append(data.readShort()).append("\r\n");
                            sb.append("Profile specific type: ").append(data.readShort()).append("\r\n");
                            ByteBuf data2 = data.readSlice(26);
                            sb.append("Reserved: ").append(ByteBufUtil.hexDump((ByteBuf)data2)).append("\r\n");
                            continue block17;
                        }
                        case 10: {
                            byte[] strbyte = new byte[26];
                            data.readBytes(strbyte, 0, 26);
                            sb.append("OEM copyright: ").append(new String(strbyte)).append("\r\n");
                            sb.append("OEM ID: ").append(data.readShort()).append("\r\n");
                            sb.append("OEM add ID: ").append(data.readInt()).append("\r\n");
                            continue block17;
                        }
                        case 11: {
                            byte[] strbyte = new byte[32];
                            data.readBytes(strbyte, 0, 32);
                            sb.append("Location ID: ").append(new String(strbyte)).append("\r\n");
                            continue block17;
                        }
                        case 12: {
                            byte[] strbyte = new byte[10];
                            data.readBytes(strbyte, 0, 10);
                            sb.append("Order number sync module 1: ").append(new String(strbyte)).append("\r\n");
                            data.readShort();
                            byte[] strbyte2 = new byte[2];
                            data.readBytes(strbyte2, 0, 2);
                            sb.append("Product version: ").append(new String(strbyte2)).append("\r\n");
                            data.readByte();
                            ByteBuf data2 = data.readSlice(17);
                            sb.append("Vendor serial: ").append(ByteBufUtil.hexDump((ByteBuf)data2)).append("\r\n");
                            continue block17;
                        }
                        case 13: {
                            byte[] strbyte = new byte[10];
                            data.readBytes(strbyte, 0, 10);
                            sb.append("Order number sync module 2: ").append(new String(strbyte)).append("\r\n");
                            data.readShort();
                            byte[] strbyte2 = new byte[2];
                            data.readBytes(strbyte2, 0, 2);
                            sb.append("Product version: ").append(new String(strbyte2)).append("\r\n");
                            data.readByte();
                            ByteBuf data2 = data.readSlice(17);
                            sb.append("Vendor serial: ").append(ByteBufUtil.hexDump((ByteBuf)data2)).append("\r\n");
                            continue block17;
                        }
                        case 14: {
                            byte[] strbyte = new byte[18];
                            data.readBytes(strbyte, 0, 18);
                            sb.append("Serial number: ").append(new String(strbyte)).append("\r\n");
                            ByteBuf data2 = data.readSlice(14);
                            sb.append("Reserved: ").append(ByteBufUtil.hexDump((ByteBuf)data2)).append("\r\n");
                        }
                    }
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXY22(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            int ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                for (int i = 1; i <= ssl_count; ++i) {
                    sb.append("Data Record: ").append(i).append("\r\n");
                    ByteBuf infobytes = data.readSlice(20);
                    short al1 = data.readShort();
                    short al2 = data.readShort();
                    int al3 = data.readInt();
                    sb.append("Info: ").append(ByteBufUtil.hexDump((ByteBuf)infobytes)).append("\r\n");
                    sb.append("al 1: ").append(Integer.toHexString(al1)).append("\r\n");
                    sb.append("al 2: ").append(Integer.toHexString(al2)).append("\r\n");
                    sb.append("al 3: ").append(Integer.toHexString(al3)).append("\r\n");
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXY25(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY32(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY71(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY74(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            int ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                block7: for (int i = 1; i <= ssl_count; ++i) {
                    sb.append("Data Record: ").append(i).append("\r\n");
                    byte cpu_type = data.readByte();
                    byte led_id = data.readByte();
                    boolean led_onoff = data.readByte() != 0;
                    byte led_flashing = data.readByte();
                    sb.append("Rack number: ").append(cpu_type & 7).append("\r\n");
                    sb.append("CPU Type: ").append((cpu_type & 8) == 0 ? "Standby" : "Master").append("\r\n");
                    sb.append("LED ID: ").append((Object)LED_ID.valueOf(led_id)).append(" (").append(LED_ID.valueOf(led_id).description).append(")\r\n");
                    sb.append("LED status: ").append(led_onoff).append("\r\n");
                    switch (led_flashing) {
                        case 0: {
                            sb.append("LED flashing: not.").append("\r\n");
                            continue block7;
                        }
                        case 1: {
                            sb.append("LED blinking: normally (2 Hz).").append("\r\n");
                            continue block7;
                        }
                        case 2: {
                            sb.append("LED blinking: slowly (0.5 Hz).").append("\r\n");
                            continue block7;
                        }
                        default: {
                            sb.append("LED blinking: no information.").append("\r\n");
                        }
                    }
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXY75(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY90(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY91(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY92(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY94(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY95(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY96(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXY9C(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXYA0(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            short ssl_length = data.readShort();
            short ssl_count = data.readShort();
            try {
                sb.append("SSL partial list length in bytes: ").append(ssl_length).append("\r\n");
                sb.append("SSL partial list count: ").append(ssl_count).append("\r\n");
                int i = 1;
                while (data.isReadable()) {
                    sb.append("Data Record: ").append(i).append("\r\n");
                    Short id = data.readShort();
                    sb.append("ID: ").append(id).append("\r\n");
                    ByteBuf infobytes = data.readSlice(10);
                    sb.append("Info: ").append(ByteBufUtil.hexDump((ByteBuf)infobytes)).append("\r\n");
                    infobytes = data.readSlice(8);
                    sb.append("Timestamp: ").append(SSL.readDateAndTime(infobytes).toString()).append("\r\n");
                    sb.append("Desc: ").append(S7DiagnosticEventId.valueOf(id).getDescription()).append("\r\n");
                    ++i;
                }
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb;
        }

        private static StringBuilder ID_0xXYB1(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXYB2(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXYB3(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static StringBuilder ID_0xXYB4(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            sb.append("It is not implemeted yet!");
            return sb;
        }

        private static LocalDateTime readDateAndTime(ByteBuf data) {
            int year = SSL.convertByteToBcd(data.readByte());
            byte themonth = data.readByte();
            int month = SSL.convertByteToBcd(themonth == 0 ? (byte)1 : themonth);
            byte theday = data.readByte();
            int day = SSL.convertByteToBcd(theday == 0 ? (byte)1 : theday);
            int hour = SSL.convertByteToBcd(data.readByte());
            int minute = SSL.convertByteToBcd(data.readByte());
            int second = SSL.convertByteToBcd(data.readByte());
            int milliseconds = (data.readShort() & 0xFFF0) >> 4;
            int cen = ((milliseconds & 0xF00) >> 8) * 100;
            int dec = ((milliseconds & 0xF0) >> 4) * 10;
            milliseconds = cen + dec + (milliseconds & 0xF);
            int nanoseconds = milliseconds * 1000000;
            year = year >= 90 ? (year += 1900) : (year += 2000);
            return LocalDateTime.of(year, month, day, hour, minute, second, nanoseconds);
        }

        private static int convertByteToBcd(byte incomingByte) {
            int dec = (incomingByte >> 4) * 10;
            return dec + (incomingByte & 0xF);
        }

        private static short convertShortToBcd(short incomingShort) {
            return (short)((incomingShort >> 8) * 100 + (incomingShort >> 4) * 10 + (incomingShort & 0xF));
        }

        static {
            map = new HashMap<Integer, SSL>();
            for (SSL subssl : SSL.values()) {
                map.put(subssl.code, subssl);
            }
        }
    }

    public static enum CPU_CHARACTERISTICS {
        CH_0x0000(0, "MC7 processing unit (group with index 0000)"),
        CH_0x0001(1, "MC7 processing generating code"),
        CH_0x0002(2, "MC7 interpreter"),
        CH_0x0100(256, "Time system (group with index 0100)"),
        CH_0x0101(257, "1 ms resolution"),
        CH_0x0102(258, "10 ms resolution"),
        CH_0x0103(259, "No real time clock"),
        CH_0x0104(260, "BCD time-of-day format"),
        CH_0x0105(261, "All time-of-day functions"),
        CH_0x0106(262, "SFC 78 \"OB_RT\" is available"),
        CH_0x0200(512, "System response (group with index 0200)"),
        CH_0x0201(513, "Capable of multiprocessor mode"),
        CH_0x0202(514, "Cold restart, warm restart and hot restart possible"),
        CH_0x0203(515, "Cold restart and hot restart possible"),
        CH_0x0204(516, "Warm restart and hot restart possible"),
        CH_0x0205(517, "Only warm restart possible"),
        CH_0x0206(518, "New distributed I/O configuration is possible during\nRUN by using predefined resources"),
        CH_0x0207(519, "H-CPU in stand-alone mode: New distributed I/O configuration\nis possible during RUN by using predefined resources"),
        CH_0x0208(520, "For taking motion control functionality into account"),
        CH_0x0300(768, "MC7 Language description of the CPU (group with index 0300)"),
        CH_0x0301(769, "Reserved"),
        CH_0x0302(770, "All 32 bit fixed-point instructions"),
        CH_0x0303(771, "All floating-point instructions"),
        CH_0x0304(772, "sin, asin, cos, acos, tan, atan, sqr, sqrt, ln, exp"),
        CH_0x0305(773, "Accumulator 3/accumulator 4 with corresponding instructions\n(ENT,PUSH,POP,LEAVE)"),
        CH_0x0306(774, "Master Control Relay instructions"),
        CH_0x0307(775, "Address register 1 exists with corresponding instructions"),
        CH_0x0308(776, "Address register 2 exists with corresponding instructions"),
        CH_0x0309(777, "Operations for area-crossing addressing"),
        CH_0x030A(778, "Operations for area-internal addressing"),
        CH_0x030B(779, "All memory-indirect addressing instructions for bit memory (M)"),
        CH_0x030C(780, "All memory-indirect addressing instructions for data blocks (DB)"),
        CH_0x030D(781, "All memory-indirect addressing instructions for data blocks (DI)"),
        CH_0x030E(782, "All memory-indirect addressing instructions for local data (L)"),
        CH_0x030F(783, "All instructions for parameter transfer in FCs"),
        CH_0x0310(784, "Memory bit edge instructions for process image input (I)"),
        CH_0x0311(785, "Memory bit edge instructions for process image output (Q)"),
        CH_0x0312(786, "Memory bit edge instructions for bit memory (M)"),
        CH_0x0313(787, "Memory bit edge instructions for data blocks (DB)"),
        CH_0x0314(788, "Memory bit edge instructions for data blocks (DI)"),
        CH_0x0315(789, "Memory bit edge instructions for local data (L)"),
        CH_0x0316(790, "Dynamic evaluation of the FC bit"),
        CH_0x0317(791, "Dynamic local data area with the corresponding instructions"),
        CH_0x0318(792, "Reserved"),
        CH_0x0319(793, "Reserved"),
        CH_0x0401(1025, "SFC 87 \"C_DIAG\" is available"),
        CH_0x0402(1026, "SFC 88 \"C_CNTRL\" is available)");

        private final int code;
        private final String description;
        private static final Map<Integer, CPU_CHARACTERISTICS> map;

        private CPU_CHARACTERISTICS(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static CPU_CHARACTERISTICS valueOf(int code) {
            return map.get(code);
        }

        static {
            map = new HashMap<Integer, CPU_CHARACTERISTICS>();
            for (CPU_CHARACTERISTICS cpuc : CPU_CHARACTERISTICS.values()) {
                map.put(cpuc.code, cpuc);
            }
        }
    }

    public static enum LED_ID {
        SF(1, "Group error"),
        INTF(2, "Internal error"),
        EXTF(3, "External error"),
        RUN(4, "RUN"),
        STOP(5, "STOP"),
        FRCE(6, "Force"),
        CRST(7, "Cold restart"),
        BAF(8, "Battery fault"),
        USR(9, "User defined"),
        USR1(10, "User defined"),
        BUS1F(11, "Bus error interface 1"),
        BUS2F(12, "Bus error interface 2"),
        REDF(13, "Redundancy error"),
        MSTR(14, "Master"),
        RACK0(15, "Rack number 0"),
        RACK1(16, "Rack number 1"),
        RACK2(17, "Rack number 2"),
        IFM1F(18, "Interface error interface module 1"),
        IFM2F(19, "Interface error interface module 2"),
        BUS3F(20, "Bus error interface 3"),
        MAINT(21, "Maintenance demand"),
        DC24V(22, "DC24V"),
        BUS5F(23, "Bus error interface 5"),
        BUS8F(24, "Bus error interface 8"),
        IF(128, "Init failure"),
        UF(129, "User failure"),
        MF(130, "Monitoring failure"),
        CF(131, "Communication failure"),
        TF(132, "Task failure"),
        APPL_STATE_RED(236, "APPL_STATE_RED"),
        APPL_STATE_GREEN(237, "APPL_STATE_GREEN");

        private final int code;
        private final String description;
        private static final Map<Integer, LED_ID> map;

        private LED_ID(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static LED_ID valueOf(int code) {
            return map.get(code);
        }

        static {
            map = new HashMap<Integer, LED_ID>();
            for (LED_ID ledid : LED_ID.values()) {
                map.put(ledid.code, ledid);
            }
        }
    }

    public static enum MODULE {
        CPU(0),
        IM(4),
        FM(128),
        CP(192);

        private final int code;

        private MODULE(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum OB {
        FREE_CYC(0, "OB1 Free cycle"),
        TOD_INT0(10, "OB10 Time of day interrupt"),
        TOD_INT1(11, "OB11 Time of day interrupt"),
        TOD_INT2(12, "OB12 Time of day interrupt"),
        TOD_INT3(13, "OB13 Time of day interrupt"),
        TOD_INT4(14, "OB14 Time of day interrupt"),
        TOD_INT5(15, "OB15 Time of day interrupt"),
        TOD_INT6(16, "OB16 Time of day interrupt"),
        TOD_INT7(17, "OB17 Time of day interrupt"),
        DEL_INT0(20, "OB20 Time delay interrupt"),
        DEL_INT1(21, "OB21 Time delay interrupt"),
        DEL_INT2(22, "OB22 Time delay interrupt"),
        DEL_INT3(23, "OB23 Time delay interrupt"),
        CYC_INT0(30, "OB30 Cyclic interrupt"),
        CYC_INT1(31, "OB31 Cyclic interrupt"),
        CYC_INT2(32, "OB32 Cyclic interrupt"),
        CYC_INT3(33, "OB33 Cyclic interrupt"),
        CYC_INT4(34, "OB34 Cyclic interrupt"),
        CYC_INT5(35, "OB35 Cyclic interrupt"),
        CYC_INT6(36, "OB36 Cyclic interrupt"),
        CYC_INT7(37, "OB37 Cyclic interrupt"),
        CYC_INT8(38, "OB38 Cyclic interrupt"),
        HW_INT0(40, "OB40 Hardware interrupt"),
        HW_INT1(41, "OB41 Hardware interrupt"),
        HW_INT2(42, "OB42 Hardware interrupt"),
        HW_INT3(43, "OB43 Hardware interrupt"),
        HW_INT4(44, "OB44 Hardware interrupt"),
        HW_INT5(45, "OB45 Hardware interrupt"),
        HW_INT6(46, "OB46 Hardware interrupt"),
        HW_INT7(47, "OB47 Hardware interrupt"),
        BACKGROUND(90, "OB90 Background"),
        COMPLETE_RESTART(100, "OB100 Startup"),
        RESTART(100, "OB101 Background"),
        COLD_RESTART(90, "OB101 Background"),
        CYC_FLT(81, "OB80 Time execution error interrupt"),
        PS_FLT(81, "OB81 Power supply interrupt"),
        IO_FLT1(82, "OB82 Module diagnostic interrupt"),
        IO_FLT2(83, "OB83 Module change interrupt"),
        CPU_FLT(84, "OB84 CPU hardware error interrupt"),
        OBNL_FLT(85, "OB85 Program execution error interrupt"),
        RACK_FLT(86, "OB86 Rack fault interrupt"),
        COMM_FLT(87, "OB87 Communication error interrupt"),
        BREAKUP_ERR(88, "OB88 Process interrupt"),
        SYNC_ERR(121, "OB120 Synchronous error interrupt"),
        PROG_ERR(121, "OB121 Program error interrupt"),
        MOD_ERR(122, "OB122 Module error interrupt");

        private final int code;
        private final String description;
        private static final Map<Integer, OB> map;

        private OB(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static OB valueOf(int code) {
            return map.get(code);
        }

        static {
            map = new HashMap<Integer, OB>();
            for (OB obid : OB.values()) {
                map.put(obid.code, obid);
            }
        }
    }
}

