/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.events;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.events.S7Event;
import org.apache.plc4x.java.s7.readwrite.AssociatedQueryValueType;
import org.apache.plc4x.java.s7.readwrite.AssociatedValueType;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesSubscribeResponse;

public class S7CyclicEvent
implements S7Event {
    private final PlcSubscriptionRequest request;
    private final Instant timeStamp;
    private final Map<String, Object> map = new HashMap<String, Object>();
    private int j;

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobId, S7PayloadUserDataItemCyclicServicesPush event) {
        this.timeStamp = Instant.now();
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.timeStamp);
        this.map.put(Fields.JOBID.name(), jobId);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int i = 0;
        while (i < event.getItemsCount()) {
            AssociatedValueType associatedValueType = event.getItems().get(i);
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, associatedValueType.getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, associatedValueType.getTransportSize().getValue());
            byte[] buffer = new byte[associatedValueType.getData().size()];
            this.j = 0;
            associatedValueType.getData().forEach(s -> {
                byArray[this.j] = s.byteValue();
                ++this.j;
            });
            this.map.put(String.valueOf(Fields.DATA_.name()) + i, buffer);
            ++i;
        }
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobId, S7PayloadUserDataItemCyclicServicesChangeDrivenPush event) {
        this.timeStamp = Instant.now();
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.timeStamp);
        this.map.put(Fields.JOBID.name(), jobId);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int i = 0;
        while (i < event.getItemsCount()) {
            AssociatedQueryValueType associatedQueryValueType = event.getItems().get(i);
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, associatedQueryValueType.getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, associatedQueryValueType.getTransportSize().getValue());
            byte[] buffer = new byte[associatedQueryValueType.getData().size()];
            this.j = 0;
            associatedQueryValueType.getData().forEach(s -> {
                byArray[this.j] = s.byteValue();
                ++this.j;
            });
            this.map.put(String.valueOf(Fields.DATA_.name()) + i, buffer);
            ++i;
        }
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobId, S7PayloadUserDataItemCyclicServicesSubscribeResponse event) {
        this.timeStamp = Instant.now();
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.timeStamp);
        this.map.put(Fields.JOBID.name(), jobId);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int i = 0;
        while (i < event.getItemsCount()) {
            AssociatedValueType associatedValueType = event.getItems().get(i);
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, associatedValueType.getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, associatedValueType.getTransportSize().getValue());
            byte[] buffer = new byte[associatedValueType.getData().size()];
            this.j = 0;
            associatedValueType.getData().forEach(s -> {
                byArray[this.j] = s.byteValue();
                ++this.j;
            });
            this.map.put(String.valueOf(Fields.DATA_.name()) + i, buffer);
            ++i;
        }
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobId, S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse event) {
        this.timeStamp = Instant.now();
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.timeStamp);
        this.map.put(Fields.JOBID.name(), jobId);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int i = 0;
        while (i < event.getItemsCount()) {
            AssociatedQueryValueType associatedQueryValueType = event.getItems().get(i);
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, associatedQueryValueType.getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, associatedQueryValueType.getTransportSize().getValue());
            byte[] buffer = new byte[associatedQueryValueType.getData().size()];
            this.j = 0;
            associatedQueryValueType.getData().forEach(s -> {
                byArray[this.j] = s.byteValue();
                ++this.j;
            });
            this.map.put(String.valueOf(Fields.DATA_.name()) + i, buffer);
            ++i;
        }
    }

    @Override
    public Map<String, Object> getMap() {
        return this.map;
    }

    public Instant getTimestamp() {
        return this.timeStamp;
    }

    public PlcReadRequest getRequest() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcValue getAsPlcValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcValue getPlcValue(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getNumberOfValues(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getObject(String name) {
        if ("REQUEST".equals(name)) {
            return this.request;
        }
        return null;
    }

    public Object getObject(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<Object> getAllObjects(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidBoolean(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidBoolean(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Boolean getBoolean(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Boolean getBoolean(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<Boolean> getAllBooleans(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidByte(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidByte(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Byte getByte(String name) {
        if (!(this.map.get(name) instanceof Byte)) {
            throw new UnsupportedOperationException("Field is not a Byte. Required Byte type.");
        }
        return (byte)((Byte)this.map.get(name));
    }

    public Byte getByte(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 1;
        return byteBuf.getByte(pos);
    }

    public Collection<Byte> getAllBytes(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        byte[] array = (byte[])this.map.get(name);
        return IntStream.range(0, array.length).mapToObj(i -> array[i]).collect(Collectors.toList());
    }

    public boolean isValidShort(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidShort(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Short getShort(String name) {
        if (!(this.map.get(name) instanceof Short)) {
            return null;
        }
        return (short)((Short)this.map.get(name));
    }

    public Short getShort(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 2;
        return byteBuf.getShort(index);
    }

    public Collection<Short> getAllShorts(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Short> list = new ArrayList<Short>();
        while (byteBuf.isReadable(2)) {
            list.add(byteBuf.readShort());
        }
        return list;
    }

    public boolean isValidInteger(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidInteger(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Integer getInteger(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Integer getInteger(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 4;
        return byteBuf.getInt(pos);
    }

    public Collection<Integer> getAllIntegers(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (byteBuf.isReadable(4)) {
            list.add(byteBuf.readInt());
        }
        return list;
    }

    public boolean isValidBigInteger(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidBigInteger(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigInteger getBigInteger(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigInteger getBigInteger(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<BigInteger> getAllBigIntegers(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidLong(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidLong(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Long getLong(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Long getLong(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 8;
        return byteBuf.getLong(pos);
    }

    public Collection<Long> getAllLongs(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Long> list = new ArrayList<Long>();
        while (byteBuf.isReadable(8)) {
            list.add(byteBuf.readLong());
        }
        return list;
    }

    public boolean isValidFloat(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidFloat(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Float getFloat(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Float getFloat(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 4;
        return Float.valueOf(byteBuf.getFloat(pos));
    }

    public Collection<Float> getAllFloats(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Float> list = new ArrayList<Float>();
        while (byteBuf.isReadable(4)) {
            list.add(Float.valueOf(byteBuf.readFloat()));
        }
        return list;
    }

    public boolean isValidDouble(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidDouble(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Double getDouble(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Double getDouble(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 8;
        return byteBuf.getDouble(pos);
    }

    public Collection<Double> getAllDoubles(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Double> list = new ArrayList<Double>();
        while (byteBuf.isReadable(8)) {
            list.add(byteBuf.readDouble());
        }
        return list;
    }

    public boolean isValidBigDecimal(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidBigDecimal(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigDecimal getBigDecimal(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigDecimal getBigDecimal(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<BigDecimal> getAllBigDecimals(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidString(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidString(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getString(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        return byteBuf.toString(Charset.defaultCharset());
    }

    public String getString(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getAllStrings(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidTime(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidTime(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LocalTime getTime(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LocalTime getTime(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<LocalTime> getAllTimes(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidDate(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidDate(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LocalDate getDate(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LocalDate getDate(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<LocalDate> getAllDates(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidDateTime(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidDateTime(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LocalDateTime getDateTime(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LocalDateTime getDateTime(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<LocalDateTime> getAllDateTimes(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getTagNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcTag getTag(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcResponseCode getResponseCode(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum Fields {
        TYPE,
        JOBID,
        TIMESTAMP,
        ITEMSCOUNT,
        REQUEST,
        MAP,
        RETURNCODE_,
        TRANSPORTSIZE_,
        DATA_;

    }
}

