/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.s7.events.S7AlarmEvent;
import org.apache.plc4x.java.s7.events.S7CyclicEvent;
import org.apache.plc4x.java.s7.events.S7ModeEvent;
import org.apache.plc4x.java.s7.events.S7SysEvent;
import org.apache.plc4x.java.s7.events.S7UserEvent;
import org.apache.plc4x.java.s7.readwrite.EventType;
import org.apache.plc4x.java.s7.readwrite.S7ParameterModeTransition;
import org.apache.plc4x.java.s7.readwrite.S7PayloadDiagnosticMessage;
import org.apache.plc4x.java.s7.readwrite.utils.S7PlcSubscriptionHandle;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7ProtocolEventLogic
implements PlcSubscriber {
    private final Logger logger = LoggerFactory.getLogger(S7ProtocolEventLogic.class);
    private final BlockingQueue<?> eventQueue;
    private final BlockingQueue<PlcSubscriptionEvent> dispachQueue = new ArrayBlockingQueue<PlcSubscriptionEvent>(1024);
    private final Map<EventType, Map<PlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>> mapIndex = new HashMap<EventType, Map<PlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>>();
    private final Map<EventType, PlcSubscriptionHandle> eventTypeHandles = new HashMap<EventType, PlcSubscriptionHandle>();
    private final Runnable runProcessor;
    private final Runnable runDispacher;
    private final Thread processor;
    private final Thread dispacher;

    public S7ProtocolEventLogic(BlockingQueue<?> eventQueue) {
        this.eventQueue = eventQueue;
        this.runProcessor = new ObjectProcessor(eventQueue, this.dispachQueue);
        this.runDispacher = new EventDispatcher(this.dispachQueue);
        this.processor = new Thread(this.runProcessor);
        this.dispacher = new Thread(this.runDispacher);
    }

    public void start() {
        this.processor.start();
        this.dispacher.start();
    }

    public void stop() {
        ((ObjectProcessor)this.runProcessor).doShutdown();
        ((EventDispatcher)this.runDispacher).doShutdown();
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        Map<Object, Object> mapConsumers = null;
        S7PlcSubscriptionHandle handle = (S7PlcSubscriptionHandle)((Object)handles.toArray()[0]);
        if (!this.mapIndex.containsKey((Object)handle.getEventType())) {
            mapConsumers = new HashMap();
            this.mapIndex.put(handle.getEventType(), mapConsumers);
        }
        mapConsumers = this.mapIndex.get((Object)handle.getEventType());
        DefaultPlcConsumerRegistration registro = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, handles.toArray(new PlcSubscriptionHandle[0]));
        mapConsumers.put(registro, consumer);
        return registro;
    }

    public void unregister(PlcConsumerRegistration registration) {
        S7PlcSubscriptionHandle handle = (S7PlcSubscriptionHandle)((Object)registration.getSubscriptionHandles().get(0));
        Map<PlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> mapConsumers = this.mapIndex.get((Object)handle.getEventType());
        mapConsumers.remove(registration);
    }

    private class EventDispatcher
    implements Runnable {
        private final Logger LOGGER = LoggerFactory.getLogger(EventDispatcher.class);
        private final BlockingQueue<PlcSubscriptionEvent> dispachQueue;
        private boolean shutdown = false;
        private final int delay = 100;
        private PlcSubscriptionEvent cycDelayedObject = null;

        public EventDispatcher(BlockingQueue<PlcSubscriptionEvent> dispachQueue) {
            this.dispachQueue = dispachQueue;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                S7ProtocolEventLogic.this.logger.warn("Error sleeping", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            while (!this.shutdown) {
                try {
                    Map<PlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> mapConsumers;
                    PlcSubscriptionEvent obj = this.dispachQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (obj == null) continue;
                    if (obj instanceof S7ModeEvent) {
                        if (!S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.MODE)) continue;
                        mapConsumers = S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.MODE);
                        mapConsumers.forEach((x, y) -> y.accept(obj));
                        continue;
                    }
                    if (obj instanceof S7UserEvent) {
                        if (!S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.USR)) continue;
                        mapConsumers = S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.USR);
                        mapConsumers.forEach((x, y) -> y.accept(obj));
                        continue;
                    }
                    if (obj instanceof S7SysEvent) {
                        if (!S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.SYS)) continue;
                        mapConsumers = S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.SYS);
                        mapConsumers.forEach((x, y) -> y.accept(obj));
                        continue;
                    }
                    if (obj instanceof S7AlarmEvent) {
                        if (!S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.ALM)) continue;
                        mapConsumers = S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.ALM);
                        mapConsumers.forEach((x, y) -> y.accept(obj));
                        continue;
                    }
                    if (!(obj instanceof S7CyclicEvent)) continue;
                    if (S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.CYC)) {
                        mapConsumers = S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.CYC);
                        if (this.cycDelayedObject != null) {
                            mapConsumers.forEach((x, y) -> y.accept(this.cycDelayedObject));
                            this.cycDelayedObject = null;
                        }
                        mapConsumers.forEach((x, y) -> y.accept(obj));
                        continue;
                    }
                    this.cycDelayedObject = obj;
                }
                catch (Exception e) {
                    this.LOGGER.error("oh no", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            this.LOGGER.trace("EventDispatcher Bye!");
        }

        public void doShutdown() {
            this.shutdown = true;
        }
    }

    private static class ObjectProcessor
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ObjectProcessor.class);
        private final BlockingQueue<?> eventQueue;
        private final BlockingQueue<PlcSubscriptionEvent> dispatchQueue;
        private boolean shutdown = false;
        private final int delay = 100;

        public ObjectProcessor(BlockingQueue<?> eventQueue, BlockingQueue<PlcSubscriptionEvent> dispatchQueue) {
            this.eventQueue = eventQueue;
            this.dispatchQueue = dispatchQueue;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Object obj = this.eventQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (obj == null) continue;
                    if (obj instanceof S7ParameterModeTransition) {
                        S7ModeEvent modeEvent = new S7ModeEvent((S7ParameterModeTransition)obj);
                        this.dispatchQueue.add(modeEvent);
                        continue;
                    }
                    if (obj instanceof S7PayloadDiagnosticMessage) {
                        S7PayloadDiagnosticMessage msg = (S7PayloadDiagnosticMessage)obj;
                        if (msg.getEventId() >= 40960 && msg.getEventId() <= 49151) {
                            S7UserEvent userEvent = new S7UserEvent(msg);
                            this.dispatchQueue.add(userEvent);
                            continue;
                        }
                        S7SysEvent sysEvent = new S7SysEvent(msg);
                        this.dispatchQueue.add(sysEvent);
                        continue;
                    }
                    if (obj instanceof S7CyclicEvent) {
                        this.dispatchQueue.add((S7CyclicEvent)obj);
                        continue;
                    }
                    S7AlarmEvent alarmEvent = new S7AlarmEvent(obj);
                    this.dispatchQueue.add(alarmEvent);
                }
                catch (InterruptedException e) {
                    LOGGER.error("oh no", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            LOGGER.trace("ObjectProcessor Bye!");
        }

        public void doShutdown() {
            this.shutdown = true;
        }
    }
}

