/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SzlDataTreeItem implements Message {

  // Properties.
  protected final int itemIndex;
  protected final byte[] mlfb;
  protected final int moduleTypeId;
  protected final int ausbg;
  protected final int ausbe;

  public SzlDataTreeItem(int itemIndex, byte[] mlfb, int moduleTypeId, int ausbg, int ausbe) {
    super();
    this.itemIndex = itemIndex;
    this.mlfb = mlfb;
    this.moduleTypeId = moduleTypeId;
    this.ausbg = ausbg;
    this.ausbe = ausbe;
  }

  public int getItemIndex() {
    return itemIndex;
  }

  public byte[] getMlfb() {
    return mlfb;
  }

  public int getModuleTypeId() {
    return moduleTypeId;
  }

  public int getAusbg() {
    return ausbg;
  }

  public int getAusbe() {
    return ausbe;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SzlDataTreeItem");

    // Simple Field (itemIndex)
    writeSimpleField("itemIndex", itemIndex, writeUnsignedInt(writeBuffer, 16));

    // Array Field (mlfb)
    writeByteArrayField("mlfb", mlfb, writeByteArray(writeBuffer, 8));

    // Simple Field (moduleTypeId)
    writeSimpleField("moduleTypeId", moduleTypeId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (ausbg)
    writeSimpleField("ausbg", ausbg, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (ausbe)
    writeSimpleField("ausbe", ausbe, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("SzlDataTreeItem");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SzlDataTreeItem _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (itemIndex)
    lengthInBits += 16;

    // Array field
    if (mlfb != null) {
      lengthInBits += 8 * mlfb.length;
    }

    // Simple field (moduleTypeId)
    lengthInBits += 16;

    // Simple field (ausbg)
    lengthInBits += 16;

    // Simple field (ausbe)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static SzlDataTreeItem staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static SzlDataTreeItem staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("SzlDataTreeItem");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int itemIndex = readSimpleField("itemIndex", readUnsignedInt(readBuffer, 16));

    byte[] mlfb = readBuffer.readByteArray("mlfb", Math.toIntExact(20));

    int moduleTypeId = readSimpleField("moduleTypeId", readUnsignedInt(readBuffer, 16));

    int ausbg = readSimpleField("ausbg", readUnsignedInt(readBuffer, 16));

    int ausbe = readSimpleField("ausbe", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("SzlDataTreeItem");
    // Create the instance
    SzlDataTreeItem _szlDataTreeItem;
    _szlDataTreeItem = new SzlDataTreeItem(itemIndex, mlfb, moduleTypeId, ausbg, ausbe);
    return _szlDataTreeItem;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SzlDataTreeItem)) {
      return false;
    }
    SzlDataTreeItem that = (SzlDataTreeItem) o;
    return (getItemIndex() == that.getItemIndex())
        && (getMlfb() == that.getMlfb())
        && (getModuleTypeId() == that.getModuleTypeId())
        && (getAusbg() == that.getAusbg())
        && (getAusbe() == that.getAusbe())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getItemIndex(), getMlfb(), getModuleTypeId(), getAusbg(), getAusbe());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
