/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.COTPProtocolClass;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class COTPPacketConnectionResponse
extends COTPPacket
implements Message {
    protected final int destinationReference;
    protected final int sourceReference;
    protected final COTPProtocolClass protocolClass;

    @Override
    public Short getTpduCode() {
        return (short)208;
    }

    public COTPPacketConnectionResponse(List<COTPParameter> parameters, S7Message payload, int destinationReference, int sourceReference, COTPProtocolClass protocolClass) {
        super(parameters, payload);
        this.destinationReference = destinationReference;
        this.sourceReference = sourceReference;
        this.protocolClass = protocolClass;
    }

    public int getDestinationReference() {
        return this.destinationReference;
    }

    public int getSourceReference() {
        return this.sourceReference;
    }

    public COTPProtocolClass getProtocolClass() {
        return this.protocolClass;
    }

    @Override
    protected void serializeCOTPPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("COTPPacketConnectionResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"destinationReference", (Object)this.destinationReference, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sourceReference", (Object)this.sourceReference, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"protocolClass", (String)"COTPProtocolClass", (Object)((Object)this.protocolClass), (DataWriter)DataWriterFactory.writeEnum(COTPProtocolClass::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("COTPPacketConnectionResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        COTPPacketConnectionResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += 8;
    }

    public static COTPPacket.COTPPacketBuilder staticParseCOTPPacketBuilder(ReadBuffer readBuffer, Integer cotpLen) throws ParseException {
        readBuffer.pullContext("COTPPacketConnectionResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int destinationReference = (Integer)FieldReaderFactory.readSimpleField((String)"destinationReference", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int sourceReference = (Integer)FieldReaderFactory.readSimpleField((String)"sourceReference", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        COTPProtocolClass protocolClass = (COTPProtocolClass)((Object)FieldReaderFactory.readEnumField((String)"protocolClass", (String)"COTPProtocolClass", (DataReader)DataReaderFactory.readEnum(COTPProtocolClass::enumForValue, (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        readBuffer.closeContext("COTPPacketConnectionResponse", new WithReaderArgs[0]);
        return new COTPPacketConnectionResponseBuilderImpl(destinationReference, sourceReference, protocolClass);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COTPPacketConnectionResponse)) {
            return false;
        }
        COTPPacketConnectionResponse that = (COTPPacketConnectionResponse)o;
        return this.getDestinationReference() == that.getDestinationReference() && this.getSourceReference() == that.getSourceReference() && this.getProtocolClass() == that.getProtocolClass() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getDestinationReference(), this.getSourceReference(), this.getProtocolClass()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class COTPPacketConnectionResponseBuilderImpl
    implements COTPPacket.COTPPacketBuilder {
        private final int destinationReference;
        private final int sourceReference;
        private final COTPProtocolClass protocolClass;

        public COTPPacketConnectionResponseBuilderImpl(int destinationReference, int sourceReference, COTPProtocolClass protocolClass) {
            this.destinationReference = destinationReference;
            this.sourceReference = sourceReference;
            this.protocolClass = protocolClass;
        }

        @Override
        public COTPPacketConnectionResponse build(List<COTPParameter> parameters, S7Message payload) {
            COTPPacketConnectionResponse cOTPPacketConnectionResponse = new COTPPacketConnectionResponse(parameters, payload, this.destinationReference, this.sourceReference, this.protocolClass);
            return cOTPPacketConnectionResponse;
        }
    }
}

