/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItem;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.messages.PlcDiscoveryResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.s7.readwrite.discovery.ProfinetChannel;
import org.apache.plc4x.java.s7discovery.readwrite.Ethernet_Frame;
import org.apache.plc4x.java.s7discovery.readwrite.Ethernet_FramePayload;
import org.apache.plc4x.java.s7discovery.readwrite.Ethernet_FramePayload_PnDcp;
import org.apache.plc4x.java.s7discovery.readwrite.Ethernet_FramePayload_VirtualLan;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Block;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Block_ALLSelector;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Block_DevicePropertiesDeviceId;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Block_DevicePropertiesDeviceRole;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Block_DevicePropertiesDeviceVendor;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Block_DevicePropertiesNameOfStation;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Block_IpParameter;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Pdu;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Pdu_IdentifyReq;
import org.apache.plc4x.java.s7discovery.readwrite.PnDcp_Pdu_IdentifyRes;
import org.apache.plc4x.java.s7discovery.readwrite.VirtualLanPriority;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryResponse;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7PlcDiscoverer
implements PlcDiscoverer {
    private final Logger logger = LoggerFactory.getLogger(S7PlcDiscoverer.class);
    public static final String DEVICE_TYPE_NAME = "DEVICE_PROPERTIES_OPTION-1";
    public static final String DEVICE_NAME_OF_STATION = "DEVICE_PROPERTIES_OPTION-2";
    public static final String DEVICE_ID = "DEVICE_PROPERTIES_OPTION-3";
    public static final String DEVICE_ROLE = "DEVICE_PROPERTIES_OPTION-4";
    public static final String DEVICE_OPTIONS = "DEVICE_PROPERTIES_OPTION-5";
    public static final String DEVICE_INSTANCE = "DEVICE_PROPERTIES_OPTION-7";
    public static final String IP_OPTION_IP = "IP_OPTION-2";
    private static final org.apache.plc4x.java.s7discovery.readwrite.MacAddress PROFINET_BROADCAST_MAC_ADDRESS;
    private final ProfinetChannel channel;
    final List<PlcDiscoveryItem> values = new ArrayList<PlcDiscoveryItem>();
    private PlcDiscoveryItemHandler handler;

    static {
        byte[] byArray = new byte[6];
        byArray[0] = 1;
        byArray[1] = 14;
        byArray[2] = -49;
        PROFINET_BROADCAST_MAC_ADDRESS = new org.apache.plc4x.java.s7discovery.readwrite.MacAddress(byArray);
    }

    public S7PlcDiscoverer(ProfinetChannel channel) {
        this.channel = channel;
        channel.addPacketListener(this::handleIncomingPacket);
    }

    public CompletableFuture<PlcDiscoveryResponse> discover(PlcDiscoveryRequest discoveryRequest) {
        return this.discoverWithHandler(discoveryRequest, null);
    }

    public CompletableFuture<PlcDiscoveryResponse> discoverWithHandler(PlcDiscoveryRequest discoveryRequest, PlcDiscoveryItemHandler handler) {
        this.handler = handler;
        this.sendPnDcpDiscoveryRequest();
        return this.setDiscoveryEndTimer(discoveryRequest, 10000L);
    }

    public void sendPnDcpDiscoveryRequest() {
        for (Map.Entry<org.apache.plc4x.java.s7discovery.readwrite.MacAddress, PcapHandle> entry : this.channel.getOpenHandles().entrySet()) {
            org.apache.plc4x.java.s7discovery.readwrite.MacAddress localMacAddress = entry.getKey();
            PcapHandle handle = entry.getValue();
            Ethernet_Frame identificationRequest = new Ethernet_Frame(PROFINET_BROADCAST_MAC_ADDRESS, localMacAddress, new Ethernet_FramePayload_VirtualLan(VirtualLanPriority.BEST_EFFORT, false, 0, new Ethernet_FramePayload_PnDcp(new PnDcp_Pdu_IdentifyReq(65278, 1L, 256, Collections.singletonList(new PnDcp_Block_ALLSelector())))));
            WriteBufferByteBased buffer = new WriteBufferByteBased(identificationRequest.getLengthInBytes());
            try {
                identificationRequest.serialize((WriteBuffer)buffer);
            }
            catch (SerializationException e) {
                throw new RuntimeException(e);
            }
            try {
                EthernetPacket packet = EthernetPacket.newPacket((byte[])buffer.getBytes(), (int)0, (int)identificationRequest.getLengthInBytes());
                handle.sendPacket((Packet)packet);
            }
            catch (PcapNativeException e) {
                if (e.getMessage().contains("Network is down")) continue;
                throw new RuntimeException(e);
            }
            catch (NotOpenException | IllegalRawDataException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public CompletableFuture<PlcDiscoveryResponse> setDiscoveryEndTimer(final PlcDiscoveryRequest discoveryRequest, long delay) {
        final CompletableFuture<PlcDiscoveryResponse> future = new CompletableFuture<PlcDiscoveryResponse>();
        final Timer timer = new Timer("Discovery Timeout");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DefaultPlcDiscoveryResponse response = new DefaultPlcDiscoveryResponse(discoveryRequest, PlcResponseCode.OK, S7PlcDiscoverer.this.values);
                for (Map.Entry<org.apache.plc4x.java.s7discovery.readwrite.MacAddress, PcapHandle> entry : S7PlcDiscoverer.this.channel.getOpenHandles().entrySet()) {
                    PcapHandle openHandle = entry.getValue();
                    try {
                        openHandle.breakLoop();
                        openHandle.close();
                    }
                    catch (Exception e) {
                        S7PlcDiscoverer.this.logger.error("Error occurred while closing handle");
                    }
                }
                timer.cancel();
                timer.purge();
                future.complete(response);
            }
        }, delay);
        return future;
    }

    protected void handleIncomingPacket(Ethernet_FramePayload frame, EthernetPacket ethernetPacket) {
        PnDcp_Pdu pdu;
        if (frame instanceof Ethernet_FramePayload_PnDcp && (pdu = ((Ethernet_FramePayload_PnDcp)frame).getPdu()).getFrameIdValue() == 65279) {
            this.handlePnDcpPacket(pdu, ethernetPacket);
        }
    }

    public void handlePnDcpPacket(PnDcp_Pdu pdu, EthernetPacket ethernetPacket) {
        block32: {
            if (!(pdu instanceof PnDcp_Pdu_IdentifyRes)) break block32;
            PnDcp_Pdu_IdentifyRes identifyResPDU = (PnDcp_Pdu_IdentifyRes)pdu;
            HashMap<String, PnDcp_Block> blocks = new HashMap<String, PnDcp_Block>();
            for (PnDcp_Block block : identifyResPDU.getBlocks()) {
                String blockName = String.valueOf(block.getOption().name()) + "-" + block.getSuboption().toString();
                blocks.put(blockName, block);
            }
            MacAddress srcAddr = ethernetPacket.getHeader().getSrcAddr();
            MacAddress dstAddr = ethernetPacket.getHeader().getDstAddr();
            String deviceTypeName = "unknown";
            if (blocks.containsKey(DEVICE_TYPE_NAME)) {
                PnDcp_Block_DevicePropertiesDeviceVendor block = (PnDcp_Block_DevicePropertiesDeviceVendor)blocks.get(DEVICE_TYPE_NAME);
                deviceTypeName = new String(block.getDeviceVendorValue());
            }
            String deviceName = "unknown";
            if (blocks.containsKey(DEVICE_NAME_OF_STATION)) {
                PnDcp_Block_DevicePropertiesNameOfStation block = (PnDcp_Block_DevicePropertiesNameOfStation)blocks.get(DEVICE_NAME_OF_STATION);
                deviceName = new String(block.getNameOfStation());
            }
            String role = "unknown";
            if (blocks.containsKey(DEVICE_ROLE)) {
                role = "";
                PnDcp_Block_DevicePropertiesDeviceRole block = (PnDcp_Block_DevicePropertiesDeviceRole)blocks.get(DEVICE_ROLE);
                if (block.getPnioSupervisor()) {
                    role = String.valueOf(role) + ",SUPERVISOR";
                }
                if (block.getPnioMultidevive()) {
                    role = String.valueOf(role) + ",MULTIDEVICE";
                }
                if (block.getPnioController()) {
                    role = String.valueOf(role) + ",CONTROLLER";
                }
                if (block.getPnioDevice()) {
                    role = String.valueOf(role) + ",DEVICE";
                }
                role = !role.isEmpty() ? role.substring(1) : "unknown";
            }
            String remoteAddress = "unknown";
            String remoteSubnetMask = "unknown";
            if (blocks.containsKey(IP_OPTION_IP)) {
                PnDcp_Block_IpParameter block = (PnDcp_Block_IpParameter)blocks.get(IP_OPTION_IP);
                try {
                    InetAddress addr = InetAddress.getByAddress(block.getIpAddress());
                    remoteAddress = addr.getHostAddress();
                    InetAddress netMask = InetAddress.getByAddress(block.getSubnetMask());
                    remoteSubnetMask = netMask.getHostAddress();
                }
                catch (UnknownHostException e) {
                    remoteAddress = "invalid";
                }
            }
            Map<Object, Object> options = Collections.emptyMap();
            if ("0.0.0.0".equals(remoteAddress)) {
                remoteAddress = srcAddr.toString();
                options = Collections.singletonMap("ip-address", "{some-ip-address}");
            }
            String vendorId = "unknown";
            String deviceId = "unknown";
            if (blocks.containsKey(DEVICE_ID)) {
                PnDcp_Block_DevicePropertiesDeviceId block = (PnDcp_Block_DevicePropertiesDeviceId)blocks.get(DEVICE_ID);
                vendorId = String.format("%04X", block.getVendorId());
                deviceId = String.format("%04X", block.getDeviceId());
            }
            boolean supportsS7Comm = false;
            block4 : switch (vendorId) {
                case "002A": {
                    switch (deviceId) {
                        case "010D": {
                            supportsS7Comm = true;
                            break block4;
                        }
                        case "010E": {
                            supportsS7Comm = true;
                        }
                    }
                }
            }
            if (supportsS7Comm) {
                HashMap<String, PlcSTRING> attributes = new HashMap<String, PlcSTRING>();
                attributes.put("ipAddress", new PlcSTRING(remoteAddress));
                attributes.put("subnetMask", new PlcSTRING(remoteSubnetMask));
                attributes.put("macAddress", new PlcSTRING(srcAddr.toString()));
                attributes.put("localMacAddress", new PlcSTRING(dstAddr.toString()));
                attributes.put("deviceTypeName", new PlcSTRING(deviceTypeName));
                attributes.put("deviceName", new PlcSTRING(deviceName));
                attributes.put("vendorId", new PlcSTRING(vendorId));
                attributes.put("deviceId", new PlcSTRING(deviceId));
                attributes.put("role", new PlcSTRING(role));
                attributes.put("packetType", new PlcSTRING("dcp"));
                String name = String.valueOf(deviceTypeName) + " - " + deviceName;
                DefaultPlcDiscoveryItem value = new DefaultPlcDiscoveryItem("s7", "tcp", remoteAddress, options, name, attributes);
                this.values.add((PlcDiscoveryItem)value);
                if (this.handler != null) {
                    this.handler.handle((PlcDiscoveryItem)value);
                }
                this.logger.debug("Found new device: '{}' with connection-url '{}'", (Object)value.getName(), (Object)value.getConnectionUrl());
            }
        }
    }
}

