/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageCodec;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.listener.EventListener;
import org.apache.plc4x.java.spi.EventListenerMessageCodec;
import org.apache.plc4x.java.spi.Plc4xNettyWrapper;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.TimeoutManager;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.configuration.PlcConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedProtocolMessageCodec;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageInput;
import org.apache.plc4x.java.spi.generation.MessageOutput;
import org.apache.plc4x.java.spi.netty.NettyHashTimerTimeoutManager;

public class S7HSingleProtocolStackConfigurer<BASE_PACKET_CLASS extends Message>
implements ProtocolStackConfigurer<BASE_PACKET_CLASS> {
    private final Class<BASE_PACKET_CLASS> basePacketClass;
    private final ByteOrder byteOrder;
    private final Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocolClass;
    private final Class<? extends DriverContext> driverContextClass;
    private final MessageInput<BASE_PACKET_CLASS> messageInput;
    private final MessageOutput<BASE_PACKET_CLASS> messageOutput;
    private final Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimatorClass;
    private final Class<? extends Consumer<ByteBuf>> corruptPacketRemoverClass;
    private final MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler;
    private Plc4xProtocolBase<BASE_PACKET_CLASS> protocol = null;

    public static <BPC extends Message> S7HSingleProtocolStackBuilder<BPC> builder(Class<BPC> basePacketClass, MessageInput<BPC> messageInput) {
        return new S7HSingleProtocolStackBuilder<BPC>(basePacketClass, messageInput, null);
    }

    public static <BPC extends Message> S7HSingleProtocolStackBuilder<BPC> builder(Class<BPC> basePacketClass, MessageInput<BPC> messageInput, MessageOutput<BPC> messageOutput) {
        return new S7HSingleProtocolStackBuilder<BPC>(basePacketClass, messageInput, messageOutput);
    }

    S7HSingleProtocolStackConfigurer(Class<BASE_PACKET_CLASS> basePacketClass, ByteOrder byteOrder, Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol, Class<? extends DriverContext> driverContextClass, MessageInput<BASE_PACKET_CLASS> messageInput, MessageOutput<BASE_PACKET_CLASS> messageOutput, Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimatorClass, Class<? extends Consumer<ByteBuf>> corruptPacketRemoverClass, MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler) {
        this.basePacketClass = basePacketClass;
        this.byteOrder = byteOrder;
        this.protocolClass = protocol;
        this.driverContextClass = driverContextClass;
        this.messageInput = messageInput;
        this.messageOutput = messageOutput;
        this.packetSizeEstimatorClass = packetSizeEstimatorClass;
        this.corruptPacketRemoverClass = corruptPacketRemoverClass;
        this.encryptionHandler = encryptionHandler;
    }

    private ChannelHandler getMessageCodec(PlcConnectionConfiguration configuration) {
        return new GeneratedProtocolMessageCodec(this.basePacketClass, this.messageInput, this.messageOutput, this.byteOrder, this.packetSizeEstimatorClass != null ? (ToIntFunction)ConfigurationFactory.configure((PlcConfiguration)configuration, this.createInstance(this.packetSizeEstimatorClass, new Object[0])) : null, this.corruptPacketRemoverClass != null ? (Consumer)ConfigurationFactory.configure((PlcConfiguration)configuration, this.createInstance(this.corruptPacketRemoverClass, new Object[0])) : null);
    }

    public Plc4xProtocolBase<BASE_PACKET_CLASS> configurePipeline(PlcConnectionConfiguration configuration, ChannelPipeline pipeline, PlcAuthentication authentication, boolean passive, List<EventListener> listeners) {
        if (this.protocol == null) {
            if (this.encryptionHandler != null) {
                pipeline.addLast("ENCRYPT", this.encryptionHandler);
            }
            pipeline.addLast("CODEC", this.getMessageCodec(configuration));
            this.protocol = (Plc4xProtocolBase)ConfigurationFactory.configure((PlcConfiguration)configuration, this.createInstance(this.protocolClass, new Object[0]));
            if (this.driverContextClass != null) {
                this.protocol.setDriverContext((DriverContext)ConfigurationFactory.configure((PlcConfiguration)configuration, (Object)this.createInstance(this.driverContextClass, new Object[0])));
            }
            pipeline.addLast(new ChannelHandler[]{new EventListenerMessageCodec(listeners)});
            Plc4xNettyWrapper context = new Plc4xNettyWrapper((TimeoutManager)new NettyHashTimerTimeoutManager(), pipeline, passive, this.protocol, authentication, this.basePacketClass);
            pipeline.addLast("WRAPPER", (ChannelHandler)context);
        }
        return this.protocol;
    }

    private <T> T createInstance(Class<T> clazz, Object ... args) {
        try {
            Class[] parameterTypes = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                parameterTypes[i] = args[i].getClass();
                ++i;
            }
            return clazz.getDeclaredConstructor(parameterTypes).newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PlcRuntimeException("Error creating instance of class " + clazz.getName());
        }
    }

    public static final class S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS extends Message> {
        private final Class<BASE_PACKET_CLASS> basePacketClass;
        private final MessageInput<BASE_PACKET_CLASS> messageInput;
        private final MessageOutput<BASE_PACKET_CLASS> messageOutput;
        private Class<? extends DriverContext> driverContextClass;
        private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        private Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol;
        private Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimator;
        private Class<? extends Consumer<ByteBuf>> corruptPacketRemover;
        private MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler;

        public S7HSingleProtocolStackBuilder(Class<BASE_PACKET_CLASS> basePacketClass, MessageInput<BASE_PACKET_CLASS> messageInput, MessageOutput<BASE_PACKET_CLASS> messageOutput) {
            this.basePacketClass = basePacketClass;
            this.messageInput = messageInput;
            this.messageOutput = messageOutput;
        }

        public S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS> withDriverContext(Class<? extends DriverContext> driverContextClass) {
            this.driverContextClass = driverContextClass;
            return this;
        }

        public S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS> byteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS> bigEndian() {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            return this;
        }

        public S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS> littleEndian() {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            return this;
        }

        public S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS> withProtocol(Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol) {
            this.protocol = protocol;
            return this;
        }

        public S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS> withPacketSizeEstimator(Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimator) {
            this.packetSizeEstimator = packetSizeEstimator;
            return this;
        }

        public S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS> withCorruptPacketRemover(Class<? extends Consumer<ByteBuf>> corruptPacketRemover) {
            this.corruptPacketRemover = corruptPacketRemover;
            return this;
        }

        public S7HSingleProtocolStackBuilder<BASE_PACKET_CLASS> withEncryptionHandler(MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler) {
            this.encryptionHandler = encryptionHandler;
            return this;
        }

        public S7HSingleProtocolStackConfigurer<BASE_PACKET_CLASS> build() {
            assert (this.protocol != null);
            return new S7HSingleProtocolStackConfigurer<BASE_PACKET_CLASS>(this.basePacketClass, this.byteOrder, this.protocol, this.driverContextClass, this.messageInput, this.messageOutput, this.packetSizeEstimator, this.corruptPacketRemover, this.encryptionHandler);
        }
    }
}

