/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcTagRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.events.S7AlarmEvent;
import org.apache.plc4x.java.s7.events.S7CyclicEvent;
import org.apache.plc4x.java.s7.events.S7Event;
import org.apache.plc4x.java.s7.events.S7ModeEvent;
import org.apache.plc4x.java.s7.events.S7SysEvent;
import org.apache.plc4x.java.s7.events.S7UserEvent;
import org.apache.plc4x.java.s7.readwrite.AlarmMessageObjectAckType;
import org.apache.plc4x.java.s7.readwrite.AlarmStateType;
import org.apache.plc4x.java.s7.readwrite.AlarmType;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketData;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCalledTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCallingTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterTpduSize;
import org.apache.plc4x.java.s7.readwrite.COTPProtocolClass;
import org.apache.plc4x.java.s7.readwrite.COTPTpduSize;
import org.apache.plc4x.java.s7.readwrite.ControllerType;
import org.apache.plc4x.java.s7.readwrite.CycServiceItemAnyType;
import org.apache.plc4x.java.s7.readwrite.CycServiceItemDbReadType;
import org.apache.plc4x.java.s7.readwrite.CycServiceItemType;
import org.apache.plc4x.java.s7.readwrite.DataItem;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.DataTransportSize;
import org.apache.plc4x.java.s7.readwrite.DateAndTime;
import org.apache.plc4x.java.s7.readwrite.EventType;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.QueryType;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponse;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7MessageUserData;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7ParameterModeTransition;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterSetupCommunication;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItemCPUFunctions;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7Payload;
import org.apache.plc4x.java.s7.readwrite.S7PayloadDiagnosticMessage;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserData;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemClkFResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemClkRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemClkResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemClkSetRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmAckRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmAckResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmQueryRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmQueryResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesErrorResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesSubscribeRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesUnsubscribeRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesUnsubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadDataItem;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadStatusItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItemAddress;
import org.apache.plc4x.java.s7.readwrite.State;
import org.apache.plc4x.java.s7.readwrite.SubItem;
import org.apache.plc4x.java.s7.readwrite.SyntaxIdType;
import org.apache.plc4x.java.s7.readwrite.SzlId;
import org.apache.plc4x.java.s7.readwrite.SzlModuleTypeClass;
import org.apache.plc4x.java.s7.readwrite.SzlSublist;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7.readwrite.protocol.S7HMuxImpl;
import org.apache.plc4x.java.s7.readwrite.protocol.S7ProtocolEventLogic;
import org.apache.plc4x.java.s7.readwrite.tag.S7AckTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7ClkTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7PlcTagHandler;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringFixedLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringVarLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7SubscriptionTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7SzlTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.s7.readwrite.types.S7SubscriptionType;
import org.apache.plc4x.java.s7.readwrite.utils.S7PlcSubscriptionHandle;
import org.apache.plc4x.java.s7.utils.S7ParamErrorCode;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagValueItem;
import org.apache.plc4x.java.spi.messages.utils.PlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagItem;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.DefaultPlcValueHandler;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_LTIME;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7ProtocolLogic
extends Plc4xProtocolBase<TPKTPacket> {
    private static final Logger logger = LoggerFactory.getLogger(S7ProtocolLogic.class);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private final AtomicInteger tpduGenerator = new AtomicInteger(10);
    private final ExecutorService clientExecutorService = Executors.newFixedThreadPool(4, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("plc4x-app-thread-%d").daemon(true).priority(10).build());
    private final BlockingQueue<S7Event> eventQueue = new ArrayBlockingQueue<S7Event>(1024);
    private final S7ProtocolEventLogic eventLogic = new S7ProtocolEventLogic(this.eventQueue);
    private final S7PlcSubscriptionHandle modeHandle = new S7PlcSubscriptionHandle(EventType.MODE, this.eventLogic);
    private final S7PlcSubscriptionHandle sysHandle = new S7PlcSubscriptionHandle(EventType.SYS, this.eventLogic);
    private final S7PlcSubscriptionHandle usrHandle = new S7PlcSubscriptionHandle(EventType.USR, this.eventLogic);
    private final S7PlcSubscriptionHandle almHandle = new S7PlcSubscriptionHandle(EventType.ALM, this.eventLogic);
    private final Map<Short, PlcSubscriptionRequest> cycRequests = new HashMap<Short, PlcSubscriptionRequest>();
    private final Map<Short, S7CyclicEvent> cycChangeValueEvents = new HashMap<Short, S7CyclicEvent>();
    private S7DriverContext s7DriverContext;
    private RequestTransactionManager tm;

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        this.s7DriverContext = (S7DriverContext)driverContext;
        this.tm = new RequestTransactionManager(1);
        this.eventLogic.start();
    }

    public PlcTagHandler getTagHandler() {
        return new S7PlcTagHandler();
    }

    public void close(ConversationContext<TPKTPacket> context) {
        this.tm.shutdown();
        this.eventLogic.stop();
    }

    public void onConnect(ConversationContext<TPKTPacket> context) {
        logger.info("onConnect");
        if (context.isPassive()) {
            logger.info("S7 Driver running in PASSIVE mode.");
            this.s7DriverContext.setPassiveMode(true);
            context.fireConnected();
            return;
        }
        this.setChannelFeatures();
        logger.info("S7 Driver running in ACTIVE mode.");
        logger.debug("Sending COTP Connection Request");
        TPKTPacket packet = new TPKTPacket(this.createCOTPConnectionRequest(this.s7DriverContext.getCalledTsapId(), this.s7DriverContext.getCallingTsapId(), this.s7DriverContext.getCotpTpduSize()));
        context.sendRequest((Object)packet).onTimeout(e -> logger.info("Timeout during Connection establishing, closing channel...")).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).unwrap(TPKTPacket::getPayload).only(COTPPacketConnectionResponse.class).handle(cotpPacketConnectionResponse -> {
            logger.debug("Got COTP Connection Response");
            logger.debug("Sending S7 Connection Request");
            context.sendRequest((Object)this.createS7ConnectionRequest((COTPPacketConnectionResponse)cotpPacketConnectionResponse)).onTimeout(e -> {
                logger.warn("Timeout during Connection establishing, closing channel...");
                context.getChannel().close();
            }).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).only(S7MessageResponseData.class).unwrap(S7Message::getParameter).only(S7ParameterSetupCommunication.class).handle(setupCommunication -> {
                logger.debug("Got S7 Connection Response");
                this.s7DriverContext.setMaxAmqCaller(setupCommunication.getMaxAmqCaller());
                this.s7DriverContext.setMaxAmqCallee(setupCommunication.getMaxAmqCallee());
                this.s7DriverContext.setPduSize(setupCommunication.getPduLength());
                this.tm.setNumberOfConcurrentRequests(this.s7DriverContext.getMaxAmqCallee());
                if (this.s7DriverContext.getControllerType() != ControllerType.ANY) {
                    context.fireConnected();
                    return;
                }
                logger.debug("Sending S7 Identification Request");
                TPKTPacket tpktPacket = this.createIdentifyRemoteMessage();
                context.sendRequest((Object)tpktPacket).onTimeout(e -> {
                    logger.warn("Timeout during Connection establishing, closing channel...");
                    context.getChannel().close();
                }).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).only(S7MessageUserData.class).unwrap(S7Message::getPayload).only(S7PayloadUserData.class).handle(payloadUserData -> {
                    logger.debug("Got S7 Identification Response");
                    this.extractControllerTypeAndFireConnected(context, (S7PayloadUserData)payloadUserData);
                });
            });
        });
    }

    public void onDisconnect(ConversationContext<TPKTPacket> context) {
        logger.info("onDisconnect");
        this.clientExecutorService.shutdownNow();
        this.tm.shutdown();
        this.eventLogic.stop();
        context.getChannel().close();
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<S7Message> responseFuture;
        if (!this.isConnected()) {
            CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Disconnected"));
            return future;
        }
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        if (request.getTagNames().stream().anyMatch(t -> request.getTag(t) instanceof S7SzlTag)) {
            S7SzlTag szlTag = (S7SzlTag)request.getTags().get(0);
            S7MessageUserData s7Message = new S7MessageUserData(this.getTpduId(), new S7ParameterUserData(List.of(new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 1, 0, null, null, null))), new S7PayloadUserData(List.of(new S7PayloadUserDataItemCpuFunctionReadSzlRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 4, new SzlId(SzlModuleTypeClass.enumForValue((byte)((szlTag.getSzlId() & 0xF000) >> 12)), (byte)((szlTag.getSzlId() & 0xF00) >> 8), SzlSublist.enumForValue((short)(szlTag.getSzlId() & 0xFF))), szlTag.getIndex()))));
            responseFuture = this.sendInternal(s7Message);
        } else {
            responseFuture = request.getTagNames().stream().anyMatch(t -> request.getTag(t) instanceof S7AckTag) ? this.performAlarmAckRequest(request) : (request.getTagNames().stream().anyMatch(t -> request.getTag(t) instanceof S7ClkTag) ? this.performClkRequest(request) : (request.getTagNames().stream().anyMatch(t -> request.getTag(t) instanceof S7StringVarLengthTag) ? this.performVarLengthStringReadRequest(request) : this.performOrdinaryReadRequest(request)));
        }
        return this.toPlcReadResponse(readRequest, responseFuture);
    }

    private CompletableFuture<PlcReadResponse> toPlcReadResponse(PlcReadRequest readRequest, CompletableFuture<S7Message> responseFuture) {
        CompletableFuture<PlcReadResponse> clientFuture = new CompletableFuture<PlcReadResponse>();
        S7Message[] responseMessage = new S7Message[1];
        PlcReadRequest[] plcReadRequest = new PlcReadRequest[1];
        responseFuture.whenComplete((s7Message, throwable) -> {
            if (throwable != null) {
                clientFuture.completeExceptionally((Throwable)new PlcProtocolException("Error reading", throwable));
            } else {
                try {
                    s7MessageArray[0] = s7Message;
                    plcReadRequestArray[0] = readRequest;
                    this.clientExecutorService.submit(() -> {
                        try {
                            PlcReadResponse response = (PlcReadResponse)this.decodeReadResponse(responseMessage[0], plcReadRequest[0]);
                            clientFuture.complete(response);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                catch (Exception ex) {
                    logger.info(ex.toString());
                }
            }
        });
        return clientFuture;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        if (!this.isConnected()) {
            CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Disconnected"));
            return future;
        }
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        CompletableFuture<S7Message> responseFuture = new CompletableFuture();
        responseFuture = request.getTagNames().stream().anyMatch(t -> request.getTag(t) instanceof S7ClkTag) ? this.performClkSetRequest((DefaultPlcWriteRequest)writeRequest) : (request.getTagNames().stream().anyMatch(t -> request.getTag(t) instanceof S7StringVarLengthTag) ? this.performVarLengthStringWriteRequest((DefaultPlcWriteRequest)writeRequest) : this.performOrdinaryWriteRequest(request));
        return this.toPlcWriteResponse(writeRequest, responseFuture);
    }

    private CompletableFuture<PlcWriteResponse> toPlcWriteResponse(PlcWriteRequest writeRequest, CompletableFuture<S7Message> responseFuture) {
        CompletableFuture<PlcWriteResponse> clientFuture = new CompletableFuture<PlcWriteResponse>();
        responseFuture.whenComplete((s7Message, throwable) -> {
            if (throwable != null) {
                clientFuture.completeExceptionally((Throwable)new PlcProtocolException("Error writing", throwable));
            } else {
                try {
                    PlcWriteResponse response = (PlcWriteResponse)this.decodeWriteResponse((S7Message)s7Message, writeRequest);
                    clientFuture.complete(response);
                }
                catch (Exception ex) {
                    logger.info(ex.toString());
                }
            }
        });
        return clientFuture;
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        if (!this.isConnected()) {
            CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Disconnected"));
            return future;
        }
        if (!this.isFeatureSupported()) {
            CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Not Supported"));
            return future;
        }
        CompletableFuture future = new CompletableFuture();
        HashMap valuesResponse = new HashMap();
        HashMap futures = new HashMap();
        CompletableFuture<PlcSubscriptionResponse> response = new CompletableFuture<PlcSubscriptionResponse>();
        subscriptionRequest.getTagNames().forEach(fieldName -> {
            CompletableFuture completableFuture = futures.put((String)fieldName, new CompletableFuture());
        });
        futures.put("DATA_", new CompletableFuture());
        DefaultPlcSubscriptionRequest defaultRequest = (DefaultPlcSubscriptionRequest)subscriptionRequest;
        int tpduId = this.getTpduId();
        this.clientExecutorService.submit(() -> {
            DefaultPlcSubscriptionTag sf = (DefaultPlcSubscriptionTag)subscriptionRequest.getTags().get(0);
            S7SubscriptionTag tag = (S7SubscriptionTag)sf.getTag();
            S7Message s7Message = null;
            switch (tag.getTagType()) {
                case EVENT_SUBSCRIPTION: {
                    s7Message = this.encodeEventSubscriptionRequest(defaultRequest, tpduId);
                    break;
                }
                case EVENT_UNSUBSCRIPTION: {
                    break;
                }
                case ALARM_ACK: {
                    break;
                }
                case ALARM_QUERY: {
                    s7Message = this.encodeAlarmQueryRequest(defaultRequest, tpduId);
                    break;
                }
                case CYCLIC_SUBSCRIPTION: {
                    s7Message = this.encodeCycledS7ANYSubscriptionRequest(defaultRequest, tpduId);
                    break;
                }
                case CYCLIC_DB_SUBSCRIPTION: {
                    s7Message = this.encodeCycledDBREADSubscriptionRequest(defaultRequest, tpduId);
                    break;
                }
            }
            if (s7Message == null) {
                throw new PlcInvalidTagException("Unsupported tag of type: " + (Object)((Object)tag.getTagType()));
            }
            TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, s7Message, true, (byte)tpduId));
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.conversationContext.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
                    transaction.endRequest();
                    try {
                        ((CompletableFuture)futures.get("DATA_")).complete(p);
                    }
                    catch (Exception e) {
                        logger.warn("Error sending 'write' message: '{}'", (Object)e.getMessage(), (Object)e);
                    }
                });
            });
            try {
                S7Message responseMessage = (S7Message)((CompletableFuture)futures.get("DATA_")).get();
                S7ParameterUserData parameter = (S7ParameterUserData)responseMessage.getParameter();
                S7ParameterUserDataItemCPUFunctions msgParameter = (S7ParameterUserDataItemCPUFunctions)parameter.getItems().get(0);
                valuesResponse.put(Integer.toString(msgParameter.getSequenceNumber()), this.decodeEventSubscriptionResponse(Integer.toString(msgParameter.getSequenceNumber()), subscriptionRequest, (S7Message)((CompletableFuture)futures.get("DATA_")).get()));
            }
            catch (Exception ex) {
                logger.warn(ex.toString());
            }
            try {
                HashMap values = new HashMap();
                valuesResponse.forEach((s, p) -> {
                    if (p != null) {
                        values.putAll(((DefaultPlcSubscriptionResponse)p).getValues());
                    }
                });
                response.complete((PlcSubscriptionResponse)new DefaultPlcSubscriptionResponse(subscriptionRequest, values));
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage());
            }
        });
        return response;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        if (!this.isConnected()) {
            CompletableFuture<PlcUnsubscriptionResponse> future = new CompletableFuture<PlcUnsubscriptionResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Disconnected"));
            return future;
        }
        if (!this.isFeatureSupported()) {
            CompletableFuture<PlcUnsubscriptionResponse> future = new CompletableFuture<PlcUnsubscriptionResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Not Supported"));
            return future;
        }
        CompletableFuture<PlcUnsubscriptionResponse> future = new CompletableFuture<PlcUnsubscriptionResponse>();
        DefaultPlcUnsubscriptionRequest request = (DefaultPlcUnsubscriptionRequest)unsubscriptionRequest;
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>();
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>();
        this.encodeCycledUnSubscriptionRequest(request, parameterItems, payloadItems);
        int tpduId = this.getTpduId();
        TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, new S7MessageUserData(tpduId, new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems)), true, (byte)tpduId));
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.conversationContext.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
                transaction.endRequest();
                try {
                    future.complete(null);
                }
                catch (Exception e) {
                    logger.warn("Error sending 'write' message: '{}'", (Object)e.getMessage(), (Object)e);
                }
            });
        });
        return future;
    }

    private S7Message encodeEventSubscriptionRequest(DefaultPlcSubscriptionRequest request, int tpduId) {
        S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest payload;
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfTags());
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfTags());
        short subsEvent = 0;
        for (String tagName : request.getTagNames()) {
            PlcTag event;
            if (!(request.getTag(tagName) instanceof DefaultPlcSubscriptionTag) || !((event = ((DefaultPlcSubscriptionTag)request.getTag(tagName)).getTag()) instanceof S7SubscriptionTag) || ((S7SubscriptionTag)event).getTagType() != S7SubscriptionType.EVENT_SUBSCRIPTION) continue;
            subsEvent = (byte)(subsEvent | ((S7SubscriptionTag)event).getEventType().getValue());
        }
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 2, 0, null, null, null);
        parameterItems.add(parameter);
        if (subsEvent > 0) {
            payload = new S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 10, subsEvent, "HmiRtm  ", null, null);
        } else {
            AlarmStateType alarmType = this.s7DriverContext.getControllerType() == ControllerType.S7_400 ? AlarmStateType.ALARM_INITIATE : AlarmStateType.ALARM_S_INITIATE;
            short auxSubsEvent = (short)(subsEvent & 0xFF);
            payload = new S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, auxSubsEvent, "HmiRtm  ", alarmType, (short)0);
        }
        payloadItems.add(payload);
        return new S7MessageUserData(tpduId, new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems));
    }

    private PlcSubscriptionResponse decodeEventSubscriptionResponse(String strTagName, PlcSubscriptionRequest plcSubscriptionRequest, S7Message responseMessage) throws PlcProtocolException {
        S7PayloadUserDataItem item;
        HashMap<String, DefaultPlcResponseItem> values = new HashMap<String, DefaultPlcResponseItem>();
        short errorClass = 0;
        short errorCode = 0;
        if (responseMessage instanceof S7MessageUserData) {
            S7ParameterUserData s7ParameterUserData;
            S7ParameterUserDataItem s7ParameterUserDataItem;
            S7MessageUserData messageUserData = (S7MessageUserData)responseMessage;
            S7Parameter s7Parameter = messageUserData.getParameter();
            if (s7Parameter instanceof S7ParameterUserData && (s7ParameterUserDataItem = (s7ParameterUserData = (S7ParameterUserData)s7Parameter).getItems().get(0)) instanceof S7ParameterUserDataItemCPUFunctions) {
                S7ParameterUserDataItemCPUFunctions s7ParameterUserDataItemCPUFunctions = (S7ParameterUserDataItemCPUFunctions)s7ParameterUserDataItem;
                errorCode = s7ParameterUserDataItemCPUFunctions.getErrorCode().shortValue();
            }
        } else if (responseMessage instanceof S7MessageResponse) {
            S7MessageResponse messageResponse = (S7MessageResponse)responseMessage;
            errorClass = messageResponse.getErrorClass();
            errorCode = messageResponse.getErrorCode();
        } else {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String tagName : plcSubscriptionRequest.getTagNames()) {
                    values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.REMOTE_ERROR, null));
                }
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (errorClass == 0 && errorCode == -32508) {
                logger.warn("Got an error response from the PLC. Error Class: {}, Error Code {}. This particular response code usually indicates that a given service is not implemented on the PLC. Most probably you tried to subscribe to data on a PLC that doesn't support subscriptions (S7-1200 or S7-1500)", (Object)errorClass, (Object)errorCode);
                for (String tagName : plcSubscriptionRequest.getTagNames()) {
                    values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.UNSUPPORTED, null));
                }
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String tagName : plcSubscriptionRequest.getTagNames()) {
                values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
            }
            return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
        }
        S7ParameterUserData parameter = (S7ParameterUserData)responseMessage.getParameter();
        List<S7ParameterUserDataItem> parameters = parameter.getItems();
        S7ParameterUserDataItemCPUFunctions itemparameter = (S7ParameterUserDataItemCPUFunctions)parameters.get(0);
        errorCode = itemparameter.getErrorCode().shortValue();
        S7PayloadUserData payload = (S7PayloadUserData)responseMessage.getPayload();
        List<S7PayloadUserDataItem> payloadItems = payload.getItems();
        if (payloadItems.isEmpty()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        boolean responseOk = false;
        if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse) {
            item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse)payloadItems.get(0);
            if (item.getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
                responseOk = true;
            }
        } else if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse) {
            item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse)payloadItems.get(0);
            if (item.getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
                responseOk = true;
            }
        } else if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse) {
            item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse)payloadItems.get(0);
            if (item.getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
                responseOk = true;
            }
        } else {
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionAlarmAckResponse) {
                S7PayloadUserDataItemCpuFunctionAlarmAckResponse items = (S7PayloadUserDataItemCpuFunctionAlarmAckResponse)payloadItems.get(0);
                values.put(strTagName, new DefaultPlcResponseItem(PlcResponseCode.OK, null));
                for (short s : items.getMessageObjects()) {
                    if (s == 0) {
                        values.put(Integer.toHexString(s), new DefaultPlcResponseItem(PlcResponseCode.OK, null));
                        continue;
                    }
                    if (s != 10) continue;
                    values.put(Integer.toHexString(s), new DefaultPlcResponseItem(PlcResponseCode.NOT_FOUND, null));
                }
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse) {
                values.put(strTagName, new DefaultPlcResponseItem(PlcResponseCode.NOT_FOUND, null));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) {
                S7PayloadUserDataItemCpuFunctionAlarmQueryResponse items = (S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)payloadItems.get(0);
                ByteBuf buffer = Unpooled.directBuffer((int)(items.getItems().length * 2));
                ByteBuf rxBuffer = Unpooled.directBuffer((int)(items.getItems().length * 2));
                buffer.writeBytes(items.getItems());
                if (itemparameter.getLastDataUnit() == 1) {
                    int loop = 255;
                    S7PayloadUserDataItem loopPayload = null;
                    do {
                        CompletableFuture<S7MessageUserData> loopFuture = this.reassembledAlarmEvents(itemparameter.getSequenceNumber());
                        try {
                            S7MessageUserData msg = loopFuture.get();
                            if (msg != null) {
                                S7ParameterUserDataItemCPUFunctions loopParameter = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)msg.getParameter()).getItems().get(0);
                                loopPayload = (S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)((S7PayloadUserData)msg.getPayload()).getItems().get(0);
                                buffer.writeBytes(((S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)loopPayload).getItems());
                                loop = loopParameter.getLastDataUnit().shortValue();
                                continue;
                            }
                            loop = 0;
                        }
                        catch (Exception ex) {
                            logger.warn(ex.toString());
                        }
                    } while (loop > 0);
                    rxBuffer.writeByte((int)loopPayload.getReturnCode().getValue());
                    rxBuffer.writeByte((int)loopPayload.getTransportSize().getValue());
                    rxBuffer.writeShort(loopPayload.getDataLength());
                    rxBuffer.writeBytes(buffer);
                } else {
                    rxBuffer.writeByte((int)payloadItems.get(0).getReturnCode().getValue());
                    rxBuffer.writeByte((int)payloadItems.get(0).getTransportSize().getValue());
                    rxBuffer.writeShort(payloadItems.get(0).getDataLength());
                    rxBuffer.writeBytes(buffer);
                }
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(ByteBufUtil.getBytes((ByteBuf)rxBuffer));
                try {
                    short cpuSubFunction = this.s7DriverContext.getControllerType() == ControllerType.S7_300 ? (short)19 : 240;
                    S7PayloadUserDataItem s7PayloadUserDataItem = S7PayloadUserDataItem.staticParse((ReadBuffer)readBuffer, (byte)4, (byte)0, cpuSubFunction);
                }
                catch (Exception ex) {
                    logger.info(ex.toString());
                }
                PlcResponseCode resCode = items.getReturnCode() == DataTransportErrorCode.OK ? PlcResponseCode.OK : PlcResponseCode.INTERNAL_ERROR;
                values.put(strTagName, new DefaultPlcResponseItem(resCode, null));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCyclicServicesSubscribeResponse) {
                S7ParameterUserDataItemCPUFunctions msgParameter = (S7ParameterUserDataItemCPUFunctions)parameter.getItems().get(0);
                this.cycRequests.put(msgParameter.getSequenceNumber(), plcSubscriptionRequest);
                S7CyclicEvent cycEvent = new S7CyclicEvent(plcSubscriptionRequest, msgParameter.getSequenceNumber(), (S7PayloadUserDataItemCyclicServicesSubscribeResponse)payloadItems.get(0));
                if (((PlcSubscriptionTag)plcSubscriptionRequest.getTags().get(0)).getPlcSubscriptionType() == PlcSubscriptionType.CHANGE_OF_STATE) {
                    this.cycChangeValueEvents.put(msgParameter.getSequenceNumber(), cycEvent);
                }
                this.eventQueue.add(cycEvent);
                S7PlcSubscriptionHandle cycHandle = new S7PlcSubscriptionHandle(strTagName, EventType.CYC, this.eventLogic);
                DefaultPlcResponseItem response = new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)cycHandle);
                plcSubscriptionRequest.getTagNames().forEach(arg_0 -> S7ProtocolLogic.lambda$35(values, (PlcResponseItem)response, arg_0));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse) {
                S7ParameterUserDataItemCPUFunctions msgParameter = (S7ParameterUserDataItemCPUFunctions)parameter.getItems().get(0);
                this.cycRequests.put(msgParameter.getSequenceNumber(), plcSubscriptionRequest);
                S7CyclicEvent cycEvent = new S7CyclicEvent(plcSubscriptionRequest, msgParameter.getSequenceNumber(), (S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse)payloadItems.get(0));
                this.eventQueue.add(cycEvent);
                S7PlcSubscriptionHandle cycHandle = new S7PlcSubscriptionHandle(strTagName, EventType.CYC, this.eventLogic);
                values.put(strTagName, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)cycHandle));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCyclicServicesErrorResponse) {
                logger.warn("Request field: " + strTagName + ": " + (Object)((Object)S7ParamErrorCode.valueOf(errorCode)) + " " + S7ParamErrorCode.valueOf(errorCode).getEvent());
                values.put(strTagName, new DefaultPlcResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCyclicServicesUnsubscribeResponse) {
                values.put(strTagName, new DefaultPlcResponseItem(PlcResponseCode.OK, null));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
        }
        if (responseOk) {
            for (String tagName : plcSubscriptionRequest.getTagNames()) {
                DefaultPlcSubscriptionTag dTag = (DefaultPlcSubscriptionTag)plcSubscriptionRequest.getTag(tagName);
                S7SubscriptionTag tag = (S7SubscriptionTag)dTag.getTag();
                switch (tag.getEventType()) {
                    case MODE: {
                        values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)this.modeHandle));
                        break;
                    }
                    case SYS: {
                        values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)this.sysHandle));
                        break;
                    }
                    case USR: {
                        values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)this.usrHandle));
                        break;
                    }
                    case ALM: {
                        values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)this.almHandle));
                    }
                }
            }
            return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
        }
        return null;
    }

    private CompletableFuture<S7Message> performAlarmAckRequest(DefaultPlcReadRequest request) {
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfTags());
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfTags());
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 11, 0, null, null, null);
        parameterItems.add(parameter);
        ArrayList<AlarmMessageObjectAckType> messageObjects = null;
        for (String fieldName : request.getTagNames()) {
            PlcTag field;
            if (!(request.getTag(fieldName) instanceof S7AckTag) || !((field = request.getTag(fieldName)) instanceof S7AckTag)) continue;
            ArrayList<Integer> arrAlarmIds = ((S7AckTag)field).getAlarmIds();
            ArrayList<Integer> arrAlarmSigs = ((S7AckTag)field).getAlarmSigs();
            messageObjects = new ArrayList<AlarmMessageObjectAckType>();
            int i = 0;
            while (i < arrAlarmIds.size()) {
                BitSet bs = BitSet.valueOf(new byte[]{arrAlarmSigs.get(i).byteValue()});
                AlarmMessageObjectAckType messageObject = new AlarmMessageObjectAckType(SyntaxIdType.ALARM_ACKSET, 0, arrAlarmIds.get(i).intValue(), new State(bs.get(7), bs.get(6), bs.get(5), bs.get(4), bs.get(3), bs.get(2), bs.get(1), bs.get(0)), new State(bs.get(7), bs.get(6), bs.get(5), bs.get(4), bs.get(3), bs.get(2), bs.get(1), bs.get(0)));
                messageObjects.add(messageObject);
                ++i;
            }
        }
        S7PayloadUserDataItemCpuFunctionAlarmAckRequest payload = new S7PayloadUserDataItemCpuFunctionAlarmAckRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, messageObjects);
        payloadItems.add(payload);
        return this.sendInternal(new S7MessageUserData(this.getTpduId(), new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems)));
    }

    private S7Message encodeAlarmQueryRequest(DefaultPlcSubscriptionRequest request, int tpduId) {
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfTags());
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfTags());
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 19, 0, null, null, null);
        parameterItems.add(parameter);
        S7PayloadUserDataItemCpuFunctionAlarmQueryRequest payload = new S7PayloadUserDataItemCpuFunctionAlarmQueryRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, SyntaxIdType.ALARM_QUERYREQSET, QueryType.ALARM_8P, AlarmType.ALARM_8);
        payloadItems.add(payload);
        return new S7MessageUserData(tpduId, new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems));
    }

    private S7Message encodeCycledS7ANYSubscriptionRequest(DefaultPlcSubscriptionRequest request, int tpduId) {
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfTags());
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfTags());
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 2, 1, 0, null, null, null);
        parameterItems.add(parameter);
        ArrayList<CycServiceItemType> items = new ArrayList<CycServiceItemType>();
        request.getTags().forEach(tag -> {
            S7SubscriptionTag s7tag = (S7SubscriptionTag)((DefaultPlcSubscriptionTag)tag).getTag();
            S7Tag[] s7TagArray = s7tag.getS7Tags();
            int n = s7TagArray.length;
            int n2 = 0;
            while (n2 < n) {
                S7Tag userField = s7TagArray[n2];
                items.add(new CycServiceItemAnyType(10, 16, userField.getDataType(), userField.getNumberOfElements(), userField.getBlockNumber(), userField.getMemoryArea(), userField.getByteOffset() << 3 | userField.getBitOffset() & 7));
                ++n2;
            }
        });
        S7SubscriptionTag s7tag_base = (S7SubscriptionTag)((DefaultPlcSubscriptionTag)request.getTags().get(0)).getTag();
        int lengthInBytes = 4 + items.size() * 12;
        S7PayloadUserDataItemCyclicServicesSubscribeRequest payload = new S7PayloadUserDataItemCyclicServicesSubscribeRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, lengthInBytes, items.size(), s7tag_base.getTimeBase(), s7tag_base.getMultiplier(), items);
        payloadItems.add(payload);
        return new S7MessageUserData(tpduId, new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems));
    }

    private S7Message encodeCycledDBREADSubscriptionRequest(DefaultPlcSubscriptionRequest request, int tpduId) {
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfTags());
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfTags());
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 2, 1, 0, null, null, null);
        parameterItems.add(parameter);
        PlcSubscriptionTag plctag = (PlcSubscriptionTag)request.getTags().get(0);
        PlcTag tag = ((DefaultPlcSubscriptionTag)plctag).getTag();
        S7SubscriptionTag s7tag = (S7SubscriptionTag)tag;
        ArrayList<CycServiceItemType> cycItems = new ArrayList<CycServiceItemType>();
        ArrayList<SubItem> subItems = new ArrayList<SubItem>();
        S7Tag[] s7TagArray = s7tag.getS7Tags();
        int n = s7TagArray.length;
        int n2 = 0;
        while (n2 < n) {
            S7Tag userTag = s7TagArray[n2];
            subItems.add(new SubItem((short)userTag.getNumberOfElements(), userTag.getBlockNumber(), userTag.getByteOffset()));
            ++n2;
        }
        int initPos = 0;
        int endPos = subItems.size() < 50 ? subItems.size() : 49;
        int j = 0;
        int lengthInBytes = 4;
        do {
            List<SubItem> arraySubItems = subItems.subList(initPos, endPos);
            cycItems.add(j, new CycServiceItemDbReadType((short)(arraySubItems.size() * 5 + 2), 176, (short)arraySubItems.size(), arraySubItems));
            lengthInBytes += 4 + arraySubItems.size() * 5;
            initPos = endPos + 1;
            endPos = Math.min(initPos + 49, subItems.size());
        } while (++j < cycItems.size());
        S7PayloadUserDataItemCyclicServicesSubscribeRequest payload = new S7PayloadUserDataItemCyclicServicesSubscribeRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, lengthInBytes, cycItems.size(), s7tag.getTimeBase(), s7tag.getMultiplier(), cycItems);
        payloadItems.add(payload);
        return new S7MessageUserData(tpduId, new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems));
    }

    private void encodeCycledUnSubscriptionRequest(DefaultPlcUnsubscriptionRequest request, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItems) {
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 2, 4, 0, null, null, null);
        parameterItems.clear();
        parameterItems.add(parameter);
        List handles = request.getSubscriptionHandles();
        payloadItems.clear();
        handles.forEach(h -> {
            S7PayloadUserDataItemCyclicServicesUnsubscribeRequest payload = new S7PayloadUserDataItemCyclicServicesUnsubscribeRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 2, 1, Short.parseShort(((S7PlcSubscriptionHandle)((Object)h)).getEventId()));
            payloadItems.add(payload);
        });
    }

    private CompletableFuture<S7Message> performClkRequest(DefaultPlcReadRequest request) {
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfTags());
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfTags());
        S7ClkTag tag = (S7ClkTag)request.getTags().get(0);
        int subFunction = tag.getAddressString().equals("CLK") ? 1 : 3;
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 7, (short)subFunction, 0, null, null, null);
        parameterItems.add(parameter);
        S7PayloadUserDataItemClkRequest payload = new S7PayloadUserDataItemClkRequest(DataTransportErrorCode.NOT_FOUND, DataTransportSize.NULL, 0);
        payloadItems.add(payload);
        return this.sendInternal(new S7MessageUserData(this.getTpduId(), new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems)));
    }

    private CompletableFuture<S7Message> performClkSetRequest(DefaultPlcWriteRequest request) {
        ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfTags());
        ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfTags());
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 7, 4, 0, null, null, null);
        parameterItems.add(parameter);
        S7ClkTag tag = (S7ClkTag)request.getTags().get(0);
        S7PayloadUserDataItemClkSetRequest payload = new S7PayloadUserDataItemClkSetRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 10, tag.getDateAndTime());
        payloadItems.add(payload);
        return this.sendInternal(new S7MessageUserData(this.getTpduId(), new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems)));
    }

    private CompletableFuture<S7Message> performVarLengthStringReadRequest(DefaultPlcReadRequest request) {
        CompletableFuture<S7Message> future = new CompletableFuture<S7Message>();
        int numVarLengthStrings = 0;
        LinkedHashMap<String, Object> updatedRequestItems = new LinkedHashMap<String, Object>(request.getNumberOfTags());
        for (String tagName : request.getTagNames()) {
            PlcTagItem plcTagItem = request.getTagItem(tagName);
            if (plcTagItem.getTag() instanceof S7StringVarLengthTag) {
                S7Tag s7Tag = (S7Tag)plcTagItem.getTag();
                TransportSize dataType = s7Tag.getDataType();
                if (dataType == TransportSize.STRING) {
                    updatedRequestItems.put(tagName, new DefaultPlcTagItem((PlcTag)new S7Tag(TransportSize.BYTE, s7Tag.getMemoryArea(), s7Tag.getBlockNumber(), s7Tag.getByteOffset(), s7Tag.getBitOffset(), 2)));
                    ++numVarLengthStrings;
                    continue;
                }
                if (dataType != TransportSize.WSTRING) continue;
                updatedRequestItems.put(tagName, new DefaultPlcTagItem((PlcTag)new S7Tag(TransportSize.BYTE, s7Tag.getMemoryArea(), s7Tag.getBlockNumber(), s7Tag.getByteOffset(), s7Tag.getBitOffset(), 4)));
                ++numVarLengthStrings;
                continue;
            }
            updatedRequestItems.put(tagName, plcTagItem);
        }
        CompletableFuture<S7Message> s7MessageCompletableFuture = this.performOrdinaryReadRequest(new DefaultPlcReadRequest(request.getReader(), updatedRequestItems));
        int finalNumVarLengthStrings = numVarLengthStrings;
        s7MessageCompletableFuture.whenComplete((s7Message, throwable1) -> {
            if (throwable1 != null) {
                future.completeExceptionally((Throwable)throwable1);
                return;
            }
            LinkedHashMap<String, DefaultPlcTagItem> varLengthStringTags = new LinkedHashMap<String, DefaultPlcTagItem>(finalNumVarLengthStrings);
            int curItem = 0;
            for (String tagName : request.getTagNames()) {
                S7VarPayloadDataItem s7VarPayloadDataItem;
                S7Tag s7tag = (S7Tag)request.getTag(tagName);
                if (s7tag instanceof S7StringVarLengthTag && (s7VarPayloadDataItem = ((S7PayloadReadVarResponse)s7Message.getPayload()).getItems().get(curItem)).getReturnCode() == DataTransportErrorCode.OK) {
                    ReadBufferByteBased rb = new ReadBufferByteBased(s7VarPayloadDataItem.getData());
                    try {
                        if (s7tag.getDataType() == TransportSize.STRING) {
                            rb.readShort(8, new WithReaderArgs[0]);
                            short stringLength = rb.readShort(8, new WithReaderArgs[0]);
                            varLengthStringTags.put(tagName, new DefaultPlcTagItem((PlcTag)new S7StringFixedLengthTag(TransportSize.STRING, s7tag.getMemoryArea(), s7tag.getBlockNumber(), s7tag.getByteOffset(), s7tag.getBitOffset(), 1, stringLength)));
                        } else if (s7tag.getDataType() == TransportSize.WSTRING) {
                            rb.readInt(16, new WithReaderArgs[0]);
                            int stringLength = rb.readInt(16, new WithReaderArgs[0]);
                            varLengthStringTags.put(tagName, new DefaultPlcTagItem((PlcTag)new S7StringFixedLengthTag(TransportSize.WSTRING, s7tag.getMemoryArea(), s7tag.getBlockNumber(), s7tag.getByteOffset(), s7tag.getBitOffset(), 1, stringLength)));
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Error parsing string size for tag {}", (Object)tagName, (Object)e);
                    }
                }
                ++curItem;
            }
            CompletableFuture<S7Message> readStringsCompletableFuture = this.performOrdinaryReadRequest(new DefaultPlcReadRequest(request.getReader(), varLengthStringTags));
            readStringsCompletableFuture.whenComplete((s7StringMessage, throwable2) -> {
                int curInitialItem = 0;
                int curVarLengthStringItem = 0;
                ArrayList<S7VarPayloadDataItem> varLengthStringItems = new ArrayList<S7VarPayloadDataItem>(request.getNumberOfTags());
                for (String tagName : request.getTagNames()) {
                    S7Tag s7tag = (S7Tag)request.getTag(tagName);
                    S7VarPayloadDataItem curResultItem = ((S7PayloadReadVarResponse)s7Message.getPayload()).getItems().get(curInitialItem);
                    if (s7tag instanceof S7StringVarLengthTag && curResultItem.getReturnCode() == DataTransportErrorCode.OK) {
                        curResultItem = ((S7PayloadReadVarResponse)s7StringMessage.getPayload()).getItems().get(curVarLengthStringItem);
                        ++curVarLengthStringItem;
                    }
                    varLengthStringItems.add(curResultItem);
                    ++curInitialItem;
                }
                future.complete(new S7MessageResponse(s7Message.getTpduReference(), s7Message.getParameter(), new S7PayloadReadVarResponse(varLengthStringItems), 0, 0));
            });
        });
        return future;
    }

    private CompletableFuture<S7Message> performOrdinaryReadRequest(DefaultPlcReadRequest request) {
        ArrayList<S7VarRequestParameterItem> requestItems = new ArrayList<S7VarRequestParameterItem>(request.getNumberOfTags());
        for (PlcTag tag : request.getTags()) {
            requestItems.add(new S7VarRequestParameterItemAddress(this.encodeS7Address(tag)));
        }
        S7MessageRequest requestMessage = new S7MessageRequest(this.getTpduId(), new S7ParameterReadVarRequest(requestItems), null);
        return this.sendInternal(requestMessage);
    }

    private CompletableFuture<S7Message> performVarLengthStringWriteRequest(DefaultPlcWriteRequest request) {
        CompletableFuture<S7Message> future = new CompletableFuture<S7Message>();
        CompletableFuture<Map<S7StringVarLengthTag, StringSizes>> stringSizesFuture = this.getStringSizes((PlcTagRequest)request);
        stringSizesFuture.whenComplete((s7StringVarLengthTagStringSizesMap, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)new PlcProtocolException("Error resolving string sizes", throwable));
            } else {
                LinkedHashMap<String, DefaultPlcTagValueItem> updatedRequestItems = new LinkedHashMap<String, DefaultPlcTagValueItem>(request.getNumberOfTags());
                for (String tagName : request.getTagNames()) {
                    PlcTag tag = request.getTag(tagName);
                    PlcValue value = request.getPlcValue(tagName);
                    if (tag instanceof S7StringVarLengthTag) {
                        S7StringVarLengthTag varLengthTag = (S7StringVarLengthTag)tag;
                        int stringLength = ((StringSizes)s7StringVarLengthTagStringSizesMap.get(varLengthTag)).getCurLength();
                        S7StringFixedLengthTag newTag = new S7StringFixedLengthTag(varLengthTag.getDataType(), varLengthTag.getMemoryArea(), varLengthTag.getBlockNumber(), varLengthTag.getByteOffset(), varLengthTag.getBitOffset(), varLengthTag.getNumberOfElements(), stringLength);
                        updatedRequestItems.put(tagName, new DefaultPlcTagValueItem((PlcTag)newTag, value));
                        continue;
                    }
                    updatedRequestItems.put(tagName, new DefaultPlcTagValueItem(tag, value));
                }
                CompletableFuture<S7Message> s7MessageCompletableFuture = this.performOrdinaryWriteRequest(new DefaultPlcWriteRequest(request.getWriter(), updatedRequestItems));
                s7MessageCompletableFuture.whenComplete((s7Message, throwable1) -> {
                    if (throwable1 != null) {
                        future.completeExceptionally((Throwable)throwable1);
                    } else {
                        future.complete((S7Message)s7Message);
                    }
                });
            }
        });
        return future;
    }

    private CompletableFuture<S7Message> performOrdinaryWriteRequest(DefaultPlcWriteRequest request) {
        ArrayList<S7VarRequestParameterItem> parameterItems = new ArrayList<S7VarRequestParameterItem>(request.getNumberOfTags());
        ArrayList<S7VarPayloadDataItem> payloadItems = new ArrayList<S7VarPayloadDataItem>(request.getNumberOfTags());
        for (String tagName : request.getTagNames()) {
            S7Tag tag = (S7Tag)request.getTag(tagName);
            PlcValue plcValue = request.getPlcValue(tagName);
            parameterItems.add(new S7VarRequestParameterItemAddress(this.encodeS7Address(tag)));
            payloadItems.add(this.serializePlcValue(tag, plcValue));
        }
        return this.sendInternal(new S7MessageRequest(this.getTpduId(), new S7ParameterWriteVarRequest(parameterItems), new S7PayloadWriteVarRequest(payloadItems)));
    }

    private CompletableFuture<S7Message> sendInternal(S7Message request) {
        CompletableFuture<S7Message> future = new CompletableFuture<S7Message>();
        int tpduId = request.getTpduReference();
        TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, request, true, 0));
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.conversationContext.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).check(p -> p.getPayload() != null).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
                try {
                    transaction.endRequest();
                    future.complete((S7Message)p);
                }
                catch (Exception e) {
                    logger.warn("Error sending 'write' message: '{}'", (Object)e.getMessage(), (Object)e);
                }
            });
        });
        return future;
    }

    protected void decode(ConversationContext<TPKTPacket> context, TPKTPacket msg) throws Exception {
        S7Message s7msg = msg.getPayload().getPayload();
        S7Parameter parameter = s7msg.getParameter();
        S7PayloadUserData payload = (S7PayloadUserData)s7msg.getPayload();
        if (parameter instanceof S7ParameterModeTransition) {
            S7ModeEvent modeEvent = new S7ModeEvent((S7ParameterModeTransition)parameter);
            this.eventQueue.add(modeEvent);
        } else if (parameter instanceof S7ParameterUserData) {
            S7ParameterUserData parameterUD = (S7ParameterUserData)parameter;
            List<S7ParameterUserDataItem> parameterUDItems = parameterUD.getItems();
            for (S7ParameterUserDataItem parameterUDItem : parameterUDItems) {
                S7CyclicEvent cycEvent;
                S7PayloadUserDataItem payloadItem;
                S7ParameterUserDataItemCPUFunctions parameterItem;
                if (!(parameterUDItem instanceof S7ParameterUserDataItemCPUFunctions)) continue;
                S7ParameterUserDataItemCPUFunctions myParameter = (S7ParameterUserDataItemCPUFunctions)parameterUDItem;
                if (myParameter.getCpuFunctionType() == 0 && myParameter.getCpuSubfunction() == 3) {
                    payload.getItems().forEach(item -> {
                        if (item instanceof S7PayloadDiagnosticMessage) {
                            S7PayloadDiagnosticMessage pload = (S7PayloadDiagnosticMessage)item;
                            if (pload.getEventId() >= 40960 & pload.getEventId() <= 49151) {
                                S7UserEvent userEvent = S7UserEvent.of(pload);
                                this.eventQueue.add(userEvent);
                            } else {
                                S7SysEvent sysEvent = S7SysEvent.of(pload);
                                this.eventQueue.add(sysEvent);
                            }
                        }
                    });
                    continue;
                }
                if (myParameter.getCpuFunctionType() == 0 && (myParameter.getCpuSubfunction() == 5 || myParameter.getCpuSubfunction() == 6 || myParameter.getCpuSubfunction() == 12 || myParameter.getCpuSubfunction() == 17 || myParameter.getCpuSubfunction() == 18 || myParameter.getCpuSubfunction() == 19 || myParameter.getCpuSubfunction() == 22)) {
                    payload.getItems().forEach(item -> {
                        S7AlarmEvent alrmEvent = S7AlarmEvent.of(item);
                        this.eventQueue.add(alrmEvent);
                    });
                    continue;
                }
                if (myParameter.getCpuFunctionType() == 0 && myParameter.getCpuSubfunction() == 19) continue;
                if (myParameter.getCpuFunctionGroup() == 2 && myParameter.getCpuFunctionType() == 0 && myParameter.getCpuSubfunction() == 1) {
                    parameterItem = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)parameter).getItems().get(0);
                    payloadItem = (S7PayloadUserDataItemCyclicServicesPush)payload.getItems().get(0);
                    cycEvent = new S7CyclicEvent(this.cycRequests.get(parameterItem.getSequenceNumber()), parameterItem.getSequenceNumber(), (S7PayloadUserDataItemCyclicServicesPush)payloadItem);
                    if (this.cycChangeValueEvents.containsKey(parameterItem.getSequenceNumber())) {
                        S7CyclicEvent lastCycEvent = this.cycChangeValueEvents.get(parameterItem.getSequenceNumber());
                        if (cycEvent.equals(lastCycEvent)) continue;
                        this.cycChangeValueEvents.replace(parameterItem.getSequenceNumber(), cycEvent);
                        this.eventQueue.add(cycEvent);
                        continue;
                    }
                    this.eventQueue.add(cycEvent);
                    continue;
                }
                if (myParameter.getCpuFunctionGroup() == 2 && myParameter.getCpuFunctionType() == 0 && myParameter.getCpuSubfunction() == 5) {
                    parameterItem = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)parameter).getItems().get(0);
                    payloadItem = (S7PayloadUserDataItemCyclicServicesChangeDrivenPush)payload.getItems().get(0);
                    cycEvent = new S7CyclicEvent(null, parameterItem.getSequenceNumber(), (S7PayloadUserDataItemCyclicServicesChangeDrivenPush)payloadItem);
                    this.eventQueue.add(cycEvent);
                    continue;
                }
                if (myParameter.getCpuFunctionType() == 8 && myParameter.getCpuSubfunction() == 1 || myParameter.getCpuFunctionType() != 8) continue;
                myParameter.getCpuSubfunction();
            }
        }
    }

    private void extractControllerTypeAndFireConnected(ConversationContext<TPKTPacket> context, S7PayloadUserData payloadUserData) {
        for (S7PayloadUserDataItem item : payloadUserData.getItems()) {
            if (!(item instanceof S7PayloadUserDataItemCpuFunctionReadSzlResponse)) continue;
            S7PayloadUserDataItemCpuFunctionReadSzlResponse readSzlResponseItem = (S7PayloadUserDataItemCpuFunctionReadSzlResponse)item;
            ByteBuf szlItem = Unpooled.wrappedBuffer((byte[])readSzlResponseItem.getItems());
            String articleNumber = szlItem.toString(2, 20, Charset.defaultCharset());
            this.s7DriverContext.setControllerType(this.decodeControllerType(articleNumber));
            context.fireConnected();
        }
    }

    private TPKTPacket createIdentifyRemoteMessage() {
        S7MessageUserData identifyRemoteMessage = new S7MessageUserData(1, new S7ParameterUserData(Collections.singletonList(new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 1, 0, null, null, null))), new S7PayloadUserData(Collections.singletonList(new S7PayloadUserDataItemCpuFunctionReadSzlRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, new SzlId(SzlModuleTypeClass.CPU, 0, SzlSublist.MODULE_IDENTIFICATION), 0))));
        COTPPacketData cotpPacketData = new COTPPacketData(null, identifyRemoteMessage, true, 2);
        return new TPKTPacket(cotpPacketData);
    }

    private TPKTPacket createS7ConnectionRequest(COTPPacketConnectionResponse cotpPacketConnectionResponse) {
        for (COTPParameter parameter : cotpPacketConnectionResponse.getParameters()) {
            if (parameter instanceof COTPParameterCalledTsap) {
                COTPParameterCalledTsap cotpParameterCalledTsap = (COTPParameterCalledTsap)parameter;
                this.s7DriverContext.setCalledTsapId(cotpParameterCalledTsap.getTsapId());
                continue;
            }
            if (parameter instanceof COTPParameterCallingTsap) {
                COTPParameterCallingTsap cotpParameterCallingTsap = (COTPParameterCallingTsap)parameter;
                if (cotpParameterCallingTsap.getTsapId() == this.s7DriverContext.getCallingTsapId()) continue;
                this.s7DriverContext.setCallingTsapId(cotpParameterCallingTsap.getTsapId());
                logger.warn("Switching calling TSAP id to '{}'", (Object)this.s7DriverContext.getCallingTsapId());
                continue;
            }
            if (parameter instanceof COTPParameterTpduSize) {
                COTPParameterTpduSize cotpParameterTpduSize = (COTPParameterTpduSize)parameter;
                this.s7DriverContext.setCotpTpduSize(cotpParameterTpduSize.getTpduSize());
                continue;
            }
            logger.warn("Got unknown parameter type '{}'", (Object)parameter.getClass().getName());
        }
        S7ParameterSetupCommunication s7ParameterSetupCommunication = new S7ParameterSetupCommunication(this.s7DriverContext.getMaxAmqCaller(), this.s7DriverContext.getMaxAmqCallee(), this.s7DriverContext.getPduSize());
        S7MessageRequest s7Message = new S7MessageRequest(0, s7ParameterSetupCommunication, null);
        COTPPacketData cotpPacketData = new COTPPacketData(null, s7Message, true, 0);
        return new TPKTPacket(cotpPacketData);
    }

    private COTPPacketConnectionRequest createCOTPConnectionRequest(int calledTsapId, int callingTsapId, COTPTpduSize cotpTpduSize) {
        return new COTPPacketConnectionRequest(Arrays.asList(new COTPParameterCallingTsap(callingTsapId), new COTPParameterCalledTsap(calledTsapId), new COTPParameterTpduSize(cotpTpduSize)), null, 0, 15, COTPProtocolClass.CLASS_0);
    }

    private PlcResponse decodeReadResponse(S7Message responseMessage, PlcReadRequest plcReadRequest) throws PlcProtocolException {
        List<Object> payloadItems;
        S7Payload payload;
        S7Message messageResponse;
        short errorCode;
        short errorClass;
        HashMap<String, DefaultPlcResponseItem> values = new HashMap<String, DefaultPlcResponseItem>();
        S7ParameterUserDataItemCPUFunctions parameteritem = null;
        if (responseMessage instanceof S7MessageResponseData) {
            S7MessageResponseData messageResponseData = (S7MessageResponseData)responseMessage;
            errorClass = messageResponseData.getErrorClass();
            errorCode = messageResponseData.getErrorCode();
        } else if (responseMessage instanceof S7MessageResponse) {
            messageResponse = (S7MessageResponse)responseMessage;
            errorClass = ((S7MessageResponse)messageResponse).getErrorClass();
            errorCode = ((S7MessageResponse)messageResponse).getErrorCode();
        } else if (responseMessage instanceof S7MessageUserData) {
            messageResponse = (S7MessageUserData)responseMessage;
            Iterator parameters = (S7ParameterUserData)messageResponse.getParameter();
            parameteritem = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)((Object)parameters)).getItems().get(0);
            errorClass = 0;
            errorCode = parameteritem.getErrorCode().shortValue();
        } else {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String tagName : plcReadRequest.getTagNames()) {
                    DefaultPlcResponseItem result = new DefaultPlcResponseItem(PlcResponseCode.ACCESS_DENIED, (Object)new PlcNull());
                    values.put(tagName, result);
                }
                return new DefaultPlcReadResponse(plcReadRequest, values);
            }
            if (errorClass == 133 && errorCode == 0) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that we sent a too large packet or would be receiving a too large one. Please report this, as this is most probably a bug.");
                for (String tagName : plcReadRequest.getTagNames()) {
                    DefaultPlcResponseItem result = new DefaultPlcResponseItem(PlcResponseCode.ACCESS_DENIED, (Object)new PlcNull());
                    values.put(tagName, result);
                }
                return new DefaultPlcReadResponse(plcReadRequest, values);
            }
            logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://github.com/apache/plc4x/issues and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String tagName : plcReadRequest.getTagNames()) {
                DefaultPlcResponseItem result = new DefaultPlcResponseItem(PlcResponseCode.INTERNAL_ERROR, (Object)new PlcNull());
                values.put(tagName, result);
            }
            return new DefaultPlcReadResponse(plcReadRequest, values);
        }
        if (responseMessage instanceof S7MessageUserData) {
            payload = (S7PayloadUserData)responseMessage.getPayload();
            if (plcReadRequest.getNumberOfTags() != ((S7PayloadUserData)payload).getItems().size()) {
                throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
            }
            payloadItems = ((S7PayloadUserData)payload).getItems();
            PlcResponseCode responseCode = PlcResponseCode.INTERNAL_ERROR;
            PlcList plcValue = null;
            int index = 0;
            for (String tagName : plcReadRequest.getTagNames()) {
                LinkedList<PlcValue> plcValues;
                S7PayloadUserDataItem payloadItem;
                block38: {
                    if (plcReadRequest.getTag(tagName) instanceof S7SzlTag && (responseCode = this.decodeResponseCode((payloadItem = (S7PayloadUserDataItemCpuFunctionReadSzlResponse)payloadItems.get(index)).getReturnCode())) == PlcResponseCode.OK) {
                        try {
                            byte by;
                            byte[] data;
                            plcValues = new LinkedList<PlcValue>();
                            byte[] byArray = data = ((S7PayloadUserDataItemCpuFunctionReadSzlResponse)payloadItem).getItems();
                            int n = data.length;
                            int n2 = 0;
                            while (n2 < n) {
                                by = byArray[n2];
                                plcValues.add((PlcValue)new PlcSINT(by));
                                ++n2;
                            }
                            if (parameteritem.getLastDataUnit() == 1) {
                                by = parameteritem.getSequenceNumber();
                                boolean flag = false;
                                Object handler = null;
                                S7Message msg = null;
                                CompletableFuture<S7MessageUserData> nextFuture = null;
                                short lastDataUnit = 1;
                                while (lastDataUnit == 1) {
                                    if (!flag) {
                                        flag = true;
                                        nextFuture = this.reassembledMessage(by, plcValues);
                                        try {
                                            msg = nextFuture.get();
                                            flag = false;
                                        }
                                        catch (Exception ex) {
                                            logger.error(ex.getMessage());
                                        }
                                    }
                                    if (msg != null) {
                                        S7ParameterUserData nextParameter = (S7ParameterUserData)msg.getParameter();
                                        S7ParameterUserDataItemCPUFunctions nextParameterItem = (S7ParameterUserDataItemCPUFunctions)nextParameter.getItems().get(0);
                                        lastDataUnit = nextParameterItem.getLastDataUnit();
                                        S7PayloadUserData nextPayload = (S7PayloadUserData)msg.getPayload();
                                        S7PayloadUserDataItemCpuFunctionReadSzlResponse nextPayloadItem = (S7PayloadUserDataItemCpuFunctionReadSzlResponse)nextPayload.getItems().get(0);
                                        byte[] byArray2 = nextPayloadItem.getItems();
                                        int n3 = byArray2.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            byte b = byArray2[n4];
                                            plcValues.add((PlcValue)new PlcSINT(b));
                                            ++n4;
                                        }
                                        plcValue = new PlcList(plcValues);
                                        msg = null;
                                        flag = false;
                                        continue;
                                    }
                                    return new DefaultPlcReadResponse(plcReadRequest, null);
                                }
                                break block38;
                            }
                            plcValue = new PlcList(plcValues);
                        }
                        catch (Exception e) {
                            throw new PlcProtocolException("Error decoding PlcValue", (Throwable)e);
                        }
                    }
                }
                if (plcReadRequest.getTag(tagName) instanceof S7AckTag) {
                    payloadItem = (S7PayloadUserDataItemCpuFunctionAlarmAckResponse)payloadItems.get(index);
                    responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
                    List<Short> data = ((S7PayloadUserDataItemCpuFunctionAlarmAckResponse)payloadItem).getMessageObjects();
                    LinkedList<PlcSINT> plcValues2 = new LinkedList<PlcSINT>();
                    for (byte by : data) {
                        plcValues2.add(new PlcSINT(by));
                    }
                    plcValue = new PlcList(plcValues2);
                }
                if (plcReadRequest.getTag(tagName) instanceof S7ClkTag) {
                    DateAndTime dt;
                    if (payloadItems.get(index) instanceof S7PayloadUserDataItemClkResponse) {
                        S7PayloadUserDataItemClkResponse payloadItem2 = (S7PayloadUserDataItemClkResponse)payloadItems.get(index);
                        responseCode = this.decodeResponseCode(payloadItem2.getReturnCode());
                        dt = payloadItem2.getTimeStamp();
                    } else if (payloadItems.get(index) instanceof S7PayloadUserDataItemClkFResponse) {
                        S7PayloadUserDataItemClkFResponse payloadItem2 = (S7PayloadUserDataItemClkFResponse)payloadItems.get(index);
                        responseCode = this.decodeResponseCode(payloadItem2.getReturnCode());
                        dt = payloadItem2.getTimeStamp();
                    } else {
                        throw new PlcRuntimeException("unknown date-time type.");
                    }
                    plcValues = new LinkedList();
                    plcValues.add((PlcValue)PlcDATE_AND_LTIME.of((Object)LocalDateTime.of(dt.getYear() + 2000, dt.getMonth(), (int)dt.getDay(), (int)dt.getHour(), (int)dt.getMinutes(), (int)dt.getSeconds(), dt.getMsec() * 1000000)));
                    plcValue = new PlcList(plcValues);
                }
                DefaultPlcResponseItem result = new DefaultPlcResponseItem(responseCode, plcValue);
                values.put(tagName, result);
                ++index;
            }
            return new DefaultPlcReadResponse(plcReadRequest, values);
        }
        payload = (S7PayloadReadVarResponse)responseMessage.getPayload();
        if (plcReadRequest.getNumberOfTags() != ((S7PayloadReadVarResponse)payload).getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        payloadItems = ((S7PayloadReadVarResponse)payload).getItems();
        int index = 0;
        for (String tagName : plcReadRequest.getTagNames()) {
            S7Tag tag = (S7Tag)plcReadRequest.getTag(tagName);
            S7VarPayloadDataItem payloadItem = (S7VarPayloadDataItem)payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            PlcValue plcValue = null;
            if (responseCode == PlcResponseCode.OK) {
                try {
                    plcValue = this.parsePlcValue(tag, payloadItem.getData());
                }
                catch (Exception e) {
                    throw new PlcProtocolException("Error decoding PlcValue", (Throwable)e);
                }
            }
            DefaultPlcResponseItem result = new DefaultPlcResponseItem(responseCode, plcValue);
            values.put(tagName, result);
            ++index;
        }
        return new DefaultPlcReadResponse(plcReadRequest, values);
    }

    private PlcResponse decodeWriteResponse(S7Message responseMessage, PlcWriteRequest plcWriteRequest) throws PlcProtocolException {
        short errorCode;
        short errorClass;
        HashMap<String, PlcResponseCode> responses = new HashMap<String, PlcResponseCode>();
        if (responseMessage instanceof S7MessageResponseData) {
            S7MessageResponseData messageResponseData = (S7MessageResponseData)responseMessage;
            errorClass = messageResponseData.getErrorClass();
            errorCode = messageResponseData.getErrorCode();
        } else if (responseMessage instanceof S7MessageResponse) {
            S7MessageResponse messageResponse = (S7MessageResponse)responseMessage;
            errorClass = messageResponse.getErrorClass();
            errorCode = messageResponse.getErrorCode();
        } else {
            if (responseMessage instanceof S7MessageUserData) {
                String tagName = (String)plcWriteRequest.getTagNames().toArray()[0];
                responses.put(tagName, PlcResponseCode.OK);
                return new DefaultPlcWriteResponse(plcWriteRequest, responses);
            }
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String tagName : plcWriteRequest.getTagNames()) {
                    responses.put(tagName, PlcResponseCode.ACCESS_DENIED);
                }
                return new DefaultPlcWriteResponse(plcWriteRequest, responses);
            }
            if (errorClass == 133 && errorCode == 0) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that we sent a too large packet or would be receiving a too large one. Please report this, as this is most probably a bug.");
                for (String tagName : plcWriteRequest.getTagNames()) {
                    responses.put(tagName, PlcResponseCode.INTERNAL_ERROR);
                }
                return new DefaultPlcWriteResponse(plcWriteRequest, responses);
            }
            logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String tagName : plcWriteRequest.getTagNames()) {
                responses.put(tagName, PlcResponseCode.INTERNAL_ERROR);
            }
            return new DefaultPlcWriteResponse(plcWriteRequest, responses);
        }
        S7PayloadWriteVarResponse payload = (S7PayloadWriteVarResponse)responseMessage.getPayload();
        if (plcWriteRequest.getNumberOfTags() != payload.getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        List<S7VarPayloadStatusItem> payloadItems = payload.getItems();
        int index = 0;
        for (String tagName : plcWriteRequest.getTagNames()) {
            S7VarPayloadStatusItem payloadItem = payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            responses.put(tagName, responseCode);
            ++index;
        }
        return new DefaultPlcWriteResponse(plcWriteRequest, responses);
    }

    private S7VarPayloadDataItem serializePlcValue(S7Tag tag, PlcValue plcValue) {
        try {
            DataTransportSize transportSize = tag.getDataType().getDataTransportSize();
            int stringLength = tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)tag).getStringLength() : 254;
            ByteBuffer byteBuffer = null;
            if (tag.getDataType() == TransportSize.BYTE && tag.getNumberOfElements() > 1) {
                byteBuffer = ByteBuffer.allocate(tag.getNumberOfElements());
                byteBuffer.put(plcValue.getRaw());
            } else if (tag.getDataType() == TransportSize.BOOL && tag.getNumberOfElements() > 1) {
                if (!(plcValue instanceof PlcList)) {
                    throw new PlcRuntimeException(String.format("Expected a PlcList with %d PlcBOOL elements", tag.getNumberOfElements()));
                }
                PlcList plcList = (PlcList)plcValue;
                int numBytes = (tag.getNumberOfElements() + 7) / 8;
                byteBuffer = ByteBuffer.allocate(numBytes);
                int i = 0;
                while (i < tag.getNumberOfElements()) {
                    if (!(plcList.getIndex(i) instanceof PlcBOOL)) {
                        throw new PlcRuntimeException(String.format("Expected a PlcList with %d PlcBOOL elements", tag.getNumberOfElements()));
                    }
                    PlcBOOL plcBOOL = (PlcBOOL)plcList.getIndex(i);
                    if (plcBOOL.getBoolean()) {
                        int curByte = i / 8;
                        int curBit = i % 8;
                        byteBuffer.put(curByte, (byte)(1 << curBit | byteBuffer.get(curByte)));
                    }
                    ++i;
                }
                transportSize = DataTransportSize.BYTE_WORD_DWORD;
            } else {
                int i = 0;
                while (i < tag.getNumberOfElements()) {
                    int lengthInBits = DataItem.getLengthInBits(plcValue.getIndex(i), tag.getDataType().getDataProtocolId(), this.s7DriverContext.getControllerType(), stringLength);
                    if (tag.getDataType() == TransportSize.STRING) {
                        lengthInBits = Math.min(lengthInBits, stringLength * 8 + 16);
                    } else if (tag.getDataType() == TransportSize.WSTRING) {
                        lengthInBits = Math.min(lengthInBits, stringLength * 16 + 32);
                    } else if (tag.getDataType() == TransportSize.S5TIME) {
                        lengthInBits *= 8;
                    }
                    WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil((float)lengthInBits / 8.0f));
                    DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue.getIndex(i), tag.getDataType().getDataProtocolId(), this.s7DriverContext.getControllerType(), stringLength);
                    if (byteBuffer == null) {
                        byteBuffer = ByteBuffer.allocate(writeBuffer.getBytes().length * tag.getNumberOfElements());
                    }
                    byteBuffer.put(writeBuffer.getBytes());
                    ++i;
                }
            }
            if (byteBuffer != null) {
                byte[] data = byteBuffer.array();
                return new S7VarPayloadDataItem(DataTransportErrorCode.OK, transportSize, data);
            }
        }
        catch (SerializationException e) {
            logger.warn("Error serializing tag item of type: '{}'", (Object)tag.getDataType().name(), (Object)e);
        }
        return null;
    }

    private PlcValue parsePlcValue(S7Tag tag, byte[] data) {
        ReadBufferByteBased readBuffer = new ReadBufferByteBased(data);
        try {
            int stringLength;
            int n = stringLength = tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)tag).getStringLength() : 254;
            if (tag.getNumberOfElements() == 1) {
                return DataItem.staticParse((ReadBuffer)readBuffer, tag.getDataType().getDataProtocolId(), this.s7DriverContext.getControllerType(), stringLength);
            }
            if (tag.getDataType() == TransportSize.BYTE) {
                return new PlcRawByteArray(data);
            }
            if (tag.getDataType() == TransportSize.BOOL) {
                Object[] resultItems = (PlcValue[])IntStream.range(0, tag.getNumberOfElements()).mapToObj(i -> {
                    int bitOffset = i;
                    int byteOffset = bitOffset / 8;
                    boolean bitValue = (data[byteOffset] >> (bitOffset %= 8) & 1) != 0;
                    return PlcBOOL.of((Object)bitValue);
                }).toArray(PlcValue[]::new);
                return DefaultPlcValueHandler.of((PlcTag)tag, (Object[])resultItems);
            }
            Object[] resultItems = (PlcValue[])IntStream.range(0, tag.getNumberOfElements()).mapToObj(arg_0 -> this.lambda$52((ReadBuffer)readBuffer, tag, stringLength, arg_0)).toArray(PlcValue[]::new);
            return DefaultPlcValueHandler.of((PlcTag)tag, (Object[])resultItems);
        }
        catch (ParseException e) {
            logger.warn("Error parsing tag item of type: '{}'", (Object)tag.getDataType().name(), (Object)e);
            return null;
        }
    }

    private PlcResponseCode decodeResponseCode(DataTransportErrorCode dataTransportErrorCode) {
        if (dataTransportErrorCode == null) {
            return PlcResponseCode.INTERNAL_ERROR;
        }
        switch (dataTransportErrorCode) {
            case OK: {
                return PlcResponseCode.OK;
            }
            case INVALID_ADDRESS: 
            case NOT_FOUND: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case DATA_TYPE_NOT_SUPPORTED: {
                return PlcResponseCode.INVALID_DATATYPE;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private ControllerType decodeControllerType(String articleNumber) {
        String model;
        if (!articleNumber.startsWith("6ES7 ")) {
            return ControllerType.ANY;
        }
        switch (model = articleNumber.substring(articleNumber.indexOf(32) + 1, articleNumber.indexOf(32) + 2)) {
            case "2": {
                return ControllerType.S7_1200;
            }
            case "5": {
                return ControllerType.S7_1500;
            }
            case "3": {
                return ControllerType.S7_300;
            }
            case "4": {
                return ControllerType.S7_400;
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Looking up unknown article number {}", (Object)articleNumber);
        }
        return ControllerType.ANY;
    }

    protected S7Address encodeS7Address(PlcTag tag) {
        if (!(tag instanceof S7Tag)) {
            throw new PlcRuntimeException("Unsupported address type " + tag.getClass().getName());
        }
        S7Tag s7Tag = (S7Tag)tag;
        TransportSize transportSize = s7Tag.getDataType();
        int numElements = s7Tag.getNumberOfElements();
        if (transportSize == TransportSize.STRING) {
            transportSize = TransportSize.CHAR;
            int stringLength = s7Tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)s7Tag).getStringLength() : 254;
            numElements *= stringLength + 2;
        } else if (transportSize == TransportSize.WSTRING) {
            transportSize = TransportSize.CHAR;
            int stringLength = s7Tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)s7Tag).getStringLength() : 254;
            numElements = numElements * (stringLength + 2) * 2;
        } else if (transportSize == TransportSize.BOOL && s7Tag.getNumberOfElements() > 1) {
            numElements = (s7Tag.getNumberOfElements() + 7) / 8;
            transportSize = TransportSize.BYTE;
        }
        if (transportSize.getCode() == 0) {
            numElements *= transportSize.getSizeInBytes();
            transportSize = TransportSize.BYTE;
        }
        return new S7AddressAny(transportSize, numElements, s7Tag.getBlockNumber(), s7Tag.getMemoryArea(), s7Tag.getByteOffset(), s7Tag.getBitOffset());
    }

    private boolean isConnected() {
        return (Boolean)this.conversationContext.getChannel().attr(S7HMuxImpl.IS_CONNECTED).get();
    }

    private boolean isPrimaryChannel() {
        return this.conversationContext.getChannel().attr(S7HMuxImpl.IS_PRIMARY).get() == null || (Boolean)this.conversationContext.getChannel().attr(S7HMuxImpl.IS_PRIMARY).get() != false;
    }

    private void setChannelFeatures() {
        this.conversationContext.getChannel().attr(S7HMuxImpl.READ_TIME_OUT).set((Object)this.s7DriverContext.getReadTimeout());
        this.conversationContext.getChannel().attr(S7HMuxImpl.IS_PING_ACTIVE).set((Object)this.s7DriverContext.getPing());
        this.conversationContext.getChannel().attr(S7HMuxImpl.PING_TIME).set((Object)this.s7DriverContext.getPingTime());
        this.conversationContext.getChannel().attr(S7HMuxImpl.RETRY_TIME).set((Object)this.s7DriverContext.getRetryTime());
    }

    private boolean isFeatureSupported() {
        return this.s7DriverContext.getControllerType() == ControllerType.S7_300 || this.s7DriverContext.getControllerType() == ControllerType.S7_400;
    }

    public CompletableFuture<S7MessageUserData> reassembledMessage(short sequenceNumber, List<PlcValue> plcValues) {
        CompletableFuture<S7MessageUserData> future = new CompletableFuture<S7MessageUserData>();
        int tpduId = this.getTpduId();
        TPKTPacket request = this.createSzlReassembledRequest(tpduId, sequenceNumber);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        this.conversationContext.sendRequest((Object)request).onTimeout(e -> {
            logger.warn("Timeout during Connection establishing, closing channel...");
            future.complete(null);
        }).expectResponse(TPKTPacket.class, Duration.ofMillis(10000L)).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).only(S7MessageUserData.class).check(p -> p.getPayload() instanceof S7PayloadUserData).handle(future::complete);
        return future;
    }

    private TPKTPacket createSzlReassembledRequest(int tpduId, short sequenceNumber) {
        S7MessageUserData identifyRemoteMessage = new S7MessageUserData(tpduId, new S7ParameterUserData(List.of(new S7ParameterUserDataItemCPUFunctions(18, 4, 4, 1, sequenceNumber, (short)0, (short)0, 0))), new S7PayloadUserData(List.of(new S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest(DataTransportErrorCode.NOT_FOUND, DataTransportSize.NULL, 0))));
        COTPPacketData cotpPacketData = new COTPPacketData(null, identifyRemoteMessage, true, 2);
        return new TPKTPacket(cotpPacketData);
    }

    private CompletableFuture<S7MessageUserData> reassembledAlarmEvents(short sequenceNumber) {
        CompletableFuture<S7MessageUserData> future = new CompletableFuture<S7MessageUserData>();
        int tpduId = this.getTpduId();
        TPKTPacket request = this.createAlarmQueryReassembledRequest(tpduId, sequenceNumber);
        this.conversationContext.sendRequest((Object)request).onTimeout(e -> logger.warn("Timeout during Connection establishing, closing channel...")).expectResponse(TPKTPacket.class, Duration.ofMillis(1000L)).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).only(S7MessageUserData.class).check(p -> p.getPayload() instanceof S7PayloadUserData).handle(future::complete);
        return future;
    }

    private TPKTPacket createAlarmQueryReassembledRequest(int tpduId, short sequenceNumber) {
        S7MessageUserData identifyRemoteMessage = new S7MessageUserData(tpduId, new S7ParameterUserData(List.of(new S7ParameterUserDataItemCPUFunctions(18, 4, 4, 19, sequenceNumber, (short)0, (short)0, 0))), new S7PayloadUserData(List.of(new S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest(DataTransportErrorCode.NOT_FOUND, DataTransportSize.NULL, 0))));
        COTPPacketData cotpPacketData = new COTPPacketData(null, identifyRemoteMessage, true, 2);
        return new TPKTPacket(cotpPacketData);
    }

    private int getTpduId() {
        int tpduId = this.tpduGenerator.getAndIncrement();
        if (this.tpduGenerator.get() == 65535) {
            this.tpduGenerator.set(1);
        }
        return tpduId;
    }

    protected CompletableFuture<Map<S7StringVarLengthTag, StringSizes>> getStringSizes(PlcTagRequest request) {
        CompletableFuture<Map<S7StringVarLengthTag, StringSizes>> future = new CompletableFuture<Map<S7StringVarLengthTag, StringSizes>>();
        List varLengthStringTags = request.getTags().stream().filter(plcTag -> plcTag instanceof S7StringVarLengthTag).map(plcTag -> (S7StringVarLengthTag)plcTag).collect(Collectors.toList());
        ArrayList<S7VarRequestParameterItem> stringFields = new ArrayList<S7VarRequestParameterItem>(varLengthStringTags.size());
        for (S7StringVarLengthTag varLengthStringTag : varLengthStringTags) {
            if (varLengthStringTag.getDataType() == TransportSize.STRING) {
                stringFields.add(new S7VarRequestParameterItemAddress(new S7AddressAny(TransportSize.BYTE, 2, varLengthStringTag.getBlockNumber(), MemoryArea.DATA_BLOCKS, varLengthStringTag.getByteOffset(), varLengthStringTag.getBitOffset())));
                continue;
            }
            if (varLengthStringTag.getDataType() == TransportSize.WSTRING) {
                stringFields.add(new S7VarRequestParameterItemAddress(new S7AddressAny(TransportSize.BYTE, 4, varLengthStringTag.getBlockNumber(), MemoryArea.DATA_BLOCKS, varLengthStringTag.getByteOffset(), varLengthStringTag.getBitOffset())));
                continue;
            }
            throw new PlcInvalidTagException("Only STRING and WSTRING allowed here.");
        }
        S7MessageRequest readRequest = new S7MessageRequest(this.getTpduId(), new S7ParameterReadVarRequest(stringFields), null);
        CompletableFuture<S7Message> resolveSizesRequestFuture = this.sendInternal(readRequest);
        resolveSizesRequestFuture.whenComplete((s7Message, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)new PlcProtocolException("Error resolving string sizes", throwable));
                return;
            }
            HashMap<S7StringVarLengthTag, StringSizes> stringLengths = new HashMap<S7StringVarLengthTag, StringSizes>(varLengthStringTags.size());
            S7PayloadReadVarResponse getLengthsResponse = (S7PayloadReadVarResponse)s7Message.getPayload();
            int curItemIndex = 0;
            for (S7StringVarLengthTag varLengthStringTag : varLengthStringTags) {
                S7VarPayloadDataItem s7VarPayloadDataItem = getLengthsResponse.getItems().get(curItemIndex);
                if (s7VarPayloadDataItem.getReturnCode() != DataTransportErrorCode.OK) continue;
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(s7VarPayloadDataItem.getData());
                try {
                    int actualChars;
                    int maxChars;
                    if (varLengthStringTag.getDataType() == TransportSize.STRING) {
                        maxChars = readBuffer.readUnsignedInt("maxLength", 8, new WithReaderArgs[0]);
                        actualChars = readBuffer.readUnsignedInt("maxLength", 8, new WithReaderArgs[0]);
                        stringLengths.put(varLengthStringTag, new StringSizes(maxChars, actualChars));
                        continue;
                    }
                    if (varLengthStringTag.getDataType() == TransportSize.WSTRING) {
                        maxChars = readBuffer.readUnsignedInt("maxLength", 16, new WithReaderArgs[0]);
                        actualChars = readBuffer.readUnsignedInt("maxLength", 16, new WithReaderArgs[0]);
                        stringLengths.put(varLengthStringTag, new StringSizes(maxChars, actualChars));
                        continue;
                    }
                    throw new PlcInvalidTagException("Only STRING and WSTRING allowed here.");
                }
                catch (ParseException e) {
                    throw new PlcInvalidTagException("Error parsing var-length string actual lengths.");
                }
            }
            future.complete(stringLengths);
        });
        return future;
    }

    private static /* synthetic */ void lambda$35(Map map, PlcResponseItem plcResponseItem, String s) {
        PlcResponseItem plcResponseItem2 = map.put(s, plcResponseItem);
    }

    private /* synthetic */ PlcValue lambda$52(ReadBuffer readBuffer, S7Tag s7Tag, int n, int i) {
        try {
            return DataItem.staticParse(readBuffer, s7Tag.getDataType().getDataProtocolId(), this.s7DriverContext.getControllerType(), n);
        }
        catch (ParseException e) {
            logger.warn("Error parsing tag item of type: '{}' (at position {}})", new Object[]{s7Tag.getDataType().name(), i, e});
            return null;
        }
    }

    public static class StringSizes {
        private final int maxLength;
        private final int curLength;

        public StringSizes(int maxLength, int curLength) {
            this.maxLength = maxLength;
            this.curLength = curLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public int getCurLength() {
            return this.curLength;
        }
    }

    static class TransactionErrorCallback<T, E extends Throwable>
    implements Consumer<TimeoutException>,
    BiConsumer<TPKTPacket, E> {
        private final CompletableFuture<T> future;
        private final RequestTransactionManager.RequestTransaction transaction;

        TransactionErrorCallback(CompletableFuture<T> future, RequestTransactionManager.RequestTransaction transaction) {
            this.future = future;
            this.transaction = transaction;
        }

        @Override
        public void accept(TimeoutException e) {
            try {
                this.transaction.endRequest();
            }
            catch (Exception ex) {
                logger.info(ex.getMessage());
            }
            this.future.completeExceptionally(e);
        }

        @Override
        public void accept(TPKTPacket tpktPacket, E e) {
            try {
                this.transaction.endRequest();
            }
            catch (Exception ex) {
                logger.info(ex.getMessage());
            }
            this.future.completeExceptionally((Throwable)e);
        }
    }
}

