/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.tag;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class S7StringFixedLengthTag
extends S7Tag {
    public static final Pattern DATA_BLOCK_STRING_FIXED_LENGTH_ADDRESS_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}).DB(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>STRING|WSTRING)\\((?<stringLength>\\d{1,3})\\)(\\[(?<numElements>\\d+)])?");
    public static final Pattern DATA_BLOCK_STRING_FIXED_LENGTH_SHORT_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}):(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>STRING|WSTRING)\\((?<stringLength>\\d{1,3})\\)(\\[(?<numElements>\\d+)])?");
    private final int stringLength;

    public S7StringFixedLengthTag(TransportSize dataType, MemoryArea memoryArea, int blockNumber, int byteOffset, byte bitOffset, int numElements, int stringLength) {
        super(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
        this.stringLength = stringLength;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public static boolean matches(String address) {
        return DATA_BLOCK_STRING_FIXED_LENGTH_ADDRESS_PATTERN.matcher(address).matches() || DATA_BLOCK_STRING_FIXED_LENGTH_SHORT_PATTERN.matcher(address).matches();
    }

    @Override
    public String toString() {
        return "S7StringFixedLengthTag{dataType=" + (Object)((Object)this.getDataType()) + ", memoryArea=" + (Object)((Object)this.getMemoryArea()) + ", blockNumber=" + this.getBlockNumber() + ", byteOffset=" + this.getByteOffset() + ", bitOffset=" + this.getBitOffset() + ", numElements=" + this.getNumberOfElements() + ", stringLength=" + this.stringLength + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S7StringFixedLengthTag s7StringFixedLengthTag = (S7StringFixedLengthTag)o;
        return this.getBlockNumber() == s7StringFixedLengthTag.getBlockNumber() && this.getByteOffset() == s7StringFixedLengthTag.getByteOffset() && this.getBitOffset() == s7StringFixedLengthTag.getBitOffset() && this.getNumberOfElements() == s7StringFixedLengthTag.getNumberOfElements() && this.getDataType() == s7StringFixedLengthTag.getDataType() && this.getMemoryArea() == s7StringFixedLengthTag.getMemoryArea() && this.stringLength == s7StringFixedLengthTag.getStringLength();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getDataType(), this.getMemoryArea(), this.getBlockNumber(), this.getByteOffset(), this.getBitOffset(), this.getNumberOfElements(), this.getStringLength()});
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String memoryArea = this.getMemoryArea().name();
        writeBuffer.writeString("memoryArea", memoryArea.getBytes(StandardCharsets.UTF_8).length * 8, memoryArea, new WithWriterArgs[]{WithOption.WithEncoding((String)StandardCharsets.UTF_8.name())});
        writeBuffer.writeUnsignedInt("blockNumber", 16, this.getBlockNumber(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("byteOffset", 16, this.getByteOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("bitOffset", 8, (int)this.getBitOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("numElements", 16, this.getNumberOfElements(), new WithWriterArgs[0]);
        writeBuffer.writeInt("stringLength", 64, this.getStringLength(), new WithWriterArgs[0]);
        String dataType = this.getDataType().name();
        writeBuffer.writeString("dataType", dataType.getBytes(StandardCharsets.UTF_8).length * 8, dataType, new WithWriterArgs[]{WithOption.WithEncoding((String)StandardCharsets.UTF_8.name())});
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }

    public static S7StringFixedLengthTag of(String address) {
        Matcher matcher = DATA_BLOCK_STRING_FIXED_LENGTH_ADDRESS_PATTERN.matcher(address);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group("dataType"));
            int stringLength = Integer.parseInt(matcher.group("stringLength"));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            int blockNumber = S7StringFixedLengthTag.checkDataBlockNumber(Integer.parseInt(matcher.group("blockNumber")));
            Short transferSizeCode = S7StringFixedLengthTag.getSizeCode(matcher.group("transferSizeCode"));
            int byteOffset = S7StringFixedLengthTag.checkByteOffset(Integer.parseInt(matcher.group("byteOffset")));
            byte bitOffset = 0;
            if (matcher.group("bitOffset") != null) {
                bitOffset = Byte.parseByte(matcher.group("bitOffset"));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidTagException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group("numElements") != null) {
                numElements = Integer.parseInt(matcher.group("numElements"));
            }
            if (transferSizeCode != null && dataType.getShortName() != transferSizeCode.shortValue()) {
                throw new PlcInvalidTagException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            return new S7StringFixedLengthTag(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements, stringLength);
        }
        matcher = DATA_BLOCK_STRING_FIXED_LENGTH_SHORT_PATTERN.matcher(address);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group("dataType"));
            int stringLength = Integer.parseInt(matcher.group("stringLength"));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            int blockNumber = S7StringFixedLengthTag.checkDataBlockNumber(Integer.parseInt(matcher.group("blockNumber")));
            int byteOffset = S7StringFixedLengthTag.checkByteOffset(Integer.parseInt(matcher.group("byteOffset")));
            byte bitOffset = 0;
            int numElements = 1;
            if (matcher.group("numElements") != null) {
                numElements = Integer.parseInt(matcher.group("numElements"));
            }
            return new S7StringFixedLengthTag(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements, stringLength);
        }
        return null;
    }
}

