/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7light.readwrite.context;

import java.time.Duration;
import org.apache.plc4x.java.s7.readwrite.COTPTpduSize;
import org.apache.plc4x.java.s7.readwrite.ControllerType;
import org.apache.plc4x.java.s7.readwrite.utils.S7TsapIdEncoder;
import org.apache.plc4x.java.s7light.readwrite.configuration.S7Configuration;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;

public class S7DriverContext
implements DriverContext,
HasConfiguration<S7Configuration> {
    private int callingTsapId;
    private int calledTsapId;
    private COTPTpduSize cotpTpduSize;
    private int pduSize;
    private int maxAmqCaller;
    private int maxAmqCallee;
    private ControllerType controllerType;
    private boolean enableBlockReadOptimizer;
    private int readTimeout;

    public void setConfiguration(S7Configuration configuration) {
        this.callingTsapId = configuration.localTsap > 0 ? configuration.localTsap : (int)S7TsapIdEncoder.encodeS7TsapId(configuration.localDeviceGroup, configuration.localRack, configuration.localSlot);
        this.calledTsapId = configuration.remoteTsap > 0 ? configuration.remoteTsap : (int)S7TsapIdEncoder.encodeS7TsapId(configuration.remoteDeviceGroup, configuration.remoteRack, configuration.remoteSlot);
        this.cotpTpduSize = this.getNearestMatchingTpduSize((short)configuration.getPduSize());
        ControllerType controllerType = this.controllerType = configuration.controllerType == null ? ControllerType.ANY : ControllerType.valueOf(configuration.controllerType);
        if (this.controllerType == ControllerType.LOGO && configuration.pduSize == 1024) {
            configuration.pduSize = 480;
            this.pduSize = 480;
        } else {
            this.pduSize = this.cotpTpduSize.getSizeInBytes() - 16;
        }
        this.maxAmqCaller = configuration.maxAmqCaller;
        this.maxAmqCallee = configuration.maxAmqCallee;
        this.readTimeout = configuration.readTimeout;
        this.enableBlockReadOptimizer = configuration.enableBlockReadOptimizer;
    }

    public int getCallingTsapId() {
        return this.callingTsapId;
    }

    public void setCallingTsapId(int callingTsapId) {
        this.callingTsapId = callingTsapId;
    }

    public int getCalledTsapId() {
        return this.calledTsapId;
    }

    public void setCalledTsapId(int calledTsapId) {
        this.calledTsapId = calledTsapId;
    }

    public COTPTpduSize getCotpTpduSize() {
        return this.cotpTpduSize;
    }

    public void setCotpTpduSize(COTPTpduSize cotpTpduSize) {
        this.cotpTpduSize = cotpTpduSize;
    }

    public int getPduSize() {
        return this.pduSize;
    }

    public void setPduSize(int pduSize) {
        this.pduSize = pduSize;
    }

    public int getMaxAmqCaller() {
        return this.maxAmqCaller;
    }

    public void setMaxAmqCaller(int maxAmqCaller) {
        this.maxAmqCaller = maxAmqCaller;
    }

    public int getMaxAmqCallee() {
        return this.maxAmqCallee;
    }

    public void setMaxAmqCallee(int maxAmqCallee) {
        this.maxAmqCallee = maxAmqCallee;
    }

    public ControllerType getControllerType() {
        return this.controllerType;
    }

    public void setControllerType(ControllerType controllerType) {
        this.controllerType = controllerType;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Duration getReadTimeoutDuration() {
        if (this.readTimeout <= 0) {
            return Duration.ofMillis(10000L);
        }
        return Duration.ofMillis(this.readTimeout);
    }

    public boolean isEnableBlockReadOptimizer() {
        return this.enableBlockReadOptimizer;
    }

    public void setEnableBlockReadOptimizer(boolean enableBlockReadOptimizer) {
        this.enableBlockReadOptimizer = enableBlockReadOptimizer;
    }

    protected COTPTpduSize getNearestMatchingTpduSize(short tpduSizeParameter) {
        COTPTpduSize[] cOTPTpduSizeArray = COTPTpduSize.values();
        int n = cOTPTpduSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            COTPTpduSize value = cOTPTpduSizeArray[n2];
            if (value.getSizeInBytes() >= tpduSizeParameter) {
                return value;
            }
            ++n2;
        }
        return null;
    }
}

