/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7light.readwrite.optimizer;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.DataItem;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.tag.S7ClkTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringFixedLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringVarLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7SzlTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.s7light.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7light.readwrite.optimizer.S7Optimizer;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagItem;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.values.DefaultPlcValueHandler;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7BlockReadOptimizer
extends S7Optimizer {
    private static final Logger logger = LoggerFactory.getLogger(S7BlockReadOptimizer.class);
    public static final int EMPTY_READ_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterReadVarRequest(Collections.emptyList()), null).getLengthInBytes();
    public static final int EMPTY_READ_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterReadVarResponse(0), new S7PayloadReadVarResponse(Collections.emptyList()), 0, 0).getLengthInBytes();
    public static final int S7_ADDRESS_ANY_SIZE = 2 + new S7AddressAny(TransportSize.INT, 1, 1, MemoryArea.DATA_BLOCKS, 1, 0).getLengthInBytes();

    @Override
    protected List<PlcReadRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        S7DriverContext s7DriverContext = (S7DriverContext)driverContext;
        if (!s7DriverContext.isEnableBlockReadOptimizer()) {
            return super.processReadRequest(readRequest, s7DriverContext);
        }
        HashMap<String, Map<PlcTag, String>> sortedTagsPerArea = new HashMap<String, Map<PlcTag, String>>();
        for (String tagName : readRequest.getTagNames()) {
            PlcTag tag = readRequest.getTag(tagName);
            if (tag instanceof S7SzlTag) {
                if (!sortedTagsPerArea.containsKey("SZL")) {
                    sortedTagsPerArea.put("SZL", this.createSortedTagMap());
                }
                ((Map)sortedTagsPerArea.get("SZL")).put(tag, tagName);
                continue;
            }
            if (tag instanceof S7ClkTag) {
                if (!sortedTagsPerArea.containsKey("CLK")) {
                    sortedTagsPerArea.put("CLK", this.createSortedTagMap());
                }
                ((Map)sortedTagsPerArea.get("CLK")).put(tag, tagName);
                continue;
            }
            if (tag instanceof S7Tag) {
                S7Tag s7Tag = (S7Tag)tag;
                MemoryArea memoryArea = s7Tag.getMemoryArea();
                String areaName = memoryArea.getShortName();
                if (memoryArea == MemoryArea.DATA_BLOCKS) {
                    areaName = String.valueOf(areaName) + s7Tag.getBlockNumber();
                } else if (memoryArea == MemoryArea.INSTANCE_DATA_BLOCKS) {
                    areaName = String.valueOf(areaName) + s7Tag.getBlockNumber();
                }
                if (!sortedTagsPerArea.containsKey(areaName)) {
                    sortedTagsPerArea.put(areaName, this.createSortedTagMap());
                }
                ((Map)sortedTagsPerArea.get(areaName)).put(tag, tagName);
                continue;
            }
            System.out.println("Ignored");
        }
        TreeMap<TagNameSize, DefaultPlcTagItem> optimizedTagMap = new TreeMap<TagNameSize, DefaultPlcTagItem>();
        for (Map tagList : sortedTagsPerArea.values()) {
            MemoryArea currentMemoryArea = null;
            int currentDataBlockNumber = -1;
            int currentChunkStartByteOffset = -1;
            int currentChunkEndByteOffset = -1;
            Map<PlcTag, String> currentChunkTags = this.createSortedTagMap();
            for (PlcTag plcTag : tagList.keySet()) {
                int curTagSize;
                if (plcTag instanceof S7SzlTag) {
                    optimizedTagMap.put(new TagNameSize((String)tagList.get(plcTag), 0), new DefaultPlcTagItem(plcTag));
                    continue;
                }
                if (plcTag instanceof S7ClkTag) {
                    optimizedTagMap.put(new TagNameSize((String)tagList.get(plcTag), 0), new DefaultPlcTagItem(plcTag));
                    continue;
                }
                if (plcTag instanceof S7StringVarLengthTag) {
                    optimizedTagMap.put(new TagNameSize((String)tagList.get(plcTag), ((S7StringVarLengthTag)plcTag).getDataType() == TransportSize.STRING ? 2 : 4), new DefaultPlcTagItem(plcTag));
                    continue;
                }
                if (!(plcTag instanceof S7Tag)) continue;
                S7Tag s7Tag = (S7Tag)plcTag;
                int n = curTagSize = s7Tag.getDataType() == TransportSize.BOOL ? (s7Tag.getNumberOfElements() + 7) / 8 : s7Tag.getDataType().getSizeInBytes() * s7Tag.getNumberOfElements();
                if (s7Tag instanceof S7StringFixedLengthTag) {
                    S7StringFixedLengthTag stringFixedLengthTag = (S7StringFixedLengthTag)s7Tag;
                    int bytesPerChar = stringFixedLengthTag.getDataType() == TransportSize.WSTRING ? 2 : 1;
                    curTagSize = (2 * bytesPerChar + stringFixedLengthTag.getStringLength() * bytesPerChar) * s7Tag.getNumberOfElements();
                }
                if (currentMemoryArea == null) {
                    currentMemoryArea = s7Tag.getMemoryArea();
                    currentDataBlockNumber = s7Tag.getBlockNumber();
                    currentChunkStartByteOffset = s7Tag.getByteOffset();
                    currentChunkEndByteOffset = s7Tag.getByteOffset() + curTagSize;
                } else if (currentChunkEndByteOffset + S7_ADDRESS_ANY_SIZE < s7Tag.getByteOffset()) {
                    optimizedTagMap.put(new TagNameSize("__chunk__" + optimizedTagMap.size(), currentChunkEndByteOffset - currentChunkStartByteOffset), new DefaultPlcTagItem((PlcTag)new S7TagChunk(TransportSize.BYTE, currentMemoryArea, currentDataBlockNumber, currentChunkStartByteOffset, 0, currentChunkEndByteOffset - currentChunkStartByteOffset, currentChunkTags, 0, 1, currentChunkEndByteOffset - currentChunkStartByteOffset)));
                    currentChunkStartByteOffset = s7Tag.getByteOffset();
                    currentChunkEndByteOffset = s7Tag.getByteOffset() + curTagSize;
                    currentChunkTags = this.createSortedTagMap();
                } else {
                    currentChunkEndByteOffset = Math.max(currentChunkEndByteOffset, s7Tag.getByteOffset() + curTagSize);
                }
                currentChunkTags.put(s7Tag, (String)tagList.get(s7Tag));
            }
            optimizedTagMap.put(new TagNameSize("__chunk__" + optimizedTagMap.size(), currentChunkEndByteOffset - currentChunkStartByteOffset), new DefaultPlcTagItem((PlcTag)new S7TagChunk(TransportSize.BYTE, currentMemoryArea, currentDataBlockNumber, currentChunkStartByteOffset, 0, currentChunkEndByteOffset - currentChunkStartByteOffset, currentChunkTags, 0, 1, currentChunkEndByteOffset - currentChunkStartByteOffset)));
        }
        int maxRequestSize = ((S7DriverContext)driverContext).getPduSize() - (EMPTY_READ_RESPONSE_SIZE + 4);
        TreeMap<TagNameSize, Object> optimizedTagMap2 = new TreeMap<TagNameSize, Object>();
        for (TagNameSize tagNameSize : optimizedTagMap.keySet()) {
            PlcTagItem curTagItem = (PlcTagItem)optimizedTagMap.get(tagNameSize);
            S7Tag curTag = (S7Tag)curTagItem.getTag();
            if (tagNameSize.getTagSize() > maxRequestSize) {
                String curTagNameBase = tagNameSize.getTagName();
                int curTagFragmentNumber = 0;
                int curTagSize = tagNameSize.getTagSize();
                int curTagOffset = curTag.getByteOffset();
                int curPartIndex = 0;
                int totalPartCount = curTagSize / maxRequestSize + 1;
                while (curTagSize > maxRequestSize) {
                    optimizedTagMap2.put(new TagNameSize(String.valueOf(curTagNameBase) + "." + curTagFragmentNumber, maxRequestSize), new DefaultPlcTagItem((PlcTag)new S7TagChunk(curTag.getDataType(), curTag.getMemoryArea(), curTag.getBlockNumber(), curTagOffset, 0, maxRequestSize, curTag instanceof S7TagChunk ? ((S7TagChunk)curTag).getChunkTags() : Collections.singletonMap(curTag, tagNameSize.getTagName()), curPartIndex, totalPartCount, curTagSize)));
                    curTagOffset += maxRequestSize;
                    curTagSize -= maxRequestSize;
                    ++curTagFragmentNumber;
                    ++curPartIndex;
                }
                optimizedTagMap2.put(new TagNameSize(String.valueOf(curTagNameBase) + "." + curTagFragmentNumber, curTagSize), new DefaultPlcTagItem((PlcTag)new S7TagChunk(curTag.getDataType(), curTag.getMemoryArea(), curTag.getBlockNumber(), curTagOffset, 0, curTagSize, curTag instanceof S7TagChunk ? ((S7TagChunk)curTag).getChunkTags() : Collections.singletonMap(curTag, tagNameSize.getTagName()), curPartIndex, totalPartCount, curTagSize)));
                continue;
            }
            optimizedTagMap2.put(tagNameSize, (PlcTagItem)optimizedTagMap.get(tagNameSize));
        }
        LinkedHashMap<String, PlcTagItem> executableTagMap = new LinkedHashMap<String, PlcTagItem>();
        for (TagNameSize tagNameSize : optimizedTagMap2.keySet()) {
            executableTagMap.put(tagNameSize.getTagName(), (PlcTagItem)optimizedTagMap2.get(tagNameSize));
        }
        return super.processReadRequest((PlcReadRequest)new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), executableTagMap), driverContext);
    }

    @Override
    protected PlcReadResponse processReadResponses(PlcReadRequest readRequest, Map<PlcReadRequest, BaseOptimizer.SubResponse<PlcReadResponse>> readResponses, DriverContext driverContext) {
        S7DriverContext s7DriverContext = (S7DriverContext)driverContext;
        if (!s7DriverContext.isEnableBlockReadOptimizer()) {
            return super.processReadResponses(readRequest, readResponses, driverContext);
        }
        LinkedHashMap<String, DefaultPlcTagItem> tags = new LinkedHashMap<String, DefaultPlcTagItem>();
        for (PlcReadRequest plcReadRequest : readResponses.keySet()) {
            for (String tagName : plcReadRequest.getTagNames()) {
                PlcTag tag = plcReadRequest.getTag(tagName);
                tags.put(tagName, new DefaultPlcTagItem(tag));
            }
        }
        PlcReadResponse rawReadResponse = super.processReadResponses((PlcReadRequest)new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), tags), readResponses, driverContext);
        LinkedHashMap<String, DefaultPlcTagItem> mergedTagItems = new LinkedHashMap<String, DefaultPlcTagItem>();
        LinkedHashMap<String, DefaultPlcResponseItem> mergedValues = new LinkedHashMap<String, DefaultPlcResponseItem>();
        for (String tagName : rawReadResponse.getTagNames()) {
            PlcTag tag = rawReadResponse.getRequest().getTag(tagName);
            if (tag instanceof S7TagChunk && ((S7TagChunk)tag).getTotalPartNumber() > 1) {
                S7TagChunk tagChunk = (S7TagChunk)tag;
                if (tagChunk.getCurPartIndex() != 0) continue;
                String tagBaseName = tagName.substring(0, tagName.indexOf("."));
                byte[] chunkData = new byte[tagChunk.getTotalPartSize()];
                int firstPartOffset = tagChunk.getByteOffset();
                int curPartIndex = 0;
                while (curPartIndex < tagChunk.getTotalPartNumber()) {
                    String curPartTagName = String.valueOf(tagBaseName) + "." + curPartIndex;
                    S7TagChunk curPartTag = (S7TagChunk)rawReadResponse.getRequest().getTag(curPartTagName);
                    PlcResponseCode responseCode = rawReadResponse.getResponseCode(curPartTagName);
                    if (responseCode != PlcResponseCode.OK) {
                        mergedValues.put(tagName, new DefaultPlcResponseItem(responseCode, (Object)new PlcNull()));
                        break;
                    }
                    PlcValue plcValue = rawReadResponse.getPlcValue(curPartTagName);
                    byte[] chunkPartData = plcValue.getRaw();
                    int partDataOffset = curPartTag.getByteOffset() - firstPartOffset;
                    System.arraycopy(chunkPartData, 0, chunkData, partDataOffset, chunkPartData.length);
                    ++curPartIndex;
                }
                mergedTagItems.put(tagBaseName, new DefaultPlcTagItem((PlcTag)new S7TagChunk(tagChunk.getDataType(), tagChunk.getMemoryArea(), tagChunk.getBlockNumber(), firstPartOffset, 0, tagChunk.getTotalPartSize(), tagChunk.getChunkTags(), 0, 1, tagChunk.getTotalPartSize())));
                mergedValues.put(tagBaseName, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)new PlcRawByteArray(chunkData)));
                continue;
            }
            PlcResponseCode responseCode = rawReadResponse.getResponseCode(tagName);
            PlcValue plcValue = rawReadResponse.getPlcValue(tagName);
            mergedTagItems.put(tagName, new DefaultPlcTagItem(tag));
            mergedValues.put(tagName, new DefaultPlcResponseItem(responseCode, (Object)plcValue));
        }
        DefaultPlcReadResponse mergedReadResponse = new DefaultPlcReadResponse((PlcReadRequest)new DefaultPlcReadRequest(((DefaultPlcReadRequest)rawReadResponse.getRequest()).getReader(), mergedTagItems), mergedValues);
        HashMap<String, DefaultPlcResponseItem> values = new HashMap<String, DefaultPlcResponseItem>();
        for (String tagName : mergedReadResponse.getTagNames()) {
            PlcResponseCode responseCode = mergedReadResponse.getResponseCode(tagName);
            PlcValue plcValue = mergedReadResponse.getPlcValue(tagName);
            PlcTag tag = mergedReadResponse.getRequest().getTag(tagName);
            if (!(tag instanceof S7TagChunk)) {
                values.put(tagName, new DefaultPlcResponseItem(responseCode, (Object)plcValue));
                continue;
            }
            ReadBufferByteBased readBuffer = new ReadBufferByteBased(plcValue.getRaw());
            S7TagChunk s7TagChunk = (S7TagChunk)tag;
            int chunkByteOffset = s7TagChunk.getByteOffset();
            for (PlcTag plcTag : s7TagChunk.getChunkTags().keySet()) {
                int curTagDataSize;
                S7Tag s7Tag = (S7Tag)plcTag;
                String curTagName = s7TagChunk.getChunkTags().get(plcTag);
                int curTagStartPosition = s7Tag.getByteOffset() - chunkByteOffset;
                int n = curTagDataSize = s7Tag.getDataType() == TransportSize.BOOL ? (s7Tag.getNumberOfElements() + 7) / 8 : s7Tag.getDataType().getSizeInBytes() * s7Tag.getNumberOfElements();
                if (s7Tag instanceof S7StringFixedLengthTag) {
                    S7StringFixedLengthTag s7StringFixedLengthTag = (S7StringFixedLengthTag)s7Tag;
                    curTagDataSize = s7Tag.getDataType() == TransportSize.WSTRING ? s7StringFixedLengthTag.getStringLength() * 2 : s7StringFixedLengthTag.getStringLength();
                }
                byte[] curTagData = readBuffer.getBytes(curTagStartPosition, curTagStartPosition + curTagDataSize);
                PlcValue tagValue = this.parsePlcValue(s7Tag, curTagData, s7DriverContext);
                values.put(curTagName, new DefaultPlcResponseItem(responseCode, (Object)tagValue));
            }
        }
        return new DefaultPlcReadResponse(readRequest, values);
    }

    protected Map<PlcTag, String> createSortedTagMap() {
        return new TreeMap<PlcTag, String>((tag1, tag2) -> {
            if (tag1 instanceof S7SzlTag) {
                S7SzlTag s7Tag1 = (S7SzlTag)tag1;
                S7SzlTag s7Tag2 = (S7SzlTag)tag2;
                if (s7Tag1.getSzlId() == s7Tag2.getSzlId()) {
                    return s7Tag1.getIndex() - s7Tag2.getIndex();
                }
                return s7Tag1.getSzlId() - s7Tag2.getSzlId();
            }
            if (tag1 instanceof S7ClkTag) {
                return 0;
            }
            if (tag1 instanceof S7Tag) {
                S7Tag s7Tag1 = (S7Tag)tag1;
                S7Tag s7Tag2 = (S7Tag)tag2;
                if (s7Tag1.getByteOffset() == s7Tag2.getByteOffset()) {
                    if (s7Tag1.getBitOffset() == s7Tag2.getBitOffset()) {
                        return s7Tag1.getNumberOfElements() - s7Tag2.getNumberOfElements();
                    }
                    return s7Tag1.getBitOffset() - s7Tag2.getBitOffset();
                }
                return s7Tag1.getByteOffset() - s7Tag2.getByteOffset();
            }
            return 0;
        });
    }

    private PlcValue parsePlcValue(S7Tag tag, byte[] data, S7DriverContext s7DriverContext) {
        ReadBufferByteBased readBuffer = new ReadBufferByteBased(data);
        try {
            int stringLength;
            int n = stringLength = tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)tag).getStringLength() : 254;
            if (tag.getNumberOfElements() == 1) {
                if (tag.getDataType() == TransportSize.BOOL) {
                    boolean bitValue = (data[0] >> tag.getBitOffset() & 1) != 0;
                    return PlcBOOL.of((Object)bitValue);
                }
                return DataItem.staticParse((ReadBuffer)readBuffer, tag.getDataType().getDataProtocolId(), s7DriverContext.getControllerType(), stringLength);
            }
            if (tag.getDataType() == TransportSize.BYTE) {
                return new PlcRawByteArray(data);
            }
            if (tag.getDataType() == TransportSize.BOOL) {
                byte rootBitOffset = tag.getBitOffset();
                Object[] resultItems = (PlcValue[])IntStream.range(0, tag.getNumberOfElements()).mapToObj(i -> {
                    int bitOffset = rootBitOffset + i;
                    int byteOffset = bitOffset / 8;
                    boolean bitValue = (data[byteOffset] >> (bitOffset %= 8) & 1) != 0;
                    return PlcBOOL.of((Object)bitValue);
                }).toArray(PlcValue[]::new);
                return DefaultPlcValueHandler.of((PlcTag)tag, (Object[])resultItems);
            }
            Object[] resultItems = (PlcValue[])IntStream.range(0, tag.getNumberOfElements()).mapToObj(arg_0 -> S7BlockReadOptimizer.lambda$3((ReadBuffer)readBuffer, tag, s7DriverContext, stringLength, arg_0)).toArray(PlcValue[]::new);
            return DefaultPlcValueHandler.of((PlcTag)tag, (Object[])resultItems);
        }
        catch (ParseException e) {
            logger.warn("Error parsing tag item of type: '{}'", (Object)tag.getDataType().name(), (Object)e);
            return null;
        }
    }

    private static /* synthetic */ PlcValue lambda$3(ReadBuffer readBuffer, S7Tag s7Tag, S7DriverContext s7DriverContext, int n, int i) {
        try {
            return DataItem.staticParse(readBuffer, s7Tag.getDataType().getDataProtocolId(), s7DriverContext.getControllerType(), n);
        }
        catch (ParseException e) {
            logger.warn("Error parsing tag item of type: '{}' (at position {}})", new Object[]{s7Tag.getDataType().name(), i, e});
            return null;
        }
    }

    public static class S7TagChunk
    extends S7Tag {
        private final Map<PlcTag, String> chunkTags;
        private final int curPartIndex;
        private final int totalPartNumber;
        private final int totalPartSize;

        public S7TagChunk(TransportSize dataType, MemoryArea memoryArea, int blockNumber, int byteOffset, byte bitOffset, int numElements, Map<PlcTag, String> chunkTags, int curPartIndex, int totalPartNumber, int totalPartSize) {
            super(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
            this.chunkTags = chunkTags;
            this.curPartIndex = curPartIndex;
            this.totalPartNumber = totalPartNumber;
            this.totalPartSize = totalPartSize;
        }

        public Map<PlcTag, String> getChunkTags() {
            return this.chunkTags;
        }

        public int getCurPartIndex() {
            return this.curPartIndex;
        }

        public int getTotalPartNumber() {
            return this.totalPartNumber;
        }

        public int getTotalPartSize() {
            return this.totalPartSize;
        }
    }

    public static class TagNameSize
    implements Comparable<TagNameSize> {
        private final String tagName;
        private final int tagSize;

        public TagNameSize(String tagName, int tagSize) {
            this.tagName = tagName;
            this.tagSize = tagSize;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getTagSize() {
            return this.tagSize;
        }

        @Override
        public int compareTo(TagNameSize o) {
            int sizeComparison = Integer.compare(this.tagSize, o.tagSize);
            if (sizeComparison != 0) {
                return sizeComparison;
            }
            return this.tagName.compareTo(o.tagName);
        }
    }
}

