/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7light.readwrite.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.tag.S7ClkTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringFixedLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringVarLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7SzlTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.s7light.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagValueItem;
import org.apache.plc4x.java.spi.messages.utils.PlcResponseItem;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.apache.plc4x.java.spi.values.PlcValueAdapter;

public class S7Optimizer
extends BaseOptimizer {
    public static final int EMPTY_READ_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterReadVarRequest(Collections.emptyList()), null).getLengthInBytes();
    public static final int EMPTY_READ_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterReadVarResponse(0), new S7PayloadReadVarResponse(Collections.emptyList()), 0, 0).getLengthInBytes();
    public static final int EMPTY_WRITE_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterWriteVarRequest(Collections.emptyList()), new S7PayloadWriteVarRequest(Collections.emptyList())).getLengthInBytes();
    public static final int EMPTY_WRITE_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterWriteVarResponse(0), new S7PayloadWriteVarResponse(Collections.emptyList()), 0, 0).getLengthInBytes();
    public static final int S7_ADDRESS_ANY_SIZE = 2 + new S7AddressAny(TransportSize.INT, 1, 1, MemoryArea.DATA_BLOCKS, 1, 0).getLengthInBytes();

    protected int getNanosDelay() {
        return 500000;
    }

    protected List<PlcReadRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        S7DriverContext s7DriverContext = (S7DriverContext)driverContext;
        LinkedList<PlcReadRequest> processedRequests = new LinkedList<PlcReadRequest>();
        int curRequestSize = EMPTY_READ_REQUEST_SIZE;
        int curResponseSize = EMPTY_READ_RESPONSE_SIZE;
        LinkedHashMap<String, DefaultPlcTagItem> curTagItems = new LinkedHashMap<String, DefaultPlcTagItem>();
        for (String tagName : readRequest.getTagNames()) {
            int readResponseItemSize;
            if (readRequest.getTag(tagName) instanceof S7SzlTag || readRequest.getTag(tagName) instanceof S7ClkTag) {
                curTagItems.put(tagName, new DefaultPlcTagItem(readRequest.getTag(tagName)));
                continue;
            }
            S7Tag tag = (S7Tag)readRequest.getTag(tagName);
            int readRequestItemSize = S7_ADDRESS_ANY_SIZE;
            int readResponseItemElementSize = tag.getDataType().getSizeInBytes();
            if (readRequest.getTag(tagName) instanceof S7StringVarLengthTag) {
                if (((S7StringVarLengthTag)readRequest.getTag(tagName)).getDataType() == TransportSize.STRING) {
                    readResponseItemElementSize = 2;
                } else if (((S7StringVarLengthTag)readRequest.getTag(tagName)).getDataType() == TransportSize.WSTRING) {
                    readResponseItemElementSize = 4;
                }
            }
            if ((readResponseItemSize = 4 + tag.getNumberOfElements() * readResponseItemElementSize) % 2 == 1) {
                ++readResponseItemSize;
            }
            if (curRequestSize + readRequestItemSize <= s7DriverContext.getPduSize() && curResponseSize + readResponseItemSize <= s7DriverContext.getPduSize()) {
                curRequestSize += readRequestItemSize;
                curResponseSize += readResponseItemSize;
                curTagItems.put(tagName, new DefaultPlcTagItem((PlcTag)tag));
                continue;
            }
            if (EMPTY_READ_RESPONSE_SIZE + readResponseItemSize > s7DriverContext.getPduSize()) {
                int maxPayloadSize = s7DriverContext.getPduSize() - (EMPTY_READ_RESPONSE_SIZE + 4);
                int numRequests = (int)Math.ceil((double)tag.getNumberOfElements() * (double)tag.getDataType().getSizeInBytes() / (double)maxPayloadSize);
                int curByteOffset = tag.getByteOffset();
                int numItemsPerRequest = (int)Math.ceil((double)tag.getNumberOfElements() / (double)numRequests);
                int itemsLeft = tag.getNumberOfElements();
                int curRequest = 0;
                while (curRequest < numRequests) {
                    int numCurRequestItems = Math.min(numItemsPerRequest, itemsLeft);
                    S7Tag tagFragment = new S7Tag(tag.getDataType(), tag.getMemoryArea(), tag.getBlockNumber(), curByteOffset, 0, numCurRequestItems);
                    LinkedHashMap<String, DefaultPlcTagItem> tagFragments = new LinkedHashMap<String, DefaultPlcTagItem>();
                    tagFragments.put(tagName, new DefaultPlcTagItem((PlcTag)tagFragment));
                    processedRequests.add((PlcReadRequest)new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), tagFragments));
                    curByteOffset += numItemsPerRequest * tag.getDataType().getSizeInBytes();
                    itemsLeft -= numCurRequestItems;
                    ++curRequest;
                }
                continue;
            }
            processedRequests.add((PlcReadRequest)new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), curTagItems));
            curRequestSize = EMPTY_READ_REQUEST_SIZE + readRequestItemSize;
            curResponseSize = EMPTY_READ_RESPONSE_SIZE + readResponseItemSize;
            curTagItems = new LinkedHashMap();
            if (curRequestSize + readRequestItemSize > s7DriverContext.getPduSize() && curResponseSize + readResponseItemSize > s7DriverContext.getPduSize()) {
                throw new PlcRuntimeException("Tag size exceeds maximum payload for one item.");
            }
            curTagItems.put(tagName, new DefaultPlcTagItem((PlcTag)tag));
        }
        if (!curTagItems.isEmpty()) {
            processedRequests.add((PlcReadRequest)new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), curTagItems));
        }
        return processedRequests;
    }

    protected PlcReadResponse processReadResponses(PlcReadRequest readRequest, Map<PlcReadRequest, BaseOptimizer.SubResponse<PlcReadResponse>> readResponses, DriverContext driverContext) {
        HashMap<String, DefaultPlcResponseItem> tagValues = new HashMap<String, DefaultPlcResponseItem>();
        for (Map.Entry<PlcReadRequest, BaseOptimizer.SubResponse<PlcReadResponse>> requestsEntries : readResponses.entrySet()) {
            PlcReadRequest curRequest = requestsEntries.getKey();
            BaseOptimizer.SubResponse<PlcReadResponse> readResponse = requestsEntries.getValue();
            for (String tagName : curRequest.getTagNames()) {
                if (readResponse.isSuccess()) {
                    PlcReadResponse subReadResponse = (PlcReadResponse)readResponse.getResponse();
                    PlcResponseCode responseCode = subReadResponse.getResponseCode(tagName);
                    PlcValue value = subReadResponse.getAsPlcValue().getValue(tagName);
                    if (readRequest.getTag(tagName) instanceof S7SzlTag) {
                        tagValues.put(tagName, new DefaultPlcResponseItem(responseCode, (Object)value));
                        continue;
                    }
                    S7Tag globalS7Tag = (S7Tag)readRequest.getTag(tagName);
                    S7Tag currentS7Tag = (S7Tag)curRequest.getTag(tagName);
                    if (currentS7Tag.getNumberOfElements() != globalS7Tag.getNumberOfElements()) {
                        if (responseCode == PlcResponseCode.OK) {
                            List<Object> existingItems;
                            int elementOffset;
                            PlcResponseItem existingTagItem;
                            if (globalS7Tag.getDataType() == TransportSize.BYTE) {
                                PlcRawByteArray existingItem;
                                if (tagValues.containsKey(tagName)) {
                                    existingTagItem = (PlcResponseItem)tagValues.get(tagName);
                                    if (existingTagItem.getResponseCode() != PlcResponseCode.OK) continue;
                                    existingItem = (PlcRawByteArray)existingTagItem.getValue();
                                } else {
                                    existingItem = new PlcRawByteArray(new byte[globalS7Tag.getNumberOfElements()]);
                                    tagValues.put(tagName, new DefaultPlcResponseItem(responseCode, (Object)existingItem));
                                }
                                byte[] currentItemByteArray = value.getRaw();
                                elementOffset = (currentS7Tag.getByteOffset() - globalS7Tag.getByteOffset()) / globalS7Tag.getDataType().getSizeInBytes();
                                byte[] existingByteArray = existingItem.getRaw();
                                System.arraycopy(currentItemByteArray, 0, existingByteArray, elementOffset, currentItemByteArray.length);
                                continue;
                            }
                            if (tagValues.containsKey(tagName)) {
                                existingTagItem = (PlcResponseItem)tagValues.get(tagName);
                                if (existingTagItem.getResponseCode() != PlcResponseCode.OK) continue;
                                existingItems = ((PlcValue)existingTagItem.getValue()).getList();
                            } else {
                                existingItems = new ArrayList<PlcValue>(Arrays.asList(new PlcValue[globalS7Tag.getNumberOfElements()]));
                                PlcListModifiable mergedValue = new PlcListModifiable(existingItems);
                                tagValues.put(tagName, new DefaultPlcResponseItem(responseCode, (Object)mergedValue));
                            }
                            List currentItems = value.getList();
                            elementOffset = (currentS7Tag.getByteOffset() - globalS7Tag.getByteOffset()) / globalS7Tag.getDataType().getSizeInBytes();
                            int i = 0;
                            while (i < currentS7Tag.getNumberOfElements()) {
                                existingItems.set(i + elementOffset, (PlcValue)currentItems.get(i));
                                ++i;
                            }
                            continue;
                        }
                        tagValues.put(tagName, new DefaultPlcResponseItem(responseCode, (Object)new PlcNull()));
                        continue;
                    }
                    tagValues.put(tagName, new DefaultPlcResponseItem(responseCode, (Object)value));
                    continue;
                }
                tagValues.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
            }
        }
        return new DefaultPlcReadResponse(readRequest, tagValues);
    }

    protected List<PlcWriteRequest> processWriteRequest(PlcWriteRequest writeRequest, DriverContext driverContext) {
        for (String tagName : writeRequest.getTagNames()) {
            if (!(writeRequest.getTag(tagName) instanceof S7ClkTag)) continue;
            return Collections.singletonList(writeRequest);
        }
        S7DriverContext s7DriverContext = (S7DriverContext)driverContext;
        LinkedList<PlcWriteRequest> processedRequests = new LinkedList<PlcWriteRequest>();
        int curRequestSize = EMPTY_WRITE_REQUEST_SIZE;
        int curResponseSize = EMPTY_WRITE_RESPONSE_SIZE;
        LinkedHashMap<String, DefaultPlcTagValueItem> curTags = new LinkedHashMap<String, DefaultPlcTagValueItem>();
        for (String tagName : writeRequest.getTagNames()) {
            S7Tag tag = (S7Tag)writeRequest.getTag(tagName);
            PlcValue value = writeRequest.getPlcValue(tagName);
            int writeRequestItemSize = S7_ADDRESS_ANY_SIZE + 4;
            if (tag.getDataType() == TransportSize.BOOL) {
                writeRequestItemSize += (int)Math.ceil((double)tag.getNumberOfElements() / 8.0);
            } else if (tag instanceof S7StringFixedLengthTag) {
                S7StringFixedLengthTag stringFixedLengthTag = (S7StringFixedLengthTag)tag;
                writeRequestItemSize = tag.getDataType() == TransportSize.WSTRING ? (writeRequestItemSize += tag.getNumberOfElements() * (stringFixedLengthTag.getStringLength() + 2) * 2) : (writeRequestItemSize += tag.getNumberOfElements() * (stringFixedLengthTag.getStringLength() + 2));
            } else if (tag instanceof S7StringVarLengthTag) {
                PlcValue plcValue = writeRequest.getPlcValue(tagName);
                int length = plcValue.getString().length();
                writeRequestItemSize = tag.getDataType() == TransportSize.WSTRING ? (writeRequestItemSize += tag.getNumberOfElements() * (length + 2) * 2) : (writeRequestItemSize += tag.getNumberOfElements() * (length + 2));
            } else {
                writeRequestItemSize += tag.getNumberOfElements() * tag.getDataType().getSizeInBytes();
            }
            if (writeRequestItemSize % 2 == 1) {
                ++writeRequestItemSize;
            }
            int writeResponseItemSize = 1;
            if (curRequestSize + writeRequestItemSize <= s7DriverContext.getPduSize() && curResponseSize + writeResponseItemSize <= s7DriverContext.getPduSize()) {
                curRequestSize += writeRequestItemSize;
                curResponseSize += writeResponseItemSize;
            } else {
                processedRequests.add((PlcWriteRequest)new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), curTags));
                curRequestSize = EMPTY_WRITE_REQUEST_SIZE + writeRequestItemSize;
                curResponseSize = EMPTY_WRITE_RESPONSE_SIZE + writeResponseItemSize;
                curTags = new LinkedHashMap();
                if (curRequestSize + writeRequestItemSize > s7DriverContext.getPduSize() && curResponseSize + writeResponseItemSize > s7DriverContext.getPduSize()) {
                    throw new PlcRuntimeException("Tag size exceeds maximum payload for one item.");
                }
            }
            curTags.put(tagName, new DefaultPlcTagValueItem((PlcTag)tag, value));
        }
        if (!curTags.isEmpty()) {
            processedRequests.add((PlcWriteRequest)new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), curTags));
        }
        return processedRequests;
    }

    private static class PlcListModifiable
    extends PlcValueAdapter {
        private final List<PlcValue> listItems;

        public PlcListModifiable(List<PlcValue> listItems) {
            this.listItems = listItems;
        }

        public PlcValueType getPlcValueType() {
            return PlcValueType.List;
        }

        public void add(PlcValue value) {
            this.listItems.add(value);
        }

        public Object getObject() {
            return this.getList();
        }

        public boolean isList() {
            return true;
        }

        public int getLength() {
            return this.listItems.size();
        }

        public PlcValue getIndex(int i) {
            return this.listItems.get(i);
        }

        public List<PlcValue> getList() {
            return this.listItems;
        }

        public String toString() {
            return "[" + this.listItems.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
        }

        public void serialize(WriteBuffer writeBuffer) throws SerializationException {
            writeBuffer.pushContext("PlcListModifiable", new WithWriterArgs[0]);
            for (PlcValue listItem : this.listItems) {
                if (!(listItem instanceof Serializable)) {
                    throw new PlcRuntimeException("Error serializing. List item doesn't implement XmlSerializable");
                }
                ((Serializable)listItem).serialize(writeBuffer);
            }
            writeBuffer.popContext("PlcListModifiable", new WithWriterArgs[0]);
        }
    }
}

