/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.readwrite.io;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItemIO.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, String dataType, Integer numberOfValues) throws ParseException {
        if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcBOOL> value = new LinkedList<PlcBOOL>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcBOOL(Boolean.valueOf(readBuffer.readBit("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUINT> value = new LinkedList<PlcUINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUINT(Short.valueOf(readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WORD")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUDINT> value = new LinkedList<PlcUDINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUDINT(Integer.valueOf(readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcULINT> value = new LinkedList<PlcULINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcULINT(Long.valueOf(readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLINT> value = new LinkedList<PlcLINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcLINT(readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0])));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"SINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"SINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readSignedByte("", 8, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"INT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"INT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcINT> value = new LinkedList<PlcINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcINT(Short.valueOf(readBuffer.readShort("", 16, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcDINT> value = new LinkedList<PlcDINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcDINT(Integer.valueOf(readBuffer.readInt("", 32, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLINT> value = new LinkedList<PlcLINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcLINT(Long.valueOf(readBuffer.readLong("", 64, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"USINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"USINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUINT> value = new LinkedList<PlcUINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUINT(Short.valueOf(readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUDINT> value = new LinkedList<PlcUDINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUDINT(Integer.valueOf(readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcULINT> value = new LinkedList<PlcULINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcULINT(Long.valueOf(readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLINT> value = new LinkedList<PlcLINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcLINT(readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0])));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"REAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Float value = ((Supplier<Float>)() -> Float.valueOf((float)StaticHelper.toFloat((ReadBuffer)readBuffer, (String)"", (boolean)true, (int)8, (int)23))).get();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"REAL")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcREAL> value = new LinkedList<PlcREAL>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcREAL(((Supplier<Float>)() -> Float.valueOf((float)StaticHelper.toFloat((ReadBuffer)readBuffer, (String)"", (boolean)true, (int)8, (int)23))).get()));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Double value = ((Supplier<Double>)() -> StaticHelper.toFloat((ReadBuffer)readBuffer, (String)"", (boolean)true, (int)11, (int)52)).get();
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLREAL> value = new LinkedList<PlcLREAL>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcLREAL(((Supplier<Double>)() -> StaticHelper.toFloat((ReadBuffer)readBuffer, (String)"", (boolean)true, (int)11, (int)52)).get()));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUINT> value = new LinkedList<PlcUINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUINT(Short.valueOf(readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcWCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUDINT> value = new LinkedList<PlcUDINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUDINT(Integer.valueOf(readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"STRING")) {
            String value = readBuffer.readString("", 255, "'UTF-8'", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WSTRING")) {
            String value = readBuffer.readString("", 255, "'UTF-8'", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        return null;
    }

    public static WriteBufferByteBased staticSerialize(PlcValue _value, String dataType, Integer numberOfValues) throws ParseException {
        return DataItemIO.staticSerialize(_value, dataType, numberOfValues, false);
    }

    public static WriteBufferByteBased staticSerialize(PlcValue _value, String dataType, Integer numberOfValues, boolean littleEndian) throws ParseException {
        if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(0.125), littleEndian);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 1) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                boolean value = val.getBoolean();
                writeBuffer.writeBit("", value, new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(1.0), littleEndian);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 8) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                short value = val.getShort();
                writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(2.0), littleEndian);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WORD")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 16) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                int value = val.getInt();
                writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(4.0), littleEndian);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 32) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                long value = val.getLong();
                writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(8.0), littleEndian);
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 64) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                BigInteger value = val.getBigInteger();
                writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"SINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(1.0), littleEndian);
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"SINT")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 8) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte value = val.getByte();
                writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"INT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(2.0), littleEndian);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"INT")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 16) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                short value = val.getShort();
                writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(4.0), littleEndian);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DINT")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 32) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                int value = val.getInt();
                writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(8.0), littleEndian);
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LINT")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 64) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                long value = val.getLong();
                writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"USINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(1.0), littleEndian);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"USINT")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 8) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                short value = val.getShort();
                writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(2.0), littleEndian);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UINT")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 16) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                int value = val.getInt();
                writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(4.0), littleEndian);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 32) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                long value = val.getLong();
                writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(8.0), littleEndian);
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 64) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                BigInteger value = val.getBigInteger();
                writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"REAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(4.0), littleEndian);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", value, 8, 23, new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"REAL")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 32) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                float value = val.getFloat();
                writeBuffer.writeFloat("", value, 8, 23, new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(8.0), littleEndian);
            double value = _value.getDouble();
            writeBuffer.writeDouble("", value, 11, 52, new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 64) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                double value = val.getDouble();
                writeBuffer.writeDouble("", value, 11, 52, new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(1.0), littleEndian);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 8) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                short value = val.getShort();
                writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(2.0), littleEndian);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(((float)(numberOfValues * 16) + 0.0f) / 8.0f), littleEndian);
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                int value = val.getInt();
                writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
            }
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"STRING")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(31.875), littleEndian);
            String value = _value.getString();
            writeBuffer.writeString("", 255, "'UTF-8'", value, new WithWriterArgs[0]);
            return writeBuffer;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WSTRING")) {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil(31.875), littleEndian);
            String value = _value.getString();
            writeBuffer.writeString("", 255, "'UTF-8'", value, new WithWriterArgs[0]);
            return writeBuffer;
        }
        return null;
    }
}

