/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.readwrite.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SimulatedDataTypeSizes {
    BOOL(1, 1),
    BYTE(2, 1),
    WORD(3, 2),
    DWORD(4, 4),
    LWORD(5, 8),
    SINT(6, 1),
    INT(7, 2),
    DINT(8, 4),
    LINT(9, 8),
    USINT(10, 1),
    UINT(11, 2),
    UDINT(12, 4),
    ULINT(13, 8),
    REAL(14, 4),
    LREAL(15, 8),
    TIME(16, 8),
    LTIME(17, 8),
    DATE(18, 8),
    LDATE(19, 8),
    TIME_OF_DAY(20, 8),
    LTIME_OF_DAY(21, 8),
    DATE_AND_TIME(22, 8),
    LDATE_AND_TIME(23, 8),
    CHAR(24, 1),
    WCHAR(25, 2),
    STRING(26, 255),
    WSTRING(27, 127);

    private static final Logger logger;
    private static final Map<Short, SimulatedDataTypeSizes> map;
    private short value;
    private short dataTypeSize;

    private SimulatedDataTypeSizes(short value, short dataTypeSize) {
        this.value = value;
        this.dataTypeSize = dataTypeSize;
    }

    public short getValue() {
        return this.value;
    }

    public short getDataTypeSize() {
        return this.dataTypeSize;
    }

    public static SimulatedDataTypeSizes firstEnumForFieldDataTypeSize(short fieldValue) {
        for (SimulatedDataTypeSizes _val : SimulatedDataTypeSizes.values()) {
            if (_val.getDataTypeSize() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<SimulatedDataTypeSizes> enumsForFieldDataTypeSize(short fieldValue) {
        ArrayList<SimulatedDataTypeSizes> _values = new ArrayList<SimulatedDataTypeSizes>();
        for (SimulatedDataTypeSizes _val : SimulatedDataTypeSizes.values()) {
            if (_val.getDataTypeSize() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static SimulatedDataTypeSizes enumForValue(short value) {
        if (!map.containsKey(value)) {
            logger.error("No SimulatedDataTypeSizes for value {}", (Object)value);
        }
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }

    static {
        logger = LoggerFactory.getLogger(SimulatedDataTypeSizes.class);
        map = new HashMap<Short, SimulatedDataTypeSizes>();
        for (SimulatedDataTypeSizes value : SimulatedDataTypeSizes.values()) {
            map.put(value.getValue(), value);
        }
    }
}

