/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.utils;

import java.nio.charset.Charset;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class StaticHelper {
    public static String parsePascalString(ReadBuffer io, String encoding) {
        try {
            short stringLength = io.readUnsignedShort(8);
            String str = io.readString(stringLength * 8, encoding);
            return str;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void serializePascalString(WriteBuffer io, PlcValue value, String encoding) throws ParseException {
        block4: {
            byte[] bytes = value.getString().getBytes(Charset.forName(encoding));
            try {
                if (bytes.length < 256) {
                    io.writeByte((byte)bytes.length);
                    for (byte aByte : bytes) {
                        io.writeByte(aByte);
                    }
                    break block4;
                }
                throw new ParseException("Error writing string, string > 255 bytes");
            }
            catch (ParseException e) {
                throw new ParseException("Error writing string", (Throwable)e);
            }
        }
    }
}

