/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.triggeredscraper;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.scraper.ResultHandler;
import org.apache.plc4x.java.scraper.ScraperTask;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScrapeJobImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperTaskMBean;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.TriggerHandler;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.TriggerHandlerImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggeredScraperTask
implements ScraperTask,
TriggeredScraperTaskMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggeredScraperTask.class);
    private final PlcConnectionManager connectionManager;
    private final String jobName;
    private final String connectionAlias;
    private final String connectionString;
    private final Map<String, String> tags;
    private final long requestTimeoutMs;
    private final ExecutorService executorService;
    private final ResultHandler resultHandler;
    private final TriggerHandler triggerHandler;
    private final AtomicLong requestCounter = new AtomicLong(0L);
    private final AtomicLong successCounter = new AtomicLong(0L);
    private final DescriptiveStatistics latencyStatistics = new DescriptiveStatistics(1000);
    private final DescriptiveStatistics failedStatistics = new DescriptiveStatistics(1000);

    public TriggeredScraperTask(PlcConnectionManager connectionManager, String jobName, String connectionAlias, String connectionString, Map<String, String> tags, long requestTimeoutMs, ExecutorService executorService, ResultHandler resultHandler, TriggeredScrapeJobImpl triggeredScrapeJob, TriggerCollector triggerCollector) throws ScraperException {
        this.connectionManager = connectionManager;
        this.jobName = jobName;
        this.connectionAlias = connectionAlias;
        this.connectionString = connectionString;
        this.tags = tags;
        this.requestTimeoutMs = requestTimeoutMs;
        this.executorService = executorService;
        this.resultHandler = resultHandler;
        this.triggerHandler = new TriggerHandlerImpl(triggeredScrapeJob.getTriggerConfig(), triggeredScrapeJob, this, triggerCollector);
    }

    @Override
    public void run() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Check condition for task of job {} for connection {}", (Object)this.jobName, (Object)this.connectionAlias);
        }
        if (this.triggerHandler.checkTrigger()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trigger for job {} and device {} is met ... scraping desired data", (Object)this.jobName, (Object)this.connectionAlias);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Start new scrape of task of job {} for connection {}", (Object)this.jobName, (Object)this.connectionAlias);
            }
            this.requestCounter.incrementAndGet();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            PlcConnection connection = null;
            try {
                PlcReadResponse plcReadResponse;
                String info = "";
                if (LOGGER.isTraceEnabled()) {
                    info = String.format("acquiring data collecting connection to (%s,%s)", this.connectionAlias, this.jobName);
                    LOGGER.trace("acquiring data collecting connection to ({},{})", (Object)this.connectionAlias, (Object)this.jobName);
                }
                connection = TriggeredScraperImpl.getPlcConnection(this.connectionManager, this.connectionString, this.executorService, this.requestTimeoutMs, info);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Connection to {} established: {}", (Object)this.connectionString, (Object)connection);
                }
                try {
                    PlcReadRequest.Builder readRequestBuilder = connection.readRequestBuilder();
                    for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("Requesting: {} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
                        }
                        readRequestBuilder.addTagAddress(entry.getKey(), entry.getValue());
                    }
                    plcReadResponse = (PlcReadResponse)readRequestBuilder.build().execute().orTimeout(this.requestTimeoutMs, TimeUnit.MILLISECONDS).get();
                }
                catch (ExecutionException e) {
                    LOGGER.warn("Execution Exception while reading PLC Response", (Throwable)e);
                    this.handleException(e);
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception e2) {
                            LOGGER.warn("Error on closing connection", (Throwable)e2);
                        }
                    }
                    return;
                }
                try {
                    LOGGER.debug("Performing statistics");
                    stopWatch.stop();
                    this.latencyStatistics.addValue((double)stopWatch.getNanoTime());
                    this.failedStatistics.addValue(0.0);
                    this.successCounter.incrementAndGet();
                    this.validateResponse(plcReadResponse);
                    CompletableFuture.runAsync(() -> this.resultHandler.handle(this.jobName, this.connectionAlias, TriggeredScraperImpl.convertPlcResponseToMap(plcReadResponse)), this.executorService);
                }
                catch (Exception e) {
                    LOGGER.warn("Exception during scraping of Job {}, Connection-Alias {}: Error-message: {} - for stack-trace change logging to DEBUG", new Object[]{this.jobName, this.connectionAlias, e.getCause().getMessage()});
                    this.handleException(e);
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error on closing connection", (Throwable)e);
                    }
                }
            }
        }
    }

    private void validateResponse(PlcReadResponse response) {
        Map<String, PlcResponseCode> failedTags = response.getTagNames().stream().filter(name -> !PlcResponseCode.OK.equals((Object)response.getResponseCode(name))).collect(Collectors.toMap(Function.identity(), arg_0 -> ((PlcReadResponse)response).getResponseCode(arg_0)));
        if (failedTags.size() > 0) {
            this.handleErrorResponse(failedTags);
        }
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getConnectionAlias() {
        return this.connectionAlias;
    }

    @Override
    public long getRequestCounter() {
        return this.requestCounter.get();
    }

    @Override
    public long getSuccessfullRequestCounter() {
        return this.successCounter.get();
    }

    @Override
    public DescriptiveStatistics getLatencyStatistics() {
        return this.latencyStatistics;
    }

    @Override
    public void handleException(Exception e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Detailed exception occurred at scraping", (Throwable)e);
        }
        this.failedStatistics.addValue(1.0);
    }

    @Override
    public void handleErrorResponse(Map<String, PlcResponseCode> failed) {
        LOGGER.warn("Handling error responses: {}", failed);
    }

    public PlcConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public long getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public String toString() {
        return "TriggeredScraperTask{connectionManager=" + this.connectionManager + ", jobName='" + this.jobName + '\'' + ", connectionAlias='" + this.connectionAlias + '\'' + ", connectionString='" + this.connectionString + '\'' + ", requestTimeoutMs=" + this.requestTimeoutMs + ", executorService=" + this.executorService + ", resultHandler=" + this.resultHandler + ", triggerHandler=" + this.triggerHandler + '}';
    }

    @Override
    public long getScrapesTotal() {
        return this.requestCounter.get();
    }

    @Override
    public long getScrapesSuccess() {
        return this.successCounter.get();
    }

    @Override
    public double getPercentageFailed() {
        return 100.0 - (double)this.getScrapesSuccess() / (double)this.getScrapesTotal() * 100.0;
    }

    @Override
    public String[] getPercentiles() {
        String[] percentiles = new String[10];
        int i = 1;
        while (i <= 10) {
            percentiles[i - 1] = String.format("%d%%: %s ms", 10 * i, this.latencyStatistics.getPercentile(10.0 * (double)i) * 1.0E-6);
            ++i;
        }
        return percentiles;
    }
}

