/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.fields;

import org.apache.plc4x.java.spi.codegen.FieldCommons;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReaderOptional<T>
implements FieldCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldReaderOptional.class);

    public T readOptionalField(String logicalName, DataReader<T> dataReader, boolean condition, WithReaderArgs ... readerArgs) throws ParseException {
        LOGGER.debug("reading field {}", (Object)logicalName);
        if (!condition) {
            LOGGER.debug("Condition doesn't match for field {}", (Object)logicalName);
            return null;
        }
        int curPos = dataReader.getPos();
        try {
            Object field = this.switchParseByteOrderIfNecessary(() -> dataReader.read(logicalName, readerArgs), dataReader, this.extractByteOrder(readerArgs).orElse(null));
            LOGGER.debug("done reading field {}. Value: {}", (Object)logicalName, field);
            return (T)field;
        }
        catch (ParseAssertException e) {
            LOGGER.debug("Assertion doesn't match for field {}. Resetting read position to {}", new Object[]{logicalName, curPos, e});
            dataReader.setPos(curPos);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.debug("Not enough bytes for {}. Resetting read position to {}", new Object[]{logicalName, curPos, e});
            dataReader.setPos(curPos);
            return null;
        }
    }
}

