/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.io;

import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.spi.codegen.io.ComplexTypeSupplier;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplex;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;

public class DataReaderComplexDefault<T>
implements DataReaderComplex<T> {
    private final ComplexTypeSupplier<T> complexSupplier;
    private final ReadBuffer readBuffer;

    public DataReaderComplexDefault(ComplexTypeSupplier<T> complexSupplier, ReadBuffer readBuffer) {
        this.complexSupplier = complexSupplier;
        this.readBuffer = readBuffer;
    }

    @Override
    public int getPos() {
        return this.readBuffer.getPos();
    }

    @Override
    public void setPos(int position) {
        this.readBuffer.reset(position);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.readBuffer.getByteOrder();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.readBuffer.setByteOrder(byteOrder);
    }

    @Override
    public T read(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        return this.read(logicalName, this.complexSupplier, readerArgs);
    }

    @Override
    public T read(String logicalName, ComplexTypeSupplier<T> complexSupplier, WithReaderArgs ... readerArgs) throws ParseException {
        boolean hasLogicalName = StringUtils.isNotBlank((CharSequence)logicalName);
        if (hasLogicalName) {
            this.readBuffer.pullContext(logicalName, readerArgs);
        }
        T t = complexSupplier.get();
        if (hasLogicalName) {
            this.readBuffer.closeContext(logicalName, readerArgs);
        }
        return t;
    }

    @Override
    public void pullContext(String logicalName, WithReaderArgs ... readerArgs) {
        this.readBuffer.pullContext(logicalName, readerArgs);
    }

    @Override
    public void closeContext(String logicalName, WithReaderArgs ... readerArgs) {
        this.readBuffer.closeContext(logicalName, readerArgs);
    }
}

