/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedOperationException;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.metadata.PlcConnectionMetadata;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;

public abstract class AbstractPlcConnection
implements PlcConnection,
PlcConnectionMetadata,
PlcReader,
PlcWriter,
PlcSubscriber,
PlcBrowser {
    private boolean canRead = false;
    private boolean canWrite = false;
    private boolean canSubscribe = false;
    private boolean canBrowse = false;
    private PlcFieldHandler fieldHandler;
    private PlcValueHandler valueHandler;
    private Plc4xProtocolBase<?> protocol;
    private BaseOptimizer optimizer;
    private PlcAuthentication authentication;

    @Deprecated
    protected AbstractPlcConnection() {
    }

    protected AbstractPlcConnection(boolean canRead, boolean canWrite, boolean canSubscribe, boolean canBrowse, PlcFieldHandler fieldHandler, PlcValueHandler valueHandler, BaseOptimizer optimizer, PlcAuthentication authentication) {
        this.canRead = canRead;
        this.canWrite = canWrite;
        this.canSubscribe = canSubscribe;
        this.canBrowse = canBrowse;
        this.fieldHandler = fieldHandler;
        this.valueHandler = valueHandler;
        this.optimizer = optimizer;
        this.authentication = authentication;
    }

    public void setProtocol(Plc4xProtocolBase<?> protocol) {
        this.protocol = protocol;
    }

    public PlcConnectionMetadata getMetadata() {
        return this;
    }

    public CompletableFuture<Void> ping() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.completeExceptionally((Throwable)new PlcUnsupportedOperationException("The connection does not support pinging"));
        return future;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean canSubscribe() {
        return this.canSubscribe;
    }

    public boolean canBrowse() {
        return this.canBrowse;
    }

    public PlcFieldHandler getPlcFieldHandler() {
        return this.fieldHandler;
    }

    public PlcValueHandler getPlcValueHandler() {
        return this.valueHandler;
    }

    protected PlcAuthentication getAuthentication() {
        return this.authentication;
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        if (!this.canRead()) {
            throw new PlcUnsupportedOperationException("The connection does not support reading");
        }
        return new DefaultPlcReadRequest.Builder(this, this.getPlcFieldHandler());
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        if (!this.canWrite()) {
            throw new PlcUnsupportedOperationException("The connection does not support writing");
        }
        return new DefaultPlcWriteRequest.Builder(this, this.getPlcFieldHandler(), this.getPlcValueHandler());
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        if (!this.canSubscribe()) {
            throw new PlcUnsupportedOperationException("The connection does not support subscription");
        }
        return new DefaultPlcSubscriptionRequest.Builder(this, this.getPlcFieldHandler());
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        if (!this.canSubscribe) {
            throw new PlcUnsupportedOperationException("The connection does not support subscription");
        }
        return new DefaultPlcUnsubscriptionRequest.Builder(this);
    }

    public PlcBrowseRequest.Builder browseRequestBuilder() {
        if (!this.canBrowse) {
            throw new PlcUnsupportedOperationException("The connection does not support browsing");
        }
        return new DefaultPlcBrowseRequest.Builder(this);
    }

    @Override
    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedRead(readRequest, this.protocol);
        }
        return this.protocol.read(readRequest);
    }

    @Override
    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedWrite(writeRequest, this.protocol);
        }
        return this.protocol.write(writeRequest);
    }

    @Override
    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedSubscribe(subscriptionRequest, this.protocol);
        }
        return this.protocol.subscribe(subscriptionRequest);
    }

    @Override
    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optmizedUnsubscribe(unsubscriptionRequest, this.protocol);
        }
        return this.protocol.unsubscribe(unsubscriptionRequest);
    }

    @Override
    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        throw new NotImplementedException("");
    }

    @Override
    public void unregister(PlcConsumerRegistration registration) {
        throw new NotImplementedException("");
    }

    @Override
    public CompletableFuture<PlcBrowseResponse> browse(PlcBrowseRequest browseRequest) {
        return this.protocol.browse(browseRequest);
    }
}

