/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcBrowseItem;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcBrowseItem
implements PlcBrowseItem,
Serializable {
    private final String address;
    private final String name;
    private final PlcValueType dataType;
    private final boolean readable;
    private final boolean writable;
    private final boolean subscribable;
    private final List<PlcBrowseItem> children;
    private final Map<String, PlcValue> options;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcBrowseItem(@JsonProperty(value="address") String address, @JsonProperty(value="name") String name, @JsonProperty(value="dataType") PlcValueType dataType, @JsonProperty(value="readable") boolean readable, @JsonProperty(value="writable") boolean writable, @JsonProperty(value="subscribable") boolean subscribable, @JsonProperty(value="children") List<PlcBrowseItem> children, @JsonProperty(value="options") Map<String, PlcValue> options) {
        this.address = address;
        this.name = name;
        this.dataType = dataType;
        this.readable = readable;
        this.writable = writable;
        this.subscribable = subscribable;
        this.children = children;
        this.options = options;
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public PlcValueType getPlcValueType() {
        return this.dataType;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isSubscribable() {
        return this.subscribable;
    }

    public List<PlcBrowseItem> getChildren() {
        return this.children;
    }

    public Map<String, PlcValue> getOptions() {
        return this.options;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeString("address", this.address.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.address, new WithWriterArgs[0]);
        writeBuffer.writeString("name", this.name.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.name, new WithWriterArgs[0]);
        if (this.children != null && !this.children.isEmpty()) {
            writeBuffer.pushContext("children", new WithWriterArgs[0]);
            for (PlcBrowseItem plcBrowseItem : this.children) {
                writeBuffer.pushContext("child", new WithWriterArgs[0]);
                ((DefaultPlcBrowseItem)plcBrowseItem).serialize(writeBuffer);
                writeBuffer.popContext("child", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("children", new WithWriterArgs[0]);
        }
        if (this.options != null && !this.options.isEmpty()) {
            writeBuffer.pushContext("options", new WithWriterArgs[0]);
            for (Map.Entry entry : this.options.entrySet()) {
                writeBuffer.pushContext("option", new WithWriterArgs[0]);
                writeBuffer.writeString("name", ((String)entry.getKey()).getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), (String)entry.getKey(), new WithWriterArgs[0]);
                ((DefaultPlcBrowseItem)((Object)entry)).serialize(writeBuffer);
                writeBuffer.popContext("option", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("options", new WithWriterArgs[0]);
        }
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

