/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItem;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcDiscoveryItem
implements PlcDiscoveryItem,
Serializable {
    private final String protocolCode;
    private final String transportCode;
    private final String transportUrl;
    private final Map<String, String> options;
    private final String name;
    private final Map<String, PlcValue> attributes;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcDiscoveryItem(@JsonProperty(value="protocolCode") String protocolCode, @JsonProperty(value="transportCode") String transportCode, @JsonProperty(value="transportUrl") String transportUrl, @JsonProperty(value="options") Map<String, String> options, @JsonProperty(value="name") String name, @JsonProperty(value="options") Map<String, PlcValue> attributes) {
        this.protocolCode = protocolCode;
        this.transportCode = transportCode;
        this.transportUrl = transportUrl;
        this.options = options;
        this.name = name;
        this.attributes = attributes;
    }

    public String getProtocolCode() {
        return this.protocolCode;
    }

    public String getTransportCode() {
        return this.transportCode;
    }

    public String getTransportUrl() {
        return this.transportUrl;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, PlcValue> getAttributes() {
        return this.attributes;
    }

    public String getConnectionUrl() {
        StringBuilder sb = new StringBuilder(String.format("%s:%s://%s", this.protocolCode, this.transportCode, this.transportUrl.toString()));
        if (this.options != null && !this.options.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, String> optionEntry : this.options.entrySet()) {
                if (first) {
                    sb.append("?");
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append(optionEntry.getKey()).append("=").append(optionEntry.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeString("protocolCode", this.protocolCode.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.protocolCode, new WithWriterArgs[0]);
        writeBuffer.writeString("transportCode", this.transportCode.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.transportCode, new WithWriterArgs[0]);
        writeBuffer.writeString("transportUrl", this.transportUrl.toString().getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.transportUrl.toString(), new WithWriterArgs[0]);
        if (this.options != null && !this.options.isEmpty()) {
            writeBuffer.pushContext("options", new WithWriterArgs[0]);
            for (Map.Entry<String, String> optionEntry : this.options.entrySet()) {
                writeBuffer.pushContext("option", new WithWriterArgs[0]);
                writeBuffer.writeString("name", optionEntry.getKey().getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), optionEntry.getKey(), new WithWriterArgs[0]);
                writeBuffer.writeString("value", optionEntry.getValue().getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), optionEntry.getValue(), new WithWriterArgs[0]);
                writeBuffer.popContext("option", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("options", new WithWriterArgs[0]);
        }
        if (this.name != null && !this.name.isEmpty()) {
            writeBuffer.writeString("name", this.name.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.name, new WithWriterArgs[0]);
        }
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

