/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.utils.FieldValueItem;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;

public class SingleFieldOptimizer
extends BaseOptimizer {
    @Override
    protected List<PlcRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        if (readRequest.getNumberOfFields() == 1) {
            return Collections.singletonList(readRequest);
        }
        ArrayList<PlcRequest> subRequests = new ArrayList<PlcRequest>(readRequest.getNumberOfFields());
        for (String fieldName : readRequest.getFieldNames()) {
            PlcField field = readRequest.getField(fieldName);
            DefaultPlcReadRequest subRequest = new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), new LinkedHashMap<String, PlcField>(Collections.singletonMap(fieldName, field)));
            subRequests.add((PlcRequest)subRequest);
        }
        return subRequests;
    }

    @Override
    protected List<PlcRequest> processWriteRequest(PlcWriteRequest writeRequest, DriverContext driverContext) {
        if (writeRequest.getNumberOfFields() == 1) {
            return Collections.singletonList(writeRequest);
        }
        ArrayList<PlcRequest> subRequests = new ArrayList<PlcRequest>(writeRequest.getNumberOfFields());
        for (String fieldName : writeRequest.getFieldNames()) {
            PlcField field = writeRequest.getField(fieldName);
            PlcValue value = writeRequest.getPlcValue(fieldName);
            DefaultPlcWriteRequest subRequest = new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), new LinkedHashMap<String, FieldValueItem>(Collections.singletonMap(fieldName, new FieldValueItem(field, value))));
            subRequests.add((PlcRequest)subRequest);
        }
        return subRequests;
    }
}

