/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.utils.ascii;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.spi.utils.ascii.AsciiBox;

class BoxSet {
    final String upperLeftCorner;
    final String upperRightCorner;
    final String horizontalLine;
    final String verticalLine;
    final String lowerLeftCorner;
    final String lowerRightCorner;

    public BoxSet(String upperLeftCorner, String upperRightCorner, String horizontalLine, String verticalLine, String lowerLeftCorner, String lowerRightCorner) {
        this.upperLeftCorner = upperLeftCorner;
        this.upperRightCorner = upperRightCorner;
        this.horizontalLine = horizontalLine;
        this.verticalLine = verticalLine;
        this.lowerLeftCorner = lowerLeftCorner;
        this.lowerRightCorner = lowerRightCorner;
    }

    public String compressBoxSet() {
        return this.upperLeftCorner + this.upperRightCorner + this.horizontalLine + this.verticalLine + this.lowerLeftCorner + this.lowerRightCorner;
    }

    String contributeToCompressedBoxSet(AsciiBox box) {
        String actualSet = this.compressBoxSet();
        if (box.compressedBoxSet.contains(actualSet)) {
            return box.compressedBoxSet;
        }
        return box.compressedBoxSet + "," + actualSet;
    }

    static String combineCompressedBoxSets(AsciiBox box1, AsciiBox box2) {
        HashSet<String> allSets = new HashSet<String>();
        allSets.addAll(Arrays.asList(box1.compressedBoxSet.split(",")));
        allSets.addAll(Arrays.asList(box2.compressedBoxSet.split(",")));
        return StringUtils.join(allSets, (String)",");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxSet boxSet = (BoxSet)o;
        return this.upperLeftCorner.equals(boxSet.upperLeftCorner) && this.upperRightCorner.equals(boxSet.upperRightCorner) && this.horizontalLine.equals(boxSet.horizontalLine) && this.verticalLine.equals(boxSet.verticalLine) && this.lowerLeftCorner.equals(boxSet.lowerLeftCorner) && this.lowerRightCorner.equals(boxSet.lowerRightCorner);
    }

    public int hashCode() {
        return Objects.hash(this.upperLeftCorner, this.upperRightCorner, this.horizontalLine, this.verticalLine, this.lowerLeftCorner, this.lowerRightCorner);
    }
}

