/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcSINT
extends PlcIECValue<Byte> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static final Byte minValue = -128;
    static final Byte maxValue = 127;

    public static PlcSINT of(Object value) {
        if (value instanceof Boolean) {
            return new PlcSINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcSINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcSINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcSINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcSINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcSINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcSINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcSINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcSINT((BigDecimal)value);
        }
        return new PlcSINT((String)value);
    }

    public PlcSINT(Boolean value) {
        this.value = value != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        this.isNullable = false;
    }

    public PlcSINT(Byte value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcSINT(Short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(Integer value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(Long value) {
        if (value < (long)minValue.byteValue() || value > (long)maxValue.byteValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(Float value) {
        if (value.floatValue() < (float)minValue.byteValue() || value.floatValue() > (float)maxValue.byteValue() || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(Double value) {
        if (value < (double)minValue.byteValue() || value > (double)maxValue.byteValue() || value % 1.0 != 0.0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue.byteValue())) < 0 || value.compareTo(BigInteger.valueOf(maxValue.byteValue())) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = true;
    }

    public PlcSINT(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue.byteValue())) < 0 || value.compareTo(BigDecimal.valueOf(maxValue.byteValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = true;
    }

    public PlcSINT(String value) {
        try {
            this.value = Byte.valueOf(value.trim());
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public PlcSINT(byte value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.SINT;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Byte)this.value).equals((byte)0);
    }

    @Override
    public boolean isByte() {
        return true;
    }

    @Override
    public byte getByte() {
        return (Byte)this.value;
    }

    @Override
    public boolean isShort() {
        return true;
    }

    @Override
    public short getShort() {
        return ((Byte)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return ((Byte)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return ((Byte)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Byte)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Byte)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return Byte.toString((Byte)this.value);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Byte)this.value & 0xFF)};
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeByte(this.getClass().getSimpleName(), (Byte)this.value, new WithWriterArgs[0]);
    }
}

