/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyChannelFactory
implements ChannelFactory {
    private static final Logger logger = LoggerFactory.getLogger(NettyChannelFactory.class);
    private final Map<Channel, EventLoopGroup> eventLoops = new ConcurrentHashMap<Channel, EventLoopGroup>();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;

    protected NettyChannelFactory(SocketAddress remoteAddress) {
        this(null, remoteAddress);
    }

    protected NettyChannelFactory(SocketAddress localAddress, SocketAddress remoteAddress) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
    }

    public abstract Class<? extends Channel> getChannel();

    protected Bootstrap createBootstrap() {
        return new Bootstrap();
    }

    public abstract void configureBootstrap(Bootstrap var1);

    public EventLoopGroup getEventLoopGroup() {
        return new NioEventLoopGroup(1);
    }

    @Override
    public Channel createChannel(ChannelHandler channelHandler) throws PlcConnectionException {
        try {
            Bootstrap bootstrap = this.createBootstrap();
            EventLoopGroup workerGroup = this.getEventLoopGroup();
            if (workerGroup != null) {
                bootstrap.group(workerGroup);
            }
            bootstrap.channel(this.getChannel());
            this.configureBootstrap(bootstrap);
            bootstrap.handler(channelHandler);
            ChannelFuture f = this.localAddress == null ? bootstrap.connect(this.remoteAddress) : bootstrap.connect(this.remoteAddress, this.localAddress);
            f.addListener(future -> {
                if (!future.isSuccess()) {
                    logger.info("Unable to connect, shutting down worker thread.");
                    if (workerGroup != null) {
                        workerGroup.shutdownGracefully();
                    }
                }
            });
            Channel channel = f.channel();
            if (workerGroup != null) {
                channel.closeFuture().addListener(future -> {
                    Future future2 = workerGroup.shutdownGracefully();
                });
                this.eventLoops.put(channel, workerGroup);
            }
            if (!"Plc4xEmbeddedChannel".equals(channel.getClass().getSimpleName())) {
                f.sync();
                f.awaitUninterruptibly();
            }
            return channel;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException("Error creating channel.", (Throwable)e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new PlcConnectionException("Error creating channel.", t);
        }
    }

    @Override
    public void closeEventLoopForChannel(Channel channel) {
        if (this.eventLoops.containsKey(channel)) {
            logger.info("Channel is closed, closing worker Group also");
            EventLoopGroup eventExecutors = this.eventLoops.get(channel);
            this.eventLoops.remove(channel);
            eventExecutors.shutdownGracefully().awaitUninterruptibly(2000L);
            logger.info("Worker Group was closed successfully!");
        } else {
            logger.warn("Trying to remove EventLoop for Channel {} but have none stored", (Object)channel);
        }
    }
}

