/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcBrowseItem;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcBrowseItem
implements PlcBrowseItem,
Serializable {
    private final PlcTag tag;
    private final String name;
    private final boolean readable;
    private final boolean writable;
    private final boolean subscribable;
    private final boolean publishable;
    private final List<ArrayInfo> arrayInformation;
    private final Map<String, PlcBrowseItem> children;
    private final Map<String, PlcValue> options;

    public DefaultPlcBrowseItem(PlcTag tag, String name, boolean readable, boolean writable, boolean subscribable, boolean publishable, List<ArrayInfo> arrayInformation, Map<String, PlcBrowseItem> children, Map<String, PlcValue> options) {
        this.tag = tag;
        this.name = name;
        this.readable = readable;
        this.writable = writable;
        this.subscribable = subscribable;
        this.publishable = publishable;
        this.arrayInformation = arrayInformation;
        this.children = children;
        this.options = options;
    }

    protected DefaultPlcBrowseItem(PlcBrowseItem original, Map<String, PlcBrowseItem> children) {
        this.tag = original.getTag();
        this.name = original.getName();
        this.readable = original.isReadable();
        this.writable = original.isWritable();
        this.subscribable = original.isSubscribable();
        this.publishable = original.isPublishable();
        this.arrayInformation = original.getArrayInformation();
        this.options = original.getOptions();
        this.children = children;
    }

    public PlcTag getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isSubscribable() {
        return this.subscribable;
    }

    public boolean isPublishable() {
        return this.publishable;
    }

    public boolean isArray() {
        return false;
    }

    public List<ArrayInfo> getArrayInformation() {
        return this.arrayInformation;
    }

    public Map<String, PlcBrowseItem> getChildren() {
        return this.children;
    }

    public Map<String, PlcValue> getOptions() {
        return this.options;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcBrowseItem", new WithWriterArgs[0]);
        writeBuffer.writeString("address", this.tag.getAddressString().getBytes(StandardCharsets.UTF_8).length * 8, this.tag.getAddressString(), WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        writeBuffer.writeString("name", this.name.getBytes(StandardCharsets.UTF_8).length * 8, this.name, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        if (this.children != null && !this.children.isEmpty()) {
            writeBuffer.pushContext("children", new WithWriterArgs[0]);
            for (PlcBrowseItem plcBrowseItem : this.children.values()) {
                writeBuffer.pushContext("child", new WithWriterArgs[0]);
                ((DefaultPlcBrowseItem)plcBrowseItem).serialize(writeBuffer);
                writeBuffer.popContext("child", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("children", new WithWriterArgs[0]);
        }
        if (this.options != null && !this.options.isEmpty()) {
            writeBuffer.pushContext("options", new WithWriterArgs[0]);
            for (Map.Entry entry : this.options.entrySet()) {
                writeBuffer.pushContext("option", new WithWriterArgs[0]);
                writeBuffer.writeString("name", ((String)entry.getKey()).getBytes(StandardCharsets.UTF_8).length * 8, (String)entry.getKey(), WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
                ((DefaultPlcBrowseItem)((Object)entry)).serialize(writeBuffer);
                writeBuffer.popContext("option", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("options", new WithWriterArgs[0]);
        }
        writeBuffer.popContext("PlcBrowseItem", new WithWriterArgs[0]);
    }
}

