/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.exceptions.PlcTagNotFoundException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcTagRequest;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagErrorItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagItem;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcReadRequest
implements PlcReadRequest,
PlcTagRequest,
Serializable {
    private final PlcReader reader;
    private final LinkedHashMap<String, PlcTagItem<PlcTag>> tags;

    public DefaultPlcReadRequest(PlcReader reader, LinkedHashMap<String, PlcTagItem<PlcTag>> tags) {
        this.reader = reader;
        this.tags = tags;
    }

    public CompletableFuture<PlcReadResponse> execute() {
        return this.reader.read(this);
    }

    public int getNumberOfTags() {
        return this.tags.size();
    }

    public LinkedHashSet<String> getTagNames() {
        return new LinkedHashSet<String>(this.tags.keySet());
    }

    public PlcTagItem<PlcTag> getTagItem(String tagName) {
        return this.tags.get(tagName);
    }

    public PlcTag getTag(String tagName) {
        return this.tags.get(tagName).getTag();
    }

    public PlcResponseCode getTagResponseCode(String tagName) {
        return this.tags.get(tagName).getResponseCode();
    }

    public List<PlcTag> getTags() {
        return this.tags.values().stream().filter(plcTagItem -> plcTagItem instanceof DefaultPlcTagItem).map(PlcTagItem::getTag).collect(Collectors.toList());
    }

    public PlcReader getReader() {
        return this.reader;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcReadRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("PlcTagRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("tags", WithReaderWriterArgs.WithRenderAsList(true));
        for (Map.Entry<String, PlcTagItem<PlcTag>> tagEntry : this.tags.entrySet()) {
            String tagName = tagEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcTagItem<PlcTag> tagItem = tagEntry.getValue();
            if (!(tagItem instanceof Serializable)) {
                throw new RuntimeException("Error serializing. PlcTagItem doesn't implement Serializable");
            }
            ((Serializable)((Object)tagItem)).serialize(writeBuffer);
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("tags", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcTagRequest", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcReadRequest", new WithWriterArgs[0]);
    }

    public static class Builder
    implements PlcReadRequest.Builder {
        private final PlcReader reader;
        private final PlcTagHandler tagHandler;
        private final Map<String, Supplier<PlcTagItem<PlcTag>>> tagItems;

        public Builder(PlcReader reader, PlcTagHandler tagHandler) {
            this.reader = Objects.requireNonNull(reader);
            this.tagHandler = Objects.requireNonNull(tagHandler);
            this.tagItems = new LinkedHashMap<String, Supplier<PlcTagItem<PlcTag>>>();
        }

        public PlcReadRequest.Builder addTagAddress(String name, String tagAddress) {
            if (this.tagItems.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tagItems.put(name, () -> {
                try {
                    PlcTag tag = this.tagHandler.parseTag(tagAddress);
                    return new DefaultPlcTagItem<PlcTag>(tag);
                }
                catch (PlcTagNotFoundException e) {
                    return new DefaultPlcTagErrorItem(PlcResponseCode.NOT_FOUND);
                }
                catch (Exception e) {
                    return new DefaultPlcTagErrorItem(PlcResponseCode.INVALID_ADDRESS);
                }
            });
            return this;
        }

        public PlcReadRequest.Builder addTag(String name, PlcTag tag) {
            if (this.tagItems.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tagItems.put(name, () -> new DefaultPlcTagItem<PlcTag>(tag));
            return this;
        }

        public PlcReadRequest build() {
            LinkedHashMap<String, PlcTagItem<PlcTag>> parsedTags = new LinkedHashMap<String, PlcTagItem<PlcTag>>();
            this.tagItems.forEach((name, tagItemSupplier) -> {
                PlcTagItem plcTagItem = (PlcTagItem)tagItemSupplier.get();
                parsedTags.put((String)name, plcTagItem);
            });
            return new DefaultPlcReadRequest(this.reader, parsedTags);
        }
    }
}

