/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcNotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.utils.PlcResponseItem;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcSubscriptionResponse
implements PlcSubscriptionResponse,
PlcResponse,
Serializable {
    private final PlcSubscriptionRequest request;
    private final Map<String, PlcResponseItem<PlcSubscriptionHandle>> values;

    public DefaultPlcSubscriptionResponse(PlcSubscriptionRequest request, Map<String, PlcResponseItem<PlcSubscriptionHandle>> values) {
        this.request = request;
        this.values = values;
    }

    public PlcSubscriptionHandle getSubscriptionHandle(String name) {
        PlcResponseItem<PlcSubscriptionHandle> response = this.values.get(name);
        if (response == null) {
            return null;
        }
        if (response.getResponseCode() != PlcResponseCode.OK) {
            throw new PlcRuntimeException("Item " + name + " failed to subscribe: " + response.getResponseCode());
        }
        return response.getValue();
    }

    public Collection<String> getTagNames() {
        return this.values.keySet();
    }

    public PlcSubscriptionTag getTag(String name) {
        throw new PlcNotImplementedException("tag access not possible as these come async");
    }

    public PlcResponseCode getResponseCode(String name) {
        PlcResponseItem<PlcSubscriptionHandle> response = this.values.get(name);
        if (response == null) {
            return null;
        }
        return response.getResponseCode();
    }

    public PlcSubscriptionRequest getRequest() {
        return this.request;
    }

    public Collection<PlcSubscriptionHandle> getSubscriptionHandles() {
        return this.values.values().stream().map(PlcResponseItem::getValue).collect(Collectors.toList());
    }

    public Map<String, PlcResponseItem<PlcSubscriptionHandle>> getValues() {
        return this.values;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcSubscriptionResponse", new WithWriterArgs[0]);
        if (this.request instanceof Serializable) {
            ((Serializable)this.request).serialize(writeBuffer);
        }
        writeBuffer.pushContext("values", new WithWriterArgs[0]);
        for (Map.Entry<String, PlcResponseItem<PlcSubscriptionHandle>> valueEntry : this.values.entrySet()) {
            String tagName = valueEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcResponseItem<PlcSubscriptionHandle> valueResponse = valueEntry.getValue();
            if (!(valueResponse instanceof Serializable)) {
                throw new RuntimeException("Error serializing. PlcResponseItem doesn't implement Serializable");
            }
            ((Serializable)((Object)valueResponse)).serialize(writeBuffer);
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("values", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcSubscriptionResponse", new WithWriterArgs[0]);
    }
}

