/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagErrorItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagValueItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagValueItem;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class DefaultPlcWriteRequest
implements PlcWriteRequest,
Serializable {
    private final PlcWriter writer;
    private final LinkedHashMap<String, PlcTagValueItem<PlcTag>> tags;

    public DefaultPlcWriteRequest(PlcWriter writer, LinkedHashMap<String, PlcTagValueItem<PlcTag>> tags) {
        this.writer = writer;
        this.tags = tags;
    }

    public CompletableFuture<PlcWriteResponse> execute() {
        return this.writer.write(this);
    }

    public int getNumberOfTags() {
        return this.tags.size();
    }

    public LinkedHashSet<String> getTagNames() {
        return new LinkedHashSet<String>(this.tags.keySet());
    }

    public PlcTagValueItem<PlcTag> getTagValueItem(String tagName) {
        return this.tags.get(tagName);
    }

    public PlcResponseCode getTagResponseCode(String tagName) {
        return this.tags.get(tagName).getResponseCode();
    }

    public PlcTag getTag(String name) {
        return this.tags.get(name).getTag();
    }

    public List<PlcTag> getTags() {
        return this.tags.values().stream().map(PlcTagItem::getTag).collect(Collectors.toCollection(LinkedList::new));
    }

    public PlcValue getPlcValue(String name) {
        return this.tags.get(name).getValue();
    }

    public List<PlcValue> getPlcValues() {
        return this.tags.values().stream().map(PlcTagValueItem::getValue).collect(Collectors.toCollection(LinkedList::new));
    }

    public PlcWriter getWriter() {
        return this.writer;
    }

    public int getNumberOfValues(String name) {
        PlcValue value = this.tags.get(name).getValue();
        if (value instanceof PlcList) {
            PlcList list = (PlcList)value;
            return list.getLength();
        }
        return 1;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcWriteRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("PlcTagRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("tags", WithReaderWriterArgs.WithRenderAsList(true));
        for (Map.Entry<String, PlcTagValueItem<PlcTag>> tagEntry : this.tags.entrySet()) {
            String tagName = tagEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcTagValueItem<PlcTag> plcTagValueItem = tagEntry.getValue();
            if (!(plcTagValueItem instanceof Serializable)) {
                throw new RuntimeException("Error serializing. PlcTagValueItem doesn't implement Serializable");
            }
            ((Serializable)((Object)plcTagValueItem)).serialize(writeBuffer);
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("tags", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcTagRequest", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcWriteRequest", new WithWriterArgs[0]);
    }

    protected void serializePlcValue(PlcValue plcValue, WriteBuffer writeBuffer) throws SerializationException {
        if (plcValue instanceof Serializable) {
            Serializable serializable = (Serializable)plcValue;
            serializable.serialize(writeBuffer);
        } else {
            String plcValueString = plcValue.getString();
            writeBuffer.writeString("value", plcValueString.getBytes(StandardCharsets.UTF_8).length * 8, plcValueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        }
    }

    public static class Builder
    implements PlcWriteRequest.Builder {
        private final PlcWriter writer;
        private final PlcTagHandler tagHandler;
        private final PlcValueHandler valueHandler;
        private final Map<String, Supplier<PlcTagValueItem<PlcTag>>> tagValues;

        public Builder(PlcWriter writer, PlcTagHandler tagHandler, PlcValueHandler valueHandler) {
            this.writer = Objects.requireNonNull(writer);
            this.tagHandler = Objects.requireNonNull(tagHandler);
            this.valueHandler = Objects.requireNonNull(valueHandler);
            this.tagValues = new TreeMap<String, Supplier<PlcTagValueItem<PlcTag>>>();
        }

        public Builder addTagAddress(String name, String tagAddress, Object ... values) {
            if (this.tagValues.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tagValues.put(name, () -> {
                try {
                    PlcTag tag = this.tagHandler.parseTag(tagAddress);
                    try {
                        PlcValue plcValue = this.parsePlcValue(tag, values);
                        return new DefaultPlcTagValueItem<PlcTag>(tag, plcValue);
                    }
                    catch (Exception e) {
                        return new DefaultPlcTagErrorItem(PlcResponseCode.INVALID_DATA);
                    }
                }
                catch (Exception e) {
                    return new DefaultPlcTagErrorItem(PlcResponseCode.INVALID_ADDRESS);
                }
            });
            return this;
        }

        public Builder addTag(String name, PlcTag tag, Object ... values) {
            if (this.tagValues.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tagValues.put(name, () -> {
                try {
                    PlcValue plcValue = this.parsePlcValue(tag, values);
                    return new DefaultPlcTagValueItem<PlcTag>(tag, plcValue);
                }
                catch (Exception e) {
                    return new DefaultPlcTagErrorItem(PlcResponseCode.INVALID_DATA);
                }
            });
            return this;
        }

        protected PlcValue parsePlcValue(PlcTag tag, Object[] values) {
            return this.valueHandler.newPlcValue(tag, values);
        }

        public PlcWriteRequest build() {
            LinkedHashMap<String, PlcTagValueItem<PlcTag>> parsedTags = new LinkedHashMap<String, PlcTagValueItem<PlcTag>>();
            this.tagValues.forEach((name, tagValueItemSupplier) -> {
                PlcTagValueItem plcTagValueItem = (PlcTagValueItem)tagValueItemSupplier.get();
                parsedTags.put((String)name, plcTagValueItem);
            });
            return new DefaultPlcWriteRequest(this.writer, parsedTags);
        }
    }
}

