/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.metadata;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.plc4x.java.api.metadata.Metadata;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetadata
implements Metadata,
Serializable {
    private final Metadata parent;
    private final Map<Metadata.Key<?>, Object> values;

    DefaultMetadata(Map<Metadata.Key<?>, Object> values) {
        this(values, Metadata.EMPTY);
    }

    public DefaultMetadata(Map<Metadata.Key<?>, Object> values, Metadata parent) {
        this.values = new LinkedHashMap(values);
        this.parent = Objects.requireNonNull(parent, "Parent metadata must not be null");
    }

    public Set<Metadata.Key<?>> keys() {
        LinkedHashSet keys = new LinkedHashSet(this.values.keySet());
        keys.addAll(this.parent.keys());
        return Collections.unmodifiableSet(keys);
    }

    public Map<Metadata.Key<?>, Object> entries() {
        LinkedHashMap copy = new LinkedHashMap(this.parent.entries());
        copy.putAll(this.values);
        return Map.copyOf(copy);
    }

    public Object getValue(Metadata.Key<?> key) {
        Object value = this.values.get(key);
        if (value == null) {
            return this.parent.getValue(key);
        }
        return value;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        for (Metadata.Key<?> metadataKey : this.keys()) {
            writeBuffer.pushContext("entry", WithReaderWriterArgs.WithRenderAsList(false));
            writeBuffer.writeString("key", metadataKey.getKey().length(), metadataKey.getKey(), new WithWriterArgs[0]);
            String value = "" + this.getValue(metadataKey);
            writeBuffer.writeString("value", value.length(), value, new WithWriterArgs[0]);
            writeBuffer.popContext("entry", new WithWriterArgs[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.entries(), that.entries());
    }

    public int hashCode() {
        return Objects.hash(this.entries());
    }

    public static class Builder {
        private final Logger logger = LoggerFactory.getLogger(Builder.class);
        private final Map<Metadata.Key<?>, Object> values = new LinkedHashMap();
        private final Metadata parent;

        public Builder() {
            this(EMPTY);
        }

        public Builder(Metadata parent) {
            this.parent = parent;
        }

        public <T> Builder put(Metadata.Key<T> key, T value) {
            if (!key.validate(value)) {
                this.logger.debug("Ignore metadata value {}, it does not match constraints imposed by key {}", value, key);
                return this;
            }
            this.values.put(key, value);
            return this;
        }

        public Metadata build() {
            return new DefaultMetadata(this.values, this.parent);
        }
    }
}

