/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.optimizer;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.PlcResponseItem;

public abstract class BaseOptimizer {
    protected List<PlcReadRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        return Collections.singletonList(readRequest);
    }

    protected PlcReadResponse processReadResponses(PlcReadRequest readRequest, Map<PlcReadRequest, SubResponse<PlcReadResponse>> readResponses, DriverContext driverContext) {
        HashMap<String, PlcResponseItem<PlcValue>> tags = new HashMap<String, PlcResponseItem<PlcValue>>();
        for (Map.Entry<PlcReadRequest, SubResponse<PlcReadResponse>> requestsEntries : readResponses.entrySet()) {
            PlcReadRequest curRequest = requestsEntries.getKey();
            SubResponse<PlcReadResponse> readResponse = requestsEntries.getValue();
            for (String tagName : curRequest.getTagNames()) {
                if (readResponse.isSuccess()) {
                    PlcReadResponse subReadResponse = readResponse.getResponse();
                    PlcResponseCode responseCode = subReadResponse.getResponseCode(tagName);
                    PlcValue value = subReadResponse.getAsPlcValue().getValue(tagName);
                    tags.put(tagName, new DefaultPlcResponseItem<PlcValue>(responseCode, value));
                    continue;
                }
                tags.put(tagName, new DefaultPlcResponseItem<Object>(PlcResponseCode.INTERNAL_ERROR, null));
            }
        }
        return new DefaultPlcReadResponse(readRequest, tags);
    }

    protected List<PlcWriteRequest> processWriteRequest(PlcWriteRequest writeRequest, DriverContext driverContext) {
        return Collections.singletonList(writeRequest);
    }

    protected PlcWriteResponse processWriteResponses(PlcWriteRequest writeRequest, Map<PlcWriteRequest, SubResponse<PlcWriteResponse>> writeResponses, DriverContext driverContext) {
        HashMap<String, PlcResponseCode> tags = new HashMap<String, PlcResponseCode>();
        for (Map.Entry<PlcWriteRequest, SubResponse<PlcWriteResponse>> requestsEntries : writeResponses.entrySet()) {
            PlcWriteRequest subWriteRequest = requestsEntries.getKey();
            SubResponse<PlcWriteResponse> writeResponse = requestsEntries.getValue();
            for (String tagName : subWriteRequest.getTagNames()) {
                if (writeResponse.isSuccess()) {
                    PlcWriteResponse subWriteResponse = writeResponse.getResponse();
                    tags.put(tagName, subWriteResponse.getResponseCode(tagName));
                    continue;
                }
                tags.put(tagName, PlcResponseCode.INTERNAL_ERROR);
            }
        }
        return new DefaultPlcWriteResponse(writeRequest, tags);
    }

    protected List<PlcSubscriptionRequest> processSubscriptionRequest(PlcSubscriptionRequest subscriptionRequest, DriverContext driverContext) {
        return Collections.singletonList(subscriptionRequest);
    }

    protected PlcSubscriptionResponse processSubscriptionResponses(PlcSubscriptionRequest subscriptionRequest, Map<PlcSubscriptionRequest, SubResponse<PlcSubscriptionResponse>> subscriptionResponses, DriverContext driverContext) {
        return null;
    }

    protected List<PlcUnsubscriptionRequest> processUnsubscriptionRequest(PlcUnsubscriptionRequest unsubscriptionRequest, DriverContext driverContext) {
        return Collections.singletonList(unsubscriptionRequest);
    }

    protected PlcUnsubscriptionResponse processUnsubscriptionResponses(PlcUnsubscriptionRequest unsubscriptionRequest, Map<PlcUnsubscriptionRequest, SubResponse<PlcUnsubscriptionResponse>> unsubscriptionResponses, DriverContext driverContext) {
        return null;
    }

    public CompletableFuture<PlcReadResponse> optimizedRead(PlcReadRequest readRequest, Plc4xProtocolBase<?> reader) {
        List<PlcReadRequest> subRequests = this.processReadRequest(readRequest, reader.getDriverContext());
        return this.send(readRequest, subRequests, reader::read, response -> this.processReadResponses(readRequest, (Map<PlcReadRequest, SubResponse<PlcReadResponse>>)response, reader.getDriverContext()));
    }

    public CompletableFuture<PlcWriteResponse> optimizedWrite(PlcWriteRequest writeRequest, Plc4xProtocolBase<?> writer) {
        List<PlcWriteRequest> subRequests = this.processWriteRequest(writeRequest, writer.getDriverContext());
        return this.send(writeRequest, subRequests, writer::write, response -> this.processWriteResponses(writeRequest, (Map<PlcWriteRequest, SubResponse<PlcWriteResponse>>)response, writer.getDriverContext()));
    }

    public CompletableFuture<PlcSubscriptionResponse> optimizedSubscribe(PlcSubscriptionRequest subscriptionRequest, Plc4xProtocolBase<?> subscriber) {
        List<PlcSubscriptionRequest> subRequests = this.processSubscriptionRequest(subscriptionRequest, subscriber.getDriverContext());
        return this.send(subscriptionRequest, subRequests, subscriber::subscribe, response -> this.processSubscriptionResponses(subscriptionRequest, (Map<PlcSubscriptionRequest, SubResponse<PlcSubscriptionResponse>>)response, subscriber.getDriverContext()));
    }

    public CompletableFuture<PlcUnsubscriptionResponse> optimizedUnsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest, Plc4xProtocolBase<?> subscriber) {
        List<PlcUnsubscriptionRequest> subRequests = this.processUnsubscriptionRequest(unsubscriptionRequest, subscriber.getDriverContext());
        return this.send(unsubscriptionRequest, subRequests, subscriber::unsubscribe, response -> this.processUnsubscriptionResponses(unsubscriptionRequest, (Map<PlcUnsubscriptionRequest, SubResponse<PlcUnsubscriptionResponse>>)response, subscriber.getDriverContext()));
    }

    protected int getMillisDelay() {
        return 0;
    }

    protected int getNanosDelay() {
        return 0;
    }

    private <REQ extends PlcRequest, RES extends PlcResponse> CompletableFuture<RES> send(REQ originalRequest, List<REQ> requests, Function<REQ, CompletableFuture<RES>> sender, Function<Map<REQ, SubResponse<RES>>, RES> responseProcessor) {
        if (requests.size() == 1 && requests.get(0) == originalRequest) {
            return sender.apply((PlcRequest)requests.get(0));
        }
        if (requests.isEmpty()) {
            return CompletableFuture.completedFuture((PlcResponse)responseProcessor.apply(Collections.emptyMap()));
        }
        CompletableFuture parentFuture = new CompletableFuture();
        HashMap subFutures = new HashMap();
        for (PlcRequest subRequest : requests) {
            subFutures.put(subRequest, sender.apply(subRequest));
            if (this.getMillisDelay() <= 0 && this.getNanosDelay() <= 0) continue;
            try {
                Thread.sleep(this.getMillisDelay(), this.getNanosDelay());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        ((CompletableFuture)CompletableFuture.allOf(subFutures.values().toArray(new CompletableFuture[0])).handle((aVoid, t) -> {
            if (t != null) {
                parentFuture.completeExceptionally((Throwable)t);
            }
            HashMap results = new HashMap();
            for (Map.Entry subFutureEntry : subFutures.entrySet()) {
                PlcRequest subRequest = (PlcRequest)subFutureEntry.getKey();
                CompletableFuture subFuture = (CompletableFuture)subFutureEntry.getValue();
                try {
                    PlcResponse subResponse = (PlcResponse)subFuture.get();
                    results.put(subRequest, new SubResponse<PlcResponse>(subResponse));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    results.put(subRequest, new SubResponse(new Exception("Something went wrong")));
                }
                catch (Exception e) {
                    results.put(subRequest, new SubResponse(new Exception("Something went wrong")));
                }
            }
            PlcResponse response = (PlcResponse)responseProcessor.apply(results);
            parentFuture.complete(response);
            return Void.TYPE;
        })).exceptionally(throwable -> {
            parentFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        return parentFuture;
    }

    public static class SubResponse<T extends PlcResponse> {
        private final T response;
        private final Throwable throwable;

        public SubResponse(T response) {
            this.response = response;
            this.throwable = null;
        }

        public SubResponse(Throwable throwable) {
            this.response = null;
            this.throwable = throwable;
        }

        public T getResponse() {
            return this.response;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean isSuccess() {
            return this.throwable == null;
        }
    }
}

