/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedDataTypeException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_LTIME;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLDATE;
import org.apache.plc4x.java.spi.values.PlcLDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLTIME;
import org.apache.plc4x.java.spi.values.PlcLTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.apache.plc4x.java.spi.values.PlcWSTRING;

public class DefaultPlcValueHandler
implements PlcValueHandler {
    @Override
    public PlcValue newPlcValue(PlcTag tag, Object value) {
        return DefaultPlcValueHandler.of(tag, new Object[]{value});
    }

    @Override
    public PlcValue newPlcValue(PlcTag tag, Object[] values) {
        return DefaultPlcValueHandler.of(tag, values);
    }

    public static PlcValue of(PlcTag tag, Object value) {
        return DefaultPlcValueHandler.of(tag, new Object[]{value});
    }

    public static PlcValue of(PlcTag tag, Object[] values) {
        if (tag.getArrayInfo().isEmpty()) {
            if (values.length == 0) {
                throw new PlcRuntimeException("No value was passed in as argument");
            }
            if (values.length == 1) {
                if (values[0] instanceof Collection) {
                    if (((Collection)values[0]).size() > 1) {
                        throw new PlcRuntimeException("The type is not an array type, but a collection of more than one item was passed in as argument");
                    }
                    if (((Collection)values[0]).isEmpty()) {
                        throw new PlcRuntimeException("An empty collection was passed in as argument");
                    }
                }
                return DefaultPlcValueHandler.ofElement(tag.getPlcValueType(), values[0]);
            }
            throw new PlcRuntimeException("The type is not an array type, but more than one value was passed in as argument");
        }
        return DefaultPlcValueHandler.ofElements(tag.getPlcValueType(), tag.getArrayInfo(), values);
    }

    private static PlcValue ofElements(PlcValueType type, List<ArrayInfo> arrayInfos, Object[] values) {
        ArrayInfo arrayInfo = arrayInfos.get(0);
        if (values.length == 1) {
            if (values[0] instanceof Object[]) {
                values = (Object[])values[0];
            } else if (values[0] instanceof Collection) {
                values = ((Collection)values[0]).toArray();
            } else if (values[0] instanceof PlcList) {
                values = ((PlcList)values[0]).getList().toArray();
            } else if (values[0] instanceof PlcRawByteArray) {
                PlcRawByteArray plcRawByteArray = (PlcRawByteArray)values[0];
                if (plcRawByteArray.getRaw().length != arrayInfo.getSize()) {
                    throw new PlcRuntimeException(String.format("Expecting %d items, but got %d", arrayInfo.getSize(), plcRawByteArray.getRaw().length));
                }
                return plcRawByteArray;
            }
        }
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(arrayInfo.getSize());
        if (arrayInfos.size() == 1) {
            if (values.length != arrayInfo.getSize()) {
                throw new PlcRuntimeException(String.format("Expecting %d items, but got %d", arrayInfo.getSize(), values.length));
            }
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                plcValues.add(DefaultPlcValueHandler.ofElement(type, value));
                ++n2;
            }
        } else {
            Object[] objectArray = values;
            int n = values.length;
            int n3 = 0;
            while (n3 < n) {
                Object value = objectArray[n3];
                plcValues.add(DefaultPlcValueHandler.ofElements(type, arrayInfos.subList(1, arrayInfos.size()), (Object[])value));
                ++n3;
            }
        }
        return new PlcList(plcValues);
    }

    private static PlcValue ofElement(PlcValueType type, Object value) {
        if (type == null) {
            return DefaultPlcValueHandler.of(value);
        }
        switch (type) {
            case BOOL: {
                return PlcBOOL.of(value);
            }
            case BYTE: {
                return PlcBYTE.of(value);
            }
            case SINT: {
                return PlcSINT.of(value);
            }
            case USINT: {
                return PlcUSINT.of(value);
            }
            case INT: {
                return PlcINT.of(value);
            }
            case UINT: {
                return PlcUINT.of(value);
            }
            case WORD: {
                return PlcWORD.of(value);
            }
            case DINT: {
                return PlcDINT.of(value);
            }
            case UDINT: {
                return PlcUDINT.of(value);
            }
            case DWORD: {
                return PlcDWORD.of(value);
            }
            case LINT: {
                return PlcLINT.of(value);
            }
            case ULINT: {
                return PlcULINT.of(value);
            }
            case LWORD: {
                return PlcLWORD.of(value);
            }
            case REAL: {
                return PlcREAL.of(value);
            }
            case LREAL: {
                return PlcLREAL.of(value);
            }
            case CHAR: {
                return PlcCHAR.of(value);
            }
            case WCHAR: {
                return PlcWCHAR.of(value);
            }
            case STRING: {
                return PlcSTRING.of(value);
            }
            case WSTRING: {
                return PlcWSTRING.of(value);
            }
            case TIME: {
                return PlcTIME.of(value);
            }
            case LTIME: {
                return PlcLTIME.of(value);
            }
            case DATE: {
                return PlcDATE.of(value);
            }
            case LDATE: {
                return PlcLDATE.of(value);
            }
            case TIME_OF_DAY: {
                return PlcTIME_OF_DAY.of(value);
            }
            case LTIME_OF_DAY: {
                return PlcLTIME_OF_DAY.of(value);
            }
            case DATE_AND_TIME: {
                return PlcDATE_AND_TIME.of(value);
            }
            case DATE_AND_LTIME: {
                return PlcDATE_AND_LTIME.of(value);
            }
            case LDATE_AND_TIME: {
                return PlcLDATE_AND_TIME.of(value);
            }
            case RAW_BYTE_ARRAY: {
                return PlcRawByteArray.of(value);
            }
            case List: {
                throw new NotImplementedException("Not implemented yet");
            }
            case Struct: {
                throw new NotImplementedException("Not implemented yet");
            }
            case NULL: {
                return new PlcNull();
            }
        }
        throw new PlcUnsupportedDataTypeException("Data Type " + value.getClass() + " Is not supported");
    }

    private static PlcValue of(Object value) {
        if (value instanceof Boolean) {
            return PlcBOOL.of(value);
        }
        if (value instanceof Byte) {
            return PlcSINT.of(value);
        }
        if (value instanceof byte[]) {
            return PlcRawByteArray.of(value);
        }
        if (value instanceof Short) {
            return PlcINT.of(value);
        }
        if (value instanceof Integer) {
            return PlcDINT.of(value);
        }
        if (value instanceof Long) {
            return PlcLINT.of(value);
        }
        if (value instanceof BigInteger) {
            return PlcLINT.of(value);
        }
        if (value instanceof Float) {
            return PlcREAL.of(value);
        }
        if (value instanceof Double) {
            return PlcLREAL.of(value);
        }
        if (value instanceof Duration) {
            return new PlcTIME((Duration)value);
        }
        if (value instanceof LocalTime) {
            return new PlcTIME_OF_DAY((LocalTime)value);
        }
        if (value instanceof LocalDate) {
            return new PlcDATE((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return new PlcDATE_AND_TIME((LocalDateTime)value);
        }
        if (value instanceof String) {
            return new PlcSTRING((String)value);
        }
        if (value instanceof PlcValue) {
            return (PlcValue)value;
        }
        throw new PlcUnsupportedDataTypeException("Data Type " + value.getClass() + " Is not supported");
    }
}

