/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcDATE_AND_LTIME
extends PlcIECValue<LocalDateTime> {
    public static PlcDATE_AND_LTIME of(Object value) {
        if (value instanceof PlcDATE_AND_LTIME) {
            return (PlcDATE_AND_LTIME)value;
        }
        if (value instanceof LocalDateTime) {
            return new PlcDATE_AND_LTIME((LocalDateTime)value);
        }
        if (value instanceof Byte) {
            return new PlcDATE_AND_LTIME((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcDATE_AND_LTIME((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcDATE_AND_LTIME((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcDATE_AND_LTIME((Long)value);
        }
        if (value instanceof Float) {
            return new PlcDATE_AND_LTIME((Float)value);
        }
        if (value instanceof Double) {
            return new PlcDATE_AND_LTIME((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcDATE_AND_LTIME((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcDATE_AND_LTIME((BigDecimal)value);
        }
        return new PlcDATE_AND_LTIME(LocalDateTime.parse(value.toString()));
    }

    public PlcDATE_AND_LTIME(Byte nanosecondsSinceEpoch) {
        long secondsSinceEpoch = 0L;
        long nannoSecondsOfSecond = nanosecondsSinceEpoch % 1000000000;
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, (int)nannoSecondsOfSecond, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_LTIME(Short nanosecondsSinceEpoch) {
        long secondsSinceEpoch = 0L;
        long nannoSecondsOfSecond = nanosecondsSinceEpoch % 1000000000;
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, (int)nannoSecondsOfSecond, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_LTIME(Integer nanosecondsSinceEpoch) {
        long secondsSinceEpoch = nanosecondsSinceEpoch.longValue() / 1000000000L;
        long nannoSecondsOfSecond = nanosecondsSinceEpoch % 1000000000;
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, (int)nannoSecondsOfSecond, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_LTIME(Long nanosecondsSinceEpoch) {
        long secondsSinceEpoch = nanosecondsSinceEpoch / 1000000000L;
        long nannoSecondsOfSecond = nanosecondsSinceEpoch % 1000000000L;
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, (int)nannoSecondsOfSecond, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_LTIME(Float nanosecondsSinceEpoch) {
        long secondsSinceEpoch = nanosecondsSinceEpoch.longValue() / 1000000000L;
        long nannoSecondsOfSecond = nanosecondsSinceEpoch.longValue() % 1000000000L;
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, (int)nannoSecondsOfSecond, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_LTIME(Double nanosecondsSinceEpoch) {
        long secondsSinceEpoch = nanosecondsSinceEpoch.longValue() / 1000000000L;
        long nannoSecondsOfSecond = nanosecondsSinceEpoch.longValue() % 1000000000L;
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, (int)nannoSecondsOfSecond, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_LTIME(BigInteger nanosecondsSinceEpoch) {
        long secondsSinceEpoch = nanosecondsSinceEpoch.longValue() / 1000000000L;
        long nannoSecondsOfSecond = nanosecondsSinceEpoch.longValue() % 1000000000L;
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, (int)nannoSecondsOfSecond, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_LTIME(BigDecimal nanosecondsSinceEpoch) {
        long secondsSinceEpoch = nanosecondsSinceEpoch.longValue() / 1000000000L;
        long nannoSecondsOfSecond = nanosecondsSinceEpoch.longValue() % 1000000000L;
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, (int)nannoSecondsOfSecond, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_LTIME(LocalDateTime value) {
        this.value = value;
        this.isNullable = false;
    }

    public static PlcDATE_AND_LTIME ofNanosecondsSinceEpoch(BigInteger nanosecondsSinceEpoch) {
        return new PlcDATE_AND_LTIME(nanosecondsSinceEpoch.longValue());
    }

    public static PlcDATE_AND_LTIME ofSegments(int year, int month, int day, int hour, int minutes, int seconds, long nannosecondsOfSecond) {
        return new PlcDATE_AND_LTIME(LocalDateTime.of(year, month, day, hour, minutes, seconds, (int)nannosecondsOfSecond));
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE_AND_LTIME;
    }

    public BigInteger getNanosecondsSinceEpoch() {
        Instant instant = this.getDateTime().toInstant(ZoneOffset.UTC);
        return BigInteger.valueOf(instant.getEpochSecond()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(instant.getNano()));
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDateTime)this.value).atZone(ZoneOffset.UTC).toInstant();
        return instant.getEpochSecond();
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalDateTime)this.value).toString();
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public LocalTime getTime() {
        return ((LocalDateTime)this.value).toLocalTime();
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public LocalDate getDate() {
        return ((LocalDateTime)this.value).toLocalDate();
    }

    @Override
    public boolean isDateTime() {
        return true;
    }

    @Override
    public LocalDateTime getDateTime() {
        return (LocalDateTime)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDateTime)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

