/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcDATE_AND_TIME
extends PlcIECValue<LocalDateTime> {
    public static PlcDATE_AND_TIME of(Object value) {
        if (value instanceof PlcDATE_AND_TIME) {
            return (PlcDATE_AND_TIME)value;
        }
        if (value instanceof LocalDateTime) {
            return new PlcDATE_AND_TIME((LocalDateTime)value);
        }
        if (value instanceof Byte) {
            return new PlcDATE_AND_TIME((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcDATE_AND_TIME((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcDATE_AND_TIME((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcDATE_AND_TIME((Long)value);
        }
        if (value instanceof Float) {
            return new PlcDATE_AND_TIME((Float)value);
        }
        if (value instanceof Double) {
            return new PlcDATE_AND_TIME((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcDATE_AND_TIME((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcDATE_AND_TIME((BigDecimal)value);
        }
        return new PlcDATE_AND_TIME(LocalDateTime.parse(value.toString()));
    }

    public static PlcDATE_AND_TIME ofSecondsSinceEpoch(long secondsSinceEpoch) {
        return new PlcDATE_AND_TIME(LocalDateTime.ofEpochSecond(secondsSinceEpoch, 0, ZoneOffset.UTC));
    }

    public static PlcDATE_AND_TIME ofSegments(int year, int month, int day, int hour, int minutes, int seconds, int nanoseconds) {
        return new PlcDATE_AND_TIME(LocalDateTime.of(year, month, day, hour, minutes, seconds, nanoseconds));
    }

    public PlcDATE_AND_TIME(Byte secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.byteValue(), 0, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(Short secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.shortValue(), 0, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(Integer secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.intValue(), 0, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(Long secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, 0, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(Float secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.longValue(), 0, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(Double secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.longValue(), 0, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(BigInteger secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.longValue(), 0, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(BigDecimal secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.longValue(), 0, ZoneOffset.UTC);
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(LocalDateTime value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcDATE_AND_TIME(int year, int month, int day, int hour, int minutes, int seconds, int nanoseconds) {
        this.value = LocalDateTime.of(year, month, day, hour, minutes, seconds, nanoseconds);
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE_AND_TIME;
    }

    public long getSecondsSinceEpoch() {
        Instant instant = this.getDateTime().toInstant(ZoneOffset.UTC);
        return instant.getEpochSecond();
    }

    public int getYear() {
        return ((LocalDateTime)this.value).getYear();
    }

    public int getMonth() {
        return ((LocalDateTime)this.value).getMonthValue();
    }

    public int getDay() {
        return ((LocalDateTime)this.value).getDayOfMonth();
    }

    public int getDayOfWeek() {
        return ((LocalDateTime)this.value).getDayOfWeek().getValue();
    }

    public int getHour() {
        return ((LocalDateTime)this.value).getHour();
    }

    public int getMinutes() {
        return ((LocalDateTime)this.value).getMinute();
    }

    public int getSeconds() {
        return ((LocalDateTime)this.value).getSecond();
    }

    public int getNanoseconds() {
        return ((LocalDateTime)this.value).getNano();
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDateTime)this.value).atZone(ZoneOffset.UTC).toInstant();
        return instant.getEpochSecond();
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalDateTime)this.value).toString();
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public LocalTime getTime() {
        return ((LocalDateTime)this.value).toLocalTime();
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public LocalDate getDate() {
        return ((LocalDateTime)this.value).toLocalDate();
    }

    @Override
    public boolean isDateTime() {
        return true;
    }

    @Override
    public LocalDateTime getDateTime() {
        return (LocalDateTime)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDateTime)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

