/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcLDATE
extends PlcIECValue<LocalDate> {
    public static PlcLDATE of(Object value) {
        if (value instanceof PlcLDATE) {
            return (PlcLDATE)value;
        }
        if (value instanceof LocalDate) {
            return new PlcLDATE((LocalDate)value);
        }
        if (value instanceof Byte) {
            return new PlcLDATE((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcLDATE((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcLDATE((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcLDATE((Long)value);
        }
        if (value instanceof Float) {
            return new PlcLDATE((Float)value);
        }
        if (value instanceof Double) {
            return new PlcLDATE((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcLDATE((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcLDATE((BigDecimal)value);
        }
        return new PlcLDATE(LocalDate.parse(value.toString()));
    }

    public static PlcLDATE ofNanosecondsSinceEpoch(BigInteger nanosecondsSinceEpoch) {
        BigInteger epochSecond = nanosecondsSinceEpoch.divide(BigInteger.valueOf(1000000L));
        BigInteger nanoOfSecond = nanosecondsSinceEpoch.mod(BigInteger.valueOf(1000000L));
        return new PlcLDATE(LocalDateTime.ofEpochSecond(epochSecond.longValue(), nanoOfSecond.intValue(), ZoneOffset.UTC).toLocalDate());
    }

    public PlcLDATE(LocalDate value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcLDATE(Byte secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.byteValue(), 0, ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcLDATE(Short secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.shortValue(), 0, ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcLDATE(Integer secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.intValue(), 0, ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcLDATE(Long secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, 0, ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcLDATE(Float secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.longValue(), 0, ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcLDATE(Double secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.longValue(), 0, ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcLDATE(BigInteger secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.longValue(), 0, ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcLDATE(BigDecimal secondsSinceEpoch) {
        this.value = LocalDateTime.ofEpochSecond(secondsSinceEpoch.longValue(), 0, ZoneOffset.UTC).toLocalDate();
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE;
    }

    public BigInteger getNanosecondsSinceEpoch() {
        Instant instant = this.getDateTime().toInstant(ZoneOffset.UTC);
        return BigInteger.valueOf(instant.getEpochSecond()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(instant.getNano()));
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDate)this.value).atStartOfDay(ZoneOffset.UTC).toInstant();
        return instant.toEpochMilli() / 1000L;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalDate)this.value).toString();
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public LocalDate getDate() {
        return (LocalDate)this.value;
    }

    @Override
    public LocalDateTime getDateTime() {
        return ((LocalDate)this.value).atStartOfDay();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDate)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

