/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcLDATE_AND_TIME
extends PlcIECValue<LocalDateTime> {
    public static PlcLDATE_AND_TIME of(Object value) {
        if (value instanceof PlcLDATE_AND_TIME) {
            return (PlcLDATE_AND_TIME)value;
        }
        if (value instanceof LocalDateTime) {
            return new PlcLDATE_AND_TIME((LocalDateTime)value);
        }
        if (value instanceof Byte) {
            return new PlcLDATE_AND_TIME((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcLDATE_AND_TIME((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcLDATE_AND_TIME((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcLDATE_AND_TIME((Long)value);
        }
        if (value instanceof Float) {
            return new PlcLDATE_AND_TIME((Float)value);
        }
        if (value instanceof Double) {
            return new PlcLDATE_AND_TIME((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcLDATE_AND_TIME((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcLDATE_AND_TIME((BigDecimal)value);
        }
        return new PlcLDATE_AND_TIME(LocalDateTime.parse(value.toString()));
    }

    public static PlcLDATE_AND_TIME ofNanosecondsSinceEpoch(BigInteger nanosecondsSinceEpoch) {
        BigInteger epochSecond = nanosecondsSinceEpoch.divide(BigInteger.valueOf(1000000L));
        BigInteger nanoOfSecond = nanosecondsSinceEpoch.mod(BigInteger.valueOf(1000000L));
        return new PlcLDATE_AND_TIME(LocalDateTime.ofEpochSecond(epochSecond.longValue(), nanoOfSecond.intValue(), ZoneOffset.UTC));
    }

    public PlcLDATE_AND_TIME(Byte millisecondsSinceEpoch) {
        long daysSinceEpoch = 0L;
        long millisecondsOfDay = millisecondsSinceEpoch.longValue();
        this.value = LocalDateTime.of(LocalDate.ofEpochDay(daysSinceEpoch), LocalTime.ofNanoOfDay(millisecondsOfDay * 1000000L));
        this.isNullable = false;
    }

    public PlcLDATE_AND_TIME(Short millisecondsSinceEpoch) {
        long daysSinceEpoch = 0L;
        long millisecondsOfDay = millisecondsSinceEpoch.longValue();
        this.value = LocalDateTime.of(LocalDate.ofEpochDay(daysSinceEpoch), LocalTime.ofNanoOfDay(millisecondsOfDay * 1000000L));
        this.isNullable = false;
    }

    public PlcLDATE_AND_TIME(Integer millisecondsSinceEpoch) {
        long daysSinceEpoch = millisecondsSinceEpoch.longValue() / 86400000L;
        long millisecondsOfDay = millisecondsSinceEpoch.longValue() % 86400000L;
        this.value = LocalDateTime.of(LocalDate.ofEpochDay(daysSinceEpoch), LocalTime.ofNanoOfDay(millisecondsOfDay * 1000000L));
        this.isNullable = false;
    }

    public PlcLDATE_AND_TIME(Long millisecondsSinceEpoch) {
        long daysSinceEpoch = millisecondsSinceEpoch / 86400000L;
        long millisecondsOfDay = millisecondsSinceEpoch % 86400000L;
        this.value = LocalDateTime.of(LocalDate.ofEpochDay(daysSinceEpoch), LocalTime.ofNanoOfDay(millisecondsOfDay * 1000000L));
        this.isNullable = false;
    }

    public PlcLDATE_AND_TIME(Float millisecondsSinceEpoch) {
        long daysSinceEpoch = millisecondsSinceEpoch.longValue() / 86400000L;
        long millisecondsOfDay = millisecondsSinceEpoch.longValue() % 86400000L;
        this.value = LocalDateTime.of(LocalDate.ofEpochDay(daysSinceEpoch), LocalTime.ofNanoOfDay(millisecondsOfDay * 1000000L));
        this.isNullable = false;
    }

    public PlcLDATE_AND_TIME(Double millisecondsSinceEpoch) {
        long daysSinceEpoch = millisecondsSinceEpoch.longValue() / 86400000L;
        long millisecondsOfDay = millisecondsSinceEpoch.longValue() % 86400000L;
        this.value = LocalDateTime.of(LocalDate.ofEpochDay(daysSinceEpoch), LocalTime.ofNanoOfDay(millisecondsOfDay * 1000000L));
        this.isNullable = false;
    }

    public PlcLDATE_AND_TIME(BigInteger millisecondsSinceEpoch) {
        long daysSinceEpoch = millisecondsSinceEpoch.longValue() / 86400000L;
        long millisecondsOfDay = millisecondsSinceEpoch.longValue() % 86400000L;
        this.value = LocalDateTime.of(LocalDate.ofEpochDay(daysSinceEpoch), LocalTime.ofNanoOfDay(millisecondsOfDay * 1000000L));
        this.isNullable = false;
    }

    public PlcLDATE_AND_TIME(BigDecimal millisecondsSinceEpoch) {
        long daysSinceEpoch = millisecondsSinceEpoch.longValue() / 86400000L;
        long millisecondsOfDay = millisecondsSinceEpoch.longValue() % 86400000L;
        this.value = LocalDateTime.of(LocalDate.ofEpochDay(daysSinceEpoch), LocalTime.ofNanoOfDay(millisecondsOfDay * 1000000L));
        this.isNullable = false;
    }

    public PlcLDATE_AND_TIME(LocalDateTime value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE_AND_TIME;
    }

    public BigInteger getNanosecondsSinceEpoch() {
        Instant instant = this.getDateTime().toInstant(ZoneOffset.UTC);
        return BigInteger.valueOf(instant.getEpochSecond()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(instant.getNano()));
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDateTime)this.value).atZone(ZoneOffset.UTC).toInstant();
        return instant.getEpochSecond();
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalDateTime)this.value).toString();
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public LocalTime getTime() {
        return ((LocalDateTime)this.value).toLocalTime();
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public LocalDate getDate() {
        return ((LocalDateTime)this.value).toLocalDate();
    }

    @Override
    public boolean isDateTime() {
        return true;
    }

    @Override
    public LocalDateTime getDateTime() {
        return (LocalDateTime)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDateTime)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

