/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;
import org.apache.plc4x.java.spi.values.PlcSINT;

public class PlcRawByteArray
extends PlcIECValue<byte[]> {
    public static PlcRawByteArray of(Object value) {
        if (value instanceof PlcRawByteArray) {
            return (PlcRawByteArray)value;
        }
        if (value instanceof byte[]) {
            return new PlcRawByteArray((byte[])value);
        }
        throw new IllegalArgumentException("Only byte[] supported here");
    }

    public PlcRawByteArray(byte[] value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.RAW_BYTE_ARRAY;
    }

    @Override
    public byte[] getRaw() {
        return (byte[])this.value;
    }

    public String toString() {
        return Hex.encodeHexString((byte[])((byte[])this.value));
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeByteArray(this.getClass().getSimpleName(), (byte[])this.value, new WithWriterArgs[0]);
    }

    @Override
    public boolean isList() {
        return true;
    }

    public List<PlcValue> getList() {
        ArrayList<PlcValue> shortList = new ArrayList<PlcValue>(((byte[])this.value).length);
        byte[] byArray = (byte[])this.value;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            shortList.add(new PlcSINT(Short.valueOf(b)));
            ++n2;
        }
        return shortList;
    }
}

