/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcSTRING
extends PlcIECValue<String> {
    public static PlcSTRING of(Object value) {
        if (value instanceof PlcSTRING) {
            return (PlcSTRING)value;
        }
        if (value instanceof String) {
            return new PlcSTRING((String)value);
        }
        return new PlcSTRING(String.valueOf(value));
    }

    public PlcSTRING(String value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.STRING;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return (String)this.value;
    }

    @Override
    public boolean isBoolean() {
        try {
            Boolean.parseBoolean((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean getBoolean() {
        return Boolean.parseBoolean((String)this.value);
    }

    @Override
    public boolean isByte() {
        try {
            Byte.parseByte((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public byte getByte() {
        return Byte.parseByte((String)this.value);
    }

    @Override
    public boolean isShort() {
        try {
            Short.parseShort((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public short getShort() {
        return Short.parseShort((String)this.value);
    }

    @Override
    public boolean isInteger() {
        try {
            Integer.parseInt((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int getInteger() {
        return Integer.parseInt((String)this.value);
    }

    @Override
    public boolean isLong() {
        try {
            Long.parseLong((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public long getLong() {
        return Long.parseLong((String)this.value);
    }

    @Override
    public boolean isBigInteger() {
        try {
            new BigInteger((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public BigInteger getBigInteger() {
        return new BigInteger((String)this.value);
    }

    @Override
    public boolean isFloat() {
        try {
            Float.parseFloat((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public float getFloat() {
        return Float.parseFloat((String)this.value);
    }

    @Override
    public boolean isDouble() {
        try {
            Double.parseDouble((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public double getDouble() {
        return Double.parseDouble((String)this.value);
    }

    @Override
    public boolean isBigDecimal() {
        try {
            new BigDecimal((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal((String)this.value);
    }

    @Override
    public int getLength() {
        return ((String)this.value).length();
    }

    public String toString() {
        return (String)this.value;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = (String)this.value;
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

