/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcTIME_OF_DAY
extends PlcIECValue<LocalTime> {
    public static PlcTIME_OF_DAY of(Object value) {
        if (value instanceof PlcTIME_OF_DAY) {
            return (PlcTIME_OF_DAY)value;
        }
        if (value instanceof LocalTime) {
            return new PlcTIME_OF_DAY((LocalTime)value);
        }
        if (value instanceof Byte) {
            return new PlcTIME_OF_DAY((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcTIME_OF_DAY((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcTIME_OF_DAY((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcTIME_OF_DAY((Long)value);
        }
        if (value instanceof Float) {
            return new PlcTIME_OF_DAY((Float)value);
        }
        if (value instanceof Double) {
            return new PlcTIME_OF_DAY((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcTIME_OF_DAY((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcTIME_OF_DAY((BigDecimal)value);
        }
        return new PlcTIME_OF_DAY(LocalTime.parse(value.toString()));
    }

    public static PlcTIME_OF_DAY ofMillisecondsSinceMidnight(long millisecondsSinceMidnight) {
        return new PlcTIME_OF_DAY(LocalTime.ofNanoOfDay(millisecondsSinceMidnight * 1000000L));
    }

    public PlcTIME_OF_DAY(Byte secondsSinceMidnight) {
        this.value = LocalTime.ofSecondOfDay(secondsSinceMidnight.byteValue());
        this.isNullable = false;
    }

    public PlcTIME_OF_DAY(Short secondsSinceMidnight) {
        this.value = LocalTime.ofSecondOfDay(secondsSinceMidnight.shortValue());
        this.isNullable = false;
    }

    public PlcTIME_OF_DAY(Integer secondsSinceMidnight) {
        this.value = LocalTime.ofSecondOfDay(secondsSinceMidnight.intValue());
        this.isNullable = false;
    }

    public PlcTIME_OF_DAY(Long secondsSinceMidnight) {
        this.value = LocalTime.ofSecondOfDay(secondsSinceMidnight);
        this.isNullable = false;
    }

    public PlcTIME_OF_DAY(Float secondsSinceMidnight) {
        this.value = LocalTime.ofSecondOfDay(secondsSinceMidnight.longValue());
        this.isNullable = false;
    }

    public PlcTIME_OF_DAY(Double secondsSinceMidnight) {
        this.value = LocalTime.ofSecondOfDay(secondsSinceMidnight.longValue());
        this.isNullable = false;
    }

    public PlcTIME_OF_DAY(BigInteger secondsSinceMidnight) {
        this.value = LocalTime.ofSecondOfDay(secondsSinceMidnight.longValue());
        this.isNullable = false;
    }

    public PlcTIME_OF_DAY(BigDecimal secondsSinceMidnight) {
        this.value = LocalTime.ofSecondOfDay(secondsSinceMidnight.longValue());
        this.isNullable = false;
    }

    public PlcTIME_OF_DAY(LocalTime value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.TIME_OF_DAY;
    }

    public long getMillisecondsSinceMidnight() {
        return ((LocalTime)this.value).toNanoOfDay() / 1000000L;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return this.getMillisecondsSinceMidnight();
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalTime)this.value).toString();
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public LocalTime getTime() {
        return (LocalTime)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalTime)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

