/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcUDINT
extends PlcIECValue<Long> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    public static final Long MIN_VALUE = 0L;
    public static final Long MAX_VALUE = 0xFFFFFFFFL;

    public static PlcUDINT of(Object value) {
        if (value instanceof PlcUDINT) {
            return (PlcUDINT)value;
        }
        if (value instanceof Boolean) {
            return new PlcUDINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcUDINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcUDINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcUDINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcUDINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcUDINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcUDINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcUDINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcUDINT((BigDecimal)value);
        }
        return new PlcUDINT(value.toString());
    }

    public PlcUDINT(Boolean value) {
        this.value = value != false ? 1L : 0L;
        this.isNullable = false;
    }

    public PlcUDINT(Byte value) {
        if ((long)value.byteValue() < MIN_VALUE || (long)value.byteValue() > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcUDINT(Short value) {
        if ((long)value.shortValue() < MIN_VALUE || (long)value.shortValue() > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcUDINT(Integer value) {
        if ((long)value.intValue() < MIN_VALUE || (long)value.intValue() > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcUDINT(Long value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcUDINT(Float value) {
        if (value.floatValue() < (float)MIN_VALUE.longValue() || value.floatValue() > (float)MAX_VALUE.longValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcUDINT(Double value) {
        if (value < (double)MIN_VALUE.longValue() || value > (double)MAX_VALUE.longValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcUDINT(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(MIN_VALUE)) < 0 || value.compareTo(BigInteger.valueOf(MAX_VALUE)) > 0) {
            throw new PlcInvalidTagException("Value of type " + value + " is out of range " + MIN_VALUE + " - " + MAX_VALUE + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.longValue();
        this.isNullable = true;
    }

    public PlcUDINT(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(MIN_VALUE)) < 0 || value.compareTo(BigDecimal.valueOf(MAX_VALUE)) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = true;
    }

    public PlcUDINT(String value) {
        try {
            long val = Long.parseLong(value.trim());
            if (val < MIN_VALUE || val > MAX_VALUE) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
    }

    public PlcUDINT(long value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.UDINT;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Long)this.value).equals(0L);
    }

    @Override
    public boolean isByte() {
        return this.value != null && (Long)this.value <= 127L && (Long)this.value >= -128L;
    }

    @Override
    public byte getByte() {
        return ((Long)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && (Long)this.value <= 32767L && (Long)this.value >= -32768L;
    }

    @Override
    public short getShort() {
        return ((Long)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return this.value != null && (Long)this.value <= Integer.MAX_VALUE && (Long)this.value >= Integer.MIN_VALUE;
    }

    @Override
    public int getInteger() {
        return ((Long)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return (Long)this.value;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf((Long)this.value);
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Long)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Long)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getDouble());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return Long.toString((Long)this.value);
    }

    @Override
    public byte[] getRaw() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Long)this.value >> 24 & 0xFFL), (byte)((Long)this.value >> 16 & 0xFFL), (byte)((Long)this.value >> 8 & 0xFFL), (byte)((Long)this.value & 0xFFL)};
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeLong(this.getClass().getSimpleName(), 32, (Long)this.value, new WithWriterArgs[0]);
    }
}

