/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.plc4x.java.api.EventPlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcIoException;
import org.apache.plc4x.java.api.listener.ConnectionStateListener;
import org.apache.plc4x.java.api.listener.EventListener;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.AbstractPlcConnection;
import org.apache.plc4x.java.spi.connection.ChannelExposingConnection;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.events.CloseConnectionEvent;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.events.DisconnectEvent;
import org.apache.plc4x.java.spi.events.DisconnectedEvent;
import org.apache.plc4x.java.spi.events.DiscoverEvent;
import org.apache.plc4x.java.spi.events.DiscoveredEvent;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNettyPlcConnection
extends AbstractPlcConnection
implements ChannelExposingConnection,
EventPlcConnection {
    protected static final Timer timer = new HashedWheelTimer();
    protected static final long DEFAULT_DISCONNECT_WAIT_TIME = 10000L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultNettyPlcConnection.class);
    protected final Configuration configuration;
    protected final ChannelFactory channelFactory;
    protected final boolean awaitSessionSetupComplete;
    protected final boolean awaitSessionDisconnectComplete;
    protected final boolean awaitSessionDiscoverComplete;
    protected final ProtocolStackConfigurer stackConfigurer;
    protected final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
    protected final CompletableFuture<Void> sessionDisconnectCompleteFuture = new CompletableFuture();
    protected Channel channel;
    protected boolean connected;

    public DefaultNettyPlcConnection(boolean canRead, boolean canWrite, boolean canSubscribe, PlcFieldHandler fieldHandler, PlcValueHandler valueHandler, Configuration configuration, ChannelFactory channelFactory, boolean awaitSessionSetupComplete, boolean awaitSessionDisconnectComplete, boolean awaitSessionDiscoverComplete, ProtocolStackConfigurer stackConfigurer, BaseOptimizer optimizer) {
        super(canRead, canWrite, canSubscribe, fieldHandler, valueHandler, optimizer);
        this.configuration = configuration;
        this.channelFactory = channelFactory;
        this.awaitSessionSetupComplete = awaitSessionSetupComplete;
        this.awaitSessionDisconnectComplete = awaitSessionDisconnectComplete;
        this.awaitSessionDiscoverComplete = awaitSessionDiscoverComplete;
        this.stackConfigurer = stackConfigurer;
        this.connected = false;
    }

    public void connect() throws PlcConnectionException {
        try {
            CompletableFuture<Void> sessionSetupCompleteFuture = new CompletableFuture<Void>();
            CompletableFuture<Configuration> sessionDiscoveredCompleteFuture = new CompletableFuture<Configuration>();
            if (this.channelFactory == null) {
                throw new PlcConnectionException("No channel factory provided");
            }
            ConfigurationFactory.configure(this.configuration, this.channelFactory);
            if (this.awaitSessionDiscoverComplete) {
                this.channel = this.channelFactory.createChannel(this.getChannelHandler(sessionSetupCompleteFuture, this.sessionDisconnectCompleteFuture, sessionDiscoveredCompleteFuture));
                this.channel.closeFuture().addListener(future -> {
                    if (!sessionDiscoveredCompleteFuture.isDone()) {
                        try {
                            sessionDiscoveredCompleteFuture.complete(null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                this.channel.pipeline().fireUserEventTriggered((Object)new DiscoverEvent());
                sessionDiscoveredCompleteFuture.get();
            }
            this.channel = this.channelFactory.createChannel(this.getChannelHandler(sessionSetupCompleteFuture, this.sessionDisconnectCompleteFuture, sessionDiscoveredCompleteFuture));
            this.channel.closeFuture().addListener(future -> {
                if (!sessionSetupCompleteFuture.isDone()) {
                    sessionSetupCompleteFuture.completeExceptionally((Throwable)new PlcIoException("Connection terminated by remote"));
                }
            });
            this.sendChannelCreatedEvent();
            if (this.awaitSessionSetupComplete) {
                sessionSetupCompleteFuture.get();
            }
            this.connected = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new PlcConnectionException((Throwable)e);
        }
    }

    public void close() throws PlcConnectionException {
        logger.debug("Closing connection to PLC, await for disconnect = {}", (Object)this.awaitSessionDisconnectComplete);
        this.channel.pipeline().fireUserEventTriggered((Object)new DisconnectEvent());
        try {
            if (this.awaitSessionDisconnectComplete) {
                this.sessionDisconnectCompleteFuture.get(10000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            logger.error("Timeout while trying to close connection");
        }
        this.channel.pipeline().fireUserEventTriggered((Object)new CloseConnectionEvent());
        this.channel.close().awaitUninterruptibly();
        if (!this.sessionDisconnectCompleteFuture.isDone()) {
            this.sessionDisconnectCompleteFuture.complete(null);
        }
        this.channel = null;
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected && this.channel.isActive();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public ChannelHandler getChannelHandler(final CompletableFuture<Void> sessionSetupCompleteFuture, final CompletableFuture<Void> sessionDisconnectCompleteFuture, final CompletableFuture<Configuration> sessionDiscoverCompleteFuture) {
        if (this.stackConfigurer == null) {
            throw new IllegalStateException("No Protocol Stack Configurer is given!");
        }
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        Stream<ConnectionStateListener> eventListeners = DefaultNettyPlcConnection.this.listeners.stream().filter(ConnectionStateListener.class::isInstance).map(ConnectionStateListener.class::cast);
                        if (evt instanceof ConnectedEvent) {
                            sessionSetupCompleteFuture.complete(null);
                            eventListeners.forEach(ConnectionStateListener::connected);
                        } else if (evt instanceof DisconnectedEvent) {
                            sessionDisconnectCompleteFuture.complete(null);
                            eventListeners.forEach(ConnectionStateListener::disconnected);
                        } else if (evt instanceof DiscoveredEvent) {
                            sessionDiscoverCompleteFuture.complete(((DiscoveredEvent)evt).getConfiguration());
                        } else {
                            super.userEventTriggered(ctx, evt);
                        }
                    }
                }});
                DefaultNettyPlcConnection.this.channelFactory.initializePipeline(pipeline);
                DefaultNettyPlcConnection.this.setProtocol(DefaultNettyPlcConnection.this.stackConfigurer.configurePipeline(DefaultNettyPlcConnection.this.configuration, pipeline, DefaultNettyPlcConnection.this.channelFactory.isPassive()));
            }
        };
    }

    protected void sendChannelCreatedEvent() {
        logger.trace("Channel was created, firing ChannelCreated Event");
        this.channel.pipeline().fireUserEventTriggered((Object)new ConnectEvent());
    }

    public void addEventListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }
}

