/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcDriver;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.DefaultNettyPlcConnection;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.transport.Transport;

public abstract class GeneratedDriverBase<BASE_PACKET extends Message>
implements PlcDriver {
    public static final String PROPERTY_PLC4X_FORCE_AWAIT_SETUP_COMPLETE = "PLC4X_FORCE_AWAIT_SETUP_COMPLETE";
    public static final String PROPERTY_PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE = "PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE";
    public static final String PROPERTY_PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE = "PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE";
    private static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>[a-z0-9\\-]*)(:(?<transportCode>[a-z0-9]*))?://(?<transportConfig>[^?]*)(\\?(?<paramString>.*))?");

    protected abstract Class<? extends Configuration> getConfigurationType();

    protected boolean canRead() {
        return false;
    }

    protected boolean canWrite() {
        return false;
    }

    protected boolean canSubscribe() {
        return false;
    }

    protected boolean awaitSetupComplete() {
        return true;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean awaitDiscoverComplete() {
        return false;
    }

    protected BaseOptimizer getOptimizer() {
        return null;
    }

    protected abstract PlcFieldHandler getFieldHandler();

    protected abstract PlcValueHandler getValueHandler();

    protected abstract String getDefaultTransport();

    protected abstract ProtocolStackConfigurer<BASE_PACKET> getStackConfigurer();

    protected ProtocolStackConfigurer<BASE_PACKET> getStackConfigurer(Transport transport) {
        return this.getStackConfigurer();
    }

    protected void initializePipeline(ChannelFactory channelFactory) {
    }

    public PlcConnection getConnection(String connectionString) throws PlcConnectionException {
        Matcher matcher = URI_PATTERN.matcher(connectionString);
        if (!matcher.matches()) {
            throw new PlcConnectionException("Connection string doesn't match the format '{protocol-code}:({transport-code})?//{transport-address}(?{parameter-string)?'");
        }
        String protocolCode = matcher.group("protocolCode");
        String transportCode = matcher.group("transportCode") != null ? matcher.group("transportCode") : this.getDefaultTransport();
        String transportConfig = matcher.group("transportConfig");
        String paramString = matcher.group("paramString");
        if (!protocolCode.equals(this.getProtocolCode())) {
            throw new PlcConnectionException("This driver is not suited to handle this connection string");
        }
        Configuration configuration = new ConfigurationFactory().createConfiguration(this.getConfigurationType(), paramString);
        if (configuration == null) {
            throw new PlcConnectionException("Unsupported configuration");
        }
        Transport transport = null;
        ServiceLoader<Transport> transportLoader = ServiceLoader.load(Transport.class, Thread.currentThread().getContextClassLoader());
        for (Transport curTransport : transportLoader) {
            if (!curTransport.getTransportCode().equals(transportCode)) continue;
            transport = curTransport;
            break;
        }
        if (transport == null) {
            throw new PlcConnectionException("Unsupported transport " + transportCode);
        }
        ConfigurationFactory.configure(configuration, transport);
        ChannelFactory channelFactory = transport.createChannelFactory(transportConfig);
        if (channelFactory == null) {
            throw new PlcConnectionException("Unable to get channel factory from url " + transportConfig);
        }
        ConfigurationFactory.configure(configuration, channelFactory);
        this.initializePipeline(channelFactory);
        boolean awaitSetupComplete = this.awaitSetupComplete();
        if (System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_SETUP_COMPLETE) != null) {
            awaitSetupComplete = Boolean.parseBoolean(System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_SETUP_COMPLETE));
        }
        boolean awaitDisconnectComplete = this.awaitDisconnectComplete();
        if (System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE) != null) {
            awaitDisconnectComplete = Boolean.parseBoolean(System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE));
        }
        boolean awaitDiscoverComplete = this.awaitDiscoverComplete();
        if (System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE) != null) {
            awaitDiscoverComplete = Boolean.parseBoolean(System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE));
        }
        return new DefaultNettyPlcConnection(this.canRead(), this.canWrite(), this.canSubscribe(), this.getFieldHandler(), this.getValueHandler(), configuration, channelFactory, awaitSetupComplete, awaitDisconnectComplete, awaitDiscoverComplete, this.getStackConfigurer(transport), this.getOptimizer());
    }

    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        throw new PlcConnectionException("Authentication not supported.");
    }
}

