/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.spi.GeneratedDriverByteToMessageCodec;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

public class GeneratedProtocolMessageCodec<BASE_PACKET_CLASS extends Message>
extends GeneratedDriverByteToMessageCodec<BASE_PACKET_CLASS> {
    private final ToIntFunction<ByteBuf> packetSizeEstimator;
    private final Consumer<ByteBuf> corruptPackageRemover;

    public GeneratedProtocolMessageCodec(Class<BASE_PACKET_CLASS> basePacketClass, MessageIO<BASE_PACKET_CLASS, BASE_PACKET_CLASS> messageIO, boolean bigEndian, Object[] parserArgs, ToIntFunction<ByteBuf> packetSizeEstimator, Consumer<ByteBuf> corruptPackageRemover) {
        super(messageIO, basePacketClass, bigEndian, parserArgs);
        this.packetSizeEstimator = packetSizeEstimator;
        this.corruptPackageRemover = corruptPackageRemover;
    }

    @Override
    protected int getPacketSize(ByteBuf byteBuf) {
        if (this.packetSizeEstimator == null) {
            return byteBuf.readableBytes();
        }
        return this.packetSizeEstimator.applyAsInt(byteBuf);
    }

    @Override
    protected void removeRestOfCorruptPackage(ByteBuf byteBuf) {
        if (this.corruptPackageRemover != null) {
            this.corruptPackageRemover.accept(byteBuf);
        }
    }
}

