/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.BufferCommons;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class WriteBufferJsonBased
implements WriteBuffer,
BufferCommons,
AutoCloseable {
    public static final String PLC4X_ATTRIBUTE_FORMAT = "%s__plc4x_%s";
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final JsonGenerator generator;
    private int depth = 0;
    private final boolean doRenderAttr;

    public WriteBufferJsonBased() {
        this(true);
    }

    public WriteBufferJsonBased(boolean doRenderAttr) {
        this.doRenderAttr = doRenderAttr;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        JsonFactory jsonFactory = new JsonFactoryBuilder().build();
        try {
            this.generator = jsonFactory.createGenerator((OutputStream)this.byteArrayOutputStream);
            this.generator.useDefaultPrettyPrinter();
        }
        catch (IOException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    @Override
    public int getPos() {
        return 0;
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        try {
            if (this.depth == 0) {
                this.generator.writeStartObject();
            }
            ++this.depth;
            if (this.isToBeRenderedAsList(writerArgs)) {
                this.generator.writeArrayFieldStart(sanitizedLogicalName);
            } else {
                if (this.generator.getOutputContext().inArray()) {
                    this.generator.writeStartObject();
                }
                this.generator.writeObjectFieldStart(sanitizedLogicalName);
            }
        }
        catch (IOException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    @Override
    public void writeBit(String logicalName, boolean value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "bit", 1, writerArgs);
            this.generator.writeBooleanField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeByte(String logicalName, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "byte", 8, writerArgs);
            this.generator.writeStringField(sanitizedLogicalName, String.format("0x%02x", value));
        });
    }

    @Override
    public void writeByteArray(String logicalName, byte[] bytes, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        StringBuilder hexString = new StringBuilder("0x");
        for (byte aByte : bytes) {
            hexString.append(String.format("%02x", aByte));
        }
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "byte", bytes.length * 8, writerArgs);
            this.generator.writeStringField(sanitizedLogicalName, hexString.toString());
        });
    }

    @Override
    public void writeUnsignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, (short)value);
        });
    }

    @Override
    public void writeUnsignedShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(logicalName, value);
        });
    }

    @Override
    public void writeUnsignedInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeUnsignedLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeUnsignedBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeSignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, (short)value);
        });
    }

    @Override
    public void writeShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeFloat(String logicalName, float value, int bitsExponent, int bitsMantissa, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            int bitLength = (value < 0.0f ? 1 : 0) + bitsExponent + bitsMantissa;
            this.writeAttr(sanitizedLogicalName, "float", bitLength, writerArgs);
            this.generator.writeNumberField(logicalName, value);
        });
    }

    @Override
    public void writeDouble(String logicalName, double value, int bitsExponent, int bitsMantissa, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            int bitLength = (value < 0.0 ? 1 : 0) + bitsExponent + bitsMantissa;
            this.writeAttr(sanitizedLogicalName, "float", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeBigDecimal(String logicalName, int bitLength, BigDecimal value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "float", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void writeString(String logicalName, int bitLength, String encoding, String value, WithWriterArgs ... writerArgs) throws ParseException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "string", bitLength, writerArgs);
            this.generator.writeStringField(String.format(PLC4X_ATTRIBUTE_FORMAT, sanitizedLogicalName, "encoding"), encoding);
            this.generator.writeStringField(sanitizedLogicalName, value);
        });
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
        try {
            if (this.isToBeRenderedAsList(writerArgs)) {
                this.generator.writeEndArray();
            } else {
                this.generator.writeEndObject();
                if (this.generator.getOutputContext().getParent().inArray()) {
                    this.generator.writeEndObject();
                }
            }
            --this.depth;
            if (this.depth == 0) {
                this.generator.writeEndObject();
                this.generator.flush();
            }
        }
        catch (IOException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    public void wrapIfNecessary(RunWrapped runnable) throws ParseException {
        boolean inArray = this.generator.getOutputContext().inArray();
        if (inArray) {
            try {
                this.generator.writeStartObject();
            }
            catch (IOException e) {
                throw new ParseException("Error opening wrap", e);
            }
        }
        try {
            runnable.run();
        }
        catch (IOException e) {
            throw new ParseException("Error running wrap", e);
        }
        if (inArray) {
            try {
                this.generator.writeEndObject();
            }
            catch (IOException e) {
                throw new ParseException("Error closing wrap", e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.generator.close();
    }

    public String getJsonString() {
        try {
            return this.byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    private void writeAttr(String logicalName, String dataType, int bitLength, WithWriterArgs ... writerArgs) throws IOException {
        if (!this.doRenderAttr) {
            return;
        }
        this.generator.writeStringField(String.format(PLC4X_ATTRIBUTE_FORMAT, logicalName, "dataType"), dataType);
        this.generator.writeNumberField(String.format(PLC4X_ATTRIBUTE_FORMAT, logicalName, "bitLength"), bitLength);
        String stringRepresentation = this.extractAdditionalStringRepresentation(writerArgs);
        if (stringRepresentation != null) {
            this.generator.writeStringField(String.format(PLC4X_ATTRIBUTE_FORMAT, logicalName, "stringRepresentation"), stringRepresentation);
        }
    }

    @FunctionalInterface
    private static interface RunWrapped {
        public void run() throws IOException;
    }
}

