/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcList;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcBitString
extends PlcList {
    public PlcBitString(short byteBitString) {
        super(PlcBitString.toBitString(BigInteger.valueOf(byteBitString), 8));
    }

    public PlcBitString(int wordBitString) {
        super(PlcBitString.toBitString(BigInteger.valueOf(wordBitString), 16));
    }

    public PlcBitString(long dwordBitString) {
        super(PlcBitString.toBitString(BigInteger.valueOf(dwordBitString), 32));
    }

    public PlcBitString(BigInteger lwordBitString) {
        super(PlcBitString.toBitString(lwordBitString, 64));
    }

    public static List<PlcValue> toBitString(BigInteger bigInteger, int numBits) {
        if (bigInteger.bitCount() > numBits) {
            throw new PlcRuntimeException("value too big");
        }
        ArrayList<PlcValue> values = new ArrayList<PlcValue>(numBits);
        for (int i = numBits - 1; i >= 0; --i) {
            values.add(new PlcBOOL(bigInteger.testBit(i)));
        }
        return values;
    }
}

